/*---------------------------------------------------------------------------*\
|   Check Password replication                (C) Alain Rykaert - APR98-APR98 |
\*---------------------------------------------------------------------------*/
    Version = '1.01'             /* thanks to jacques from morgan euroclear*/
   '@cls'
    Say '* LSNLCHCK Version' Version

    Call Init                                 /* init dll's and other stuff*/

    LogFileName = 'LSNLCHK.LOG'                          /* Output filename*/
    Say '* Log Filename:' LogFileName

    TempFile = LSRDrive'\ibmlan\getroute.txt'             /* temporary file*/

    Parse Upper Arg DCName MacAddress

    If DCName = ''
      Then Do
             Say '*'
             Say '* Get LAN Server routing configuration'
             Say '*'
             Say '* Usage: GETROUTE {DCName} {Destination Address}'
             Say '*'
             Say '* Sample: GETROUTE \\BEDDC01 400013203745'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')

    Say '* Server Name:' '\\'DCName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Call ChkError RC

    RC = NetGetInfo(340, 'Server', '\\'DCName, 'Servers')/* get all servers*/
    If RC = 0
      Then Do
             Call RxStemSort 'Server'
             Say '* Total defined servers:' Server.0
             Say '* Scanning active servers...'
             Call SysCurState Off
             Parse Value SysCurPos() With Row Col
             j = 0
             Do i = 1 to Server.0           /* get only the 'alive' servers*/
               Call SysCurPos Row -1, 28
               Say ESC'[K' i Server.i
           /*  If Stream('\\'Server.i'\ibmlan$\ibmlan.ini', 'C','Query Exists') <> '' */
               If NetGetInfo(370, 'ServerModalInfo', '\\'Server.i) = 0
                 Then Do
                        j = j + 1
                        ServerName.j = Server.i
                      End
                 Else Nop
             End
           End
      Else Call ChkError RC

    ServerName.0 = j                             /* total of active servers*/

    Do i = 1 to ServerName.0
      IniFileName = '\\'ServerName.i'\ibmlan$\accounts\net.acc'
      Say '* Servername:' Left(ServerName.i,9),
             Stream(IniFileName, 'C', 'Query DateTime'),
             Stream(IniFileName, 'C', 'Query Size')
    End

    Say
    Say '* Total Time:' Trunc(Time('E'),2)

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    ESC = '1B'x
    Redir = '>nul'

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Translate(Value('DPATH',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', PPath) -2
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '* Could not determine the Lan Requester path'
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd LoadLsRxutFuncs, LSRXUT, LoadLsRxutFuncs
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd RxLoadFuncs, RXUTILS, RxLoadFuncs
             Call RxLoadFuncs
           End
      Else Nop

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '* Error:' RCode
    Exit X2D('1600')

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit
           End
      Else Nop

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg Log_Text

    If LineOut(LogFileName, Log_Text) = 0
      Then Call Stream LogFileName, 'C', 'Close'
      Else Say '! Error while writing:' LogFileName '07'x

    Return

 OS2PING:/* ----------------------------------------------------------------*/

    Parse Arg Address

   '@os2ping /a='Address '/r /w=1 2>nul | Find "(" >' TempFile
    If RC = 0                          /* MAC not found                    */
      Then Do
             MCheck = 0
             Route = LineIn(TempFile)
             Call Stream TempFile, 'C', 'Close'
           End
      Else MCheck = 1

    Return

