/*---------------------------------------------------------------------------*\
|   GET all Application-Selector from a LS 3.0 and higher                     |
|   and dump it to an ASCII File                                              |
|                                     (C) Alain Rykaert - IBM-Belgium - MAY96 |
\*---------------------------------------------------------------------------*/

    Parse Arg Option

    Call INIT                    /* Initialisation of DLL's and other stuff*/
    Call CHKOPT                          /* Check Options & display Welcome*/
    Call CHKPWS                               /* Check the PWS & Admin name*/
    Call MAIN                                            /* do the main job*/
    Call QUIT                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call Time('R')
   'if exist' OUTF 'del' OUTF
    Call LineOut OUTF, '* Place a "X" on each user you want to select an application'

    RC = NetEnumerate(30, 'APPLNAME', '\\'SRVNAME)
    if RC = 0
     then Call RxStemSort 'APPLNAME'
     else do
             Call LOGIT 'Get Applications', SRVNAME, RC
             Return
          end

    UL = 1                             /* Determine the Maximum USER length*/
 /* RC = NetEnumerate(280, 'USERS', '\\'SRVNAME) */
    RC = WfrxUserEnum('\\'SRVNAME,'USERS')
    if RC = 0
     then do i = 1 to USERS.0
             if Length(USERS.i) > UL then UL = Length(USERS.i)
          end
     else do
             Call LOGIT 'Get Users', SRVNAME, RC
             Return
          end

    HEADER  = 'OPT;'Left('USERS',UL,' ',)';'
    ALLAPPL = ''
    EMTAPPL = ''

    HEADER = HEADER || ALLAPPL
    do i = 1 to APPLNAME.0
       CL = Length(APPLNAME.i)
       ALLAPPL = ALLAPPL || Left(APPLNAME.i,CL,' ') || ';'/* All   Appls Line*/
       EMTAPPL = EMTAPPL || Left(' ',CL,' ') || ';'     /* Empty Appl  Line*/
    end
    HEADER = HEADER || ALLAPPL
    Call LineOut OUTF, HEADER

    RC = NetEnumerate(280, 'USERS', '\\'SRVNAME)
    if RC = 0
     then Call RxStemSort 'USERS'
     else do
              Call LOGIT 'Get Users', SRVNAME, RC
              Return
          end

    do i = 1 to USERS.0
       if i // MAXLINES = 0
        then Call LineOut OUTF, HEADER
        else Nop

       if \MUTE
        then do
                Call SysCurState OFF
                Call SysCurPos 20,0
             end
        else Nop
       say '0909'x ESC'[K Total Users =' i'/'Users.0 USERS.i

       OUT     = ''
       TMPAPPL = EMTAPPL

       RC = NetGetInfo(32, 'ApplSelInfo', '\\'SRVNAME, USERS.i)
       if RC = 0
        then do
                Call RxStemSort 'ApplSelInfo'
                do j = 1 to ApplSelInfo.Count
                   LEN = 1
                   do k = 1 to APPLNAME.0
                      APPLLEN = Length(APPLNAME.k)
                      if ApplSelInfo.j.AppName = APPLNAME.k
                        then TMPAPPL = Overlay(Center('X',APPLLEN,' '),TMPAPPL, LEN)
                        else Nop
                      LEN = LEN + APPLLEN + 1
                   end
                end
             end
        else nop

       OUT = '   ;'Left(USERS.i,UL,' ')';'TMPAPPL
       Call LineOut OUTF, OUT

    end

    if \MUTE then say '0909'x ' Total Time  =' Trunc(Time('E'),2)

    Call Stream OUTF, 'C', 'CLOSE'

    Call SysSetObjectData OUTF, 'ICONFILE='Directory()'\Selector.Ico'

    Return

 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = ''
    OUTF = 'SELECTOR.CSV'
    LOGF = 'LSMT.LOG'
    PIPE = ''
    TRACE = 0
    MUTE = 0

    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:'  then SRVNAME = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/OUT:'  then OUTF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:'  then LOGF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:'  then PIPE    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,2) = '/M'     then MUTE    = 1
        when Left(ARGUMENT,2) = '/T'     then TRACE   = 1
        otherwise Nop
       end
    end

    if SRVNAME = '' then signal GETHELP

    if \MUTE
     then do
             Topic1 = 'GETWELCOME'
             Topic_String.Topic1.1 = SRVNAME
             Topic_String.Topic1.2 = OUTF
             Topic_String.Topic1.3 = LOGF
             Topic_String.Topic1.4 = PIPE' '
             Topic_List='WELCOMELOGO' Topic1 'GETSEL'
             Call GETANS
             Parse VALUE SysCurPos() With Old_R Old_C; 'Pause'
             Call SysCurPos Old_R, Old_C; say ESC'[K'
          end
     else do
             say 'ServerName =' SRVNAME
             say 'OutputFile =' OUTF
             say 'LogFile    =' LOGF
          end
    Return

 CHKPWS:/* ---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    if RC = 0
     then do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          end
     else do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          end
    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m'                                    /* Rexx Utilities*/
    Call RgUtils  '/m'                                    /* Rexx Utilities*/
    Call RgNPipes '/m'                                       /* Named Pipes*/
    Call RgLSRXUT '/m'                             /* Lan Server Rexx Utils*/

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC   = '1B'x
    REDIR = '>NUL 2>NUL'
    MAXLINES = 20              /* Number of Lines to separate with a header*/

    Resource_File = 'LSMT.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List);
    Parse VALUE SysCurPos() With Old_R Old_C;
    Do While Vars_List <> '';
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List;
       Call SysCurPos Row, Column;
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m';
       End;
    Call SysCurPos Old_R, Old_C;

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    if \MUTE
     then do
             Topic1                = 'GETHELP'
             Topic_String.Topic1.1 =  PRGN
             Topic_List            =  Topic1
             Call GETANS
          end
     else say 'Incorrect options.'

    Call QUIT

    Return

 CHKFILE:/* --------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE

    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop

    Return

 LOGIT:/* ----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT:/* ------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.END', PRGN, 1
    Call Stream  'LSMT.END', 'C', 'CLOSE'
    Call Stream   LOGF,      'C', 'CLOSE'
    Call Stream   OUTF1,     'C', 'CLOSE'
    Call Stream   OUTF2,     'C', 'CLOSE'
    Exit

 /*--------------------------------------------------------------------------*/
