/*---------------------------------------------------------------------------*\
|  Check Lan Server Connections               (C) Alain Rykaert - MAR96-DEC97 |
\*---------------------------------------------------------------------------*/
    Version = '2.02'
    Say '* LSCONN Version' Version

    Parse Upper Arg ServerName

    If ServerName = ''
      Then Do
             Say '*'
             Say '* LAN Server Connections Statistics'
             Say '*'
             Say '* Usage: LSCONN {*} {ServerName}'
             Say '*'
             Say '* Sample: LSCONN \\BEDDC2'
             Say '*'
             Exit
           End
      Else Nop

    Call Init                                   /* load DLL's & other stuff*/

    If ServerName = '*'
      Then Do
             RC = NetGetInfo(350, 'WkstaInfo','')
             If RC = 0
               Then ServerName = WkstaInfo.ComputerName
               Else Call ChkError RC
           End
      Else ServerName = ServerName

    ServerName = Strip(ServerName,'L','\')

    Say '* Server Name:' '\\'ServerName

    TotalConnections = 0
    RC = NetEnumerate(180, 'Sessions', '\\'ServerName)
    If RC = 0
      Then Do
             Do i = 1 to Sessions.0
               Say Copies('-',65)
               Say '*' i'/'Sessions.0 Sessions.i
               RC = NetEnumerate(40, 'ConnInfo', '\\'ServerName, '\\'Sessions.i)
               Say '* Connections =' ConnInfo.Num_Entries
               TotalConnections = TotalConnections + ConnInfo.Num_Entries
               Do j = 1 to ConnInfo.Num_Entries
                 Say ' ' Left(ConnInfo.j.id,6) Left(connInfo.j.username,8) Left(connInfo.j.netname,8) Left(connInfo.j.type,20) Left(connInfo.j.num_opens,3) Left(connInfo.j.num_users,3) connInfo.j.time
               End
             End
             Say Copies('-',65)
             Say '* TotalConnections =' TotalConnections
           End
      Else Call ChkError

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('COMSPEC',,'OS2ENVIRONMENT'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Value('PATH',,'OS2ENVIRONMENT')
    x = Pos('IBMLAN\NETPROG', PPath) -3
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '* Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('LoadLSRXUTFuncs')
               Then Do
                      Call RxFuncAdd LoadLsRxutFuncs, LSRXUT, LoadLsRxutFuncs
                      Call LoadLsRxutFuncs
                    End
               Else Nop
           End
      Else Do
             Say '* Could not find' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit X2D('0800')
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '* Error:' RCode
    Exit X2D('1600')

    Return

