/*---------------------------------------------------------------------------*\
|  Check DCDB's                               (C) Alain Rykaert - MAR96-FEB00 |
\*---------------------------------------------------------------------------*/
    Version = '3.10a'
    Say '* LSDCDB Version' Version

    Signal On Halt Name Quit

 /*=============================*/
    LogFileName = 'LSDCDB.LOG'                             /* LOG File name*/
    DefaultACP = 'RWCXDAP'               /* default ACP for userdirectories*/
 /*=============================*/

    Call Init                                                 /* init dll's*/

    Parse Upper Arg DCName Option              /* option can only be '/FIX'*/

    If DCName = ''
      Then Do
             Say '*'
             Say '* Check Domain Controller Access Control Profiles'
             Say '*'
             Say '* Usage: LSDCDB {DCName} {/FIX}'
             Say '*'
             Say '* Sample: LSDCDB \\BEDDC01'
             Say '*'
             Exit X2D('1600')
           End
      Else Nop

    If Option = '/FIX'              /* check if the fix option is specified*/
      Then Fix = 1
      Else Fix = 0

    DCName = Strip(DCName,'L','\')

    Say '* Server Name:' '\\'DCName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             Say '* Role:' ServerRole
             If WordPos('Primary', ServerRole) > 0 |,  /* check server role*/
                WordPos('Backup', ServerRole) > 0
               Then Nop
               Else Do
                      Say '! This is not a Domain Controller' '07'x
                      Exit X2D('1600')
                    End
           End
      Else Call ChkError RC

    Say '* Getting all users from: \\'DCName
    AllDefinedUsers = ''
 /* RC = NetEnumerate(280, 'UserID', '\\'DCName) */
    RC = WfrxUserEnum('\\'DCNAME,'USERID')
    If RC = 0
      Then Do i = 1 to UserID.0
             AllDefinedUsers = AllDefinedUsers || UserID.i || ';'
           End
      Else Call ChkError RC
    Say '* Total users:' UserID.0

    Say '* Getting SysFileTree from: \\'DCName'\ibmlan$\users'
    Call SysFileTree '\\'DCName'\ibmlan$\dcdb\users\', 'DCDBDirs', 'DO'
    If DCDBDirs.0 > 0
      Then Do
             Say '* Total directories:' DCDBDirs.0
             Call RxStemSort 'DCDBDirs'                   /* sort all trees*/
             Do i = 1 to DCDBDirs.0
               Counter = '('Right(i,Length(DCDBDirs.0))'/'Right(DCDBDirs.0,Length(DCDBDirs.0))')'
               UserDir = Translate(SubStr(DCDBDirs.i, LastPos('\', DCDBDirs.i) + 1))
               Say Counter DCDBDirs.i

               If Pos(UserDir || ';', AllDefinedUsers) = 0
                 Then Do                          /* check if dir may exist*/
                        Say '! Error: directory found with no user'
                        If Fix = 1
                          Then Do
                                 Text = 'RD DIR' DCDBDirs.i
                                 Say '09'x Text
                                 If SysDestroyObject(DCDBDirs.i) = 1
                                   Then Call Logit Text
                                   Else Do
                                          Say '! Error:' Text
                                          Call Logit '! Error:' Text
                                        End
                               End

                          Else Nop
                        Iterate
                      End
                 Else Do                        /* check if batch dir exist*/
                        BatchDir = DCDBDirs.i || '\BATCH'
                        Call SysFileTree BatchDir, 'DirExist', 'DO'
                        If DirExist.0 = 0
                          Then Do
                                 Say '! Error: no BatchDir found on' DCDBDirs.i
                                 If Fix = 1
                                   Then Do
                                          Text = 'MD DIR' BatchDir
                                          Say '09'x Text
                                          If SysMKDir(BatchDir) = 0
                                            Then Call Logit Text
                                            Else Do
                                                   Say '! Error:' Text
                                                   Call Logit '! Error:' Text
                                                 End
                                        End
                                   Else Nop
                               End
                          Else Nop
                      End

            /* get ACP */
               RC = NetGetInfo(10, 'Access', '\\'DCName, DCDBDirs.i)
               If RC = 0 & Access.Count = 1
                 Then Do
                        If Access.1.UgName = UserDir & Access.1.Access = DefaultACP
                          Then Nop
                          Else Do
                                 Say '! Error: bad ACP found on' DCDBDirs.i
                                 Say '09'x UserDir || ':' || Access.1.Access
                                 If Fix = 1
                                   Then Call SetACL DCDBDirs.i UserDir
                                   Else Nop
                               End
                      End
                 Else Do
                        If RC <> 0
                          Then Do
                                 Say '! Error: no ACP found on' DCDBDirs.i
                                 If Fix = 1
                                   Then Call SetACL DCDBDirs.i UserDir
                                   Else Nop
                               End
                          Else Do
                                 Say '! Error: multiple ACP found on' DCDBDirs.i
                                 Do j = 1 to Access.Count
                                   Say '09'x Access.j.UgName || ':' || Access.j.Access
                                 End
                                 If Fix = 1
                                   Then Call SetACL DCDBDirs.i UserDir
                                   Else Nop
                               End
                      End
             End
           End
      Else Say '! Error: no directories exist on the DCDB\USERS tree'

    If Fix
      Then Say '0A08'x '* Done, look at the Log File' LogFileName
      Else Nop

    Exit X2D('FE00')

 SETACL:/* ------------------------------------------------------------------*/

    Parse Arg PathToSet UserID

    DirToSet.0 = 2
    DirToSet.1 = PathToSet
    DirToSet.2 = PathToSet || '\BATCH'

    Do j = 1 to DirToSet.0
   /* Delete */
      LogText = 'Del ACL on' DirToSet.j
      Say '09'x LogText
      RC = NetDelete(10, '\\'DCName, DirToSet.j)
      Call Logit LogText RC

   /* Set */
      Call Logit 'Adding ACL on:' DirToSet.j UserID':'DefaultACP
      ACL.Count    = 1
      ACL.1.Ugname = UserID
      ACL.1.Access = DefaultACP

      LogText = 'Set ACL on' DirToSet.j ACL.1.UgName || ':' || ACL.1.Access
      Say '09'x LogText
      RC = NetAdd(10, 'ACL', '\\'ServerName, DirToSet.j)
      If RC = 0
        Then Call Logit LogText
        Else Do
               Say '!' LogText
               Call Logit '! Error:' LogText RC
             End
    End

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('ComSpec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    If Stream(LSRDrive'\ibmlan\netlib\wfrxutil.dll', 'C', 'Query Exists') <> ''
      Then Do
             Call RxFuncAdd 'WfrxLoadFuncs', 'WfrxUtil', 'WfrxLoadFuncs'
             Call WfrxLoadFuncs
           End
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\WFRXUTIL.DLL' '07'x
             Exit X2D('0800')
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check '07'x
             Exit X2D('0800')
           End
      Else Nop

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg Log_Text

    Log_Text = Date('E') Time() Log_Text

    Call LineOut LogFileName, Log_Text
    Call Stream LogFileName, 'C', 'Close'

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Say '...Interupted by User...'

    Exit X2D('1604')

