/*---------------------------------------------------------------------------*\
|   REXX-NET                   (C) ALAIN RYKAERT - IBM-Belgium - SEP95-JAN96  |
\*---------------------------------------------------------------------------*/

    Parse ARG Option

    Call INIT
    Call MAIN
    Call QUIT

 MAIN: /*------------------------------------------------------ MAIN: -------*/

    OPTION = Translate(OPTION)
    if OPTION = '' then signal GETHELP
    Parse value OPTION with COMMAND ' ' REST
    Select
     when COMMAND = 'ALIAS'   then call ALIAS
     when COMMAND = 'FILE'    then call FILE
     when COMMAND = 'GROUPS'  then call GROUPS
     when COMMAND = 'SESSION' then call SESSION
     when COMMAND = 'SHARE'   then call SHARE
     when COMMAND = 'START'   then call START
     when COMMAND = 'USER'    then call USER
     otherwise Call GETHELP
    end
    Return

 ALIAS: /*----------------------------------------------------- ALIAS: ------*/

    if REST = ''
     then do
             RC = NetEnumerate(20, 'AliasNames', SRVNAME)
             if RC = 0
              then do i = 1 to AliasNames.0
                      say '09'x ESC'[0;1;33m' AliasNames.i ESC'[0m'
                   end
              else Nop
          end
     else do
             ALIAS = Strip(REST)
             RC = NetGetInfo(20, 'AliasInfo', SRVNAME, ALIAS)
             if RC = 0
              then do
                      say ESC'[2J' ESC'[0;1;36m'
                      say ' Name           :' AliasInfo.Name
                      say ' Remark         :' AliasInfo.Remark
                      say ' Server         :' AliasInfo.Server
                      say ' NetName        :' AliasInfo.NetName
                      say ' Location       :' AliasInfo.Location
                      say ' Mode           :' AliasInfo.Mode
                      say ' Max Uses       :' AliasInfo.MaxUses
                      say ' Type           :' AliasInfo.Type
                      say ' Queue          :' AliasInfo.Queue
                      say ' Path           :' AliasInfo.Path
                      say ' Priority       :' AliasInfo.Priority
                      say ' Device pool    :' AliasInfo.Device_Pool
                      say '0A'x ESC'[0;1;33mAccess Control :'

                      select
                       when AliasInfo.type = 'Files'
                        then Alias_Res = AliasInfo.path
                       when AliasInfo.type = 'Printer'
                        then Alias_Res = '\print\'AliasInfo.queue
                       when AliasInfo.type = 'Serial'
                        then Alias_Res = '\comm\'AliasInfo.queue
                       otherwise nop
                      end

                      RC = NetGetInfo(10, 'Access', '\\'AliasInfo.Server, Alias_Res)
                      if RC = 0
                       then do j = 1 to Access.Count
                               say ' ' Access.j.UGNAME '09'x Access.j.ACCESS
                            end
                       else say ' -none-'
                      say ESC'[0m'
                   end
              else say ESC'[0;1;31m' ALIAS ':' RC ESC'[0m'
          end
     Return

 FILE: /*------------------------------------------------------ FILE: -------*/

    Call SysCls
    RC = NetEnumerate(60, 'FileInfo', SRVNAME)
    if RC = 0
     then do i = 1 to FileInfo.0
             say ESC'[0;1;36m'
             say ' ID                   :' FileInfo.i.ID
             say ' Permissions          :' FileInfo.i.Permissions
             Parse value SysCurPos() with ROW COL
             Call SysCurPos ROW -1, 30; say '1 = Read & Execute'
             Call SysCurPos ROW   , 30; say '2 = Write enabled'
             Call SysCurPos ROW +1, 30; say '4 = Create enabled'
             say ' Num Locks            :' FileInfo.i.Num_Locks
             say ' Path Name            :' FileInfo.i.PathName
             say ' User Name            :' FileInfo.i.UserName
             say ESC'[0m'
          end

    Return

 GROUPS: /*---------------------------------------------------- GROUPS: -----*/

    if REST = ''
     then do
             RC = NetEnumerate(70, 'GroupInfo', SRVNAME)
             if RC = 0
              then do i = 1 to GroupInfo.0
                      say '09'x ESC'[0;1;33m' GroupInfo.i ESC'[0m'
                   end
              else Nop
          end
     else do
             GROUPNAME = Strip(REST)
             Call SysCls
             RC = NetGetInfo(70, 'GroupInfo', SRVNAME, GROUPNAME)
             if RC = 0
              then do
                      Call RxStemSort(GroupInfo)
                      say ESC'[0;1;36m'
                      say ' Name     :' GroupInfo.Name
                      say ' Comment  :' GroupInfo.Comment
                      RC = NetGetInfo(340, 'GroupUsr', SRVNAME, GROUPNAME)
                      if RC = 0
                       then do
                               say '0A'x ESC'[0;1;33mMembers  :'
                               do i = 1 to GroupUsr.0
                                  say ' ' GroupUsr.i
                               end
                               say ESC'[0m'
                           end
                       else Nop
                      say ESC'[0m'
                   end
              else say ESC'[0;1;31m' GROUPS ':' RC ESC'[0m'
          end
    Return

 SESSION: /*--------------------------------------------------- SESSION: ----*/

    RC = NetEnumerate(180, 'NetSession', SRVNAME)
    if RC = 0
     then do
             Call RxStemSort(NetSession)
             do i = 1 to NetSession.0
                 say ESC'[0;1;36m'
                 say ' ComputerName         :' NetSession.i
                 say ' UserName             :' NetSession.i.UserName
                 say ' Connections          :' NetSession.i.Num_conns
                 say ' Open                 :' NetSession.i.Num_Opens
                 say ' Established Sessions :' NetSession.i.Num_Users
                 say ' Time                 :' NetSession.i.Time
                 say ' Idle Time            :' NetSession.i.Idle_Time
                 say ' User Flag            :' NetSession.i.User_Flags
                 say ' PWS Type             :' NetSession.i.Cltype_Name
                 say ESC'[0m'
             end
          end

    Return

 SHARE: /*----------------------------------------------------- SHARE: ------*/

    RC = NetEnumerate(190, 'ShareInfo', SRVNAME)
    if RC = 0
     then do
             Call RxStemSort(ShareInfo)
             do i = 1 to ShareInfo.0
                say '09'x ESC'[0;1;33m' ShareInfo.i ESC'[0m'
             end
          end
     else Nop

    Return

 START: /*----------------------------------------------------- START: ------*/

    RC = NetEnumerate(170, 'ServiceInfo', SRVNAME)
    if RC = 0
     then do
             Call RxStemSort(ServiceInfo)
             do i = 1 to ServiceInfo.0
                say '09'x ESC'[0;1;33m' ServiceInfo.i ESC'[0m'
             end
          end
     else Nop

    Return

 USER: /*------------------------------------------------------ USER: -------*/

    if REST = '' then call GETHELP
    USERID = Strip(REST)

    RC = NetGetInfo(280, 'UserInfo', SRVNAME, USERID)
    if RC = 0
     then do
             say ESC'[2J' ESC'[0;1;36m'
             say ' Name              :' UserInfo.Name
             say ' Password          : ****'
             say ' Passwordage       :' UserInfo.Password_Age
             say ' Privilege         :' UserInfo.Priv
             say ' Home Dir          :' UserInfo.Home_dir
             say ' Comment           :' UserInfo.Comment
             say ' Flags             :' UserInfo.Flags
             Parse value SysCurPos() with ROW COL
             Call SysCurPos ROW -1, 30; say 'S = Always set. Logon script enabled'
             Call SysCurPos ROW   , 30; say 'D = User account disabled'
             Call SysCurPos ROW +1, 30; say 'U = User account cannot be deleted'
             Call SysCurPos ROW +2, 30; say 'H = Home directory required'
             Call SysCurPos ROW +3, 30; say 'N = Password not required'
             Call SysCurPos ROW +4, 30; say 'C = User cannot change password'
             say ' Script Path       :' UserInfo.Script_Path
             say ' Auth Flags        :' UserInfo.Auth_Flags
             Parse value SysCurPos() with ROW COL
             Call SysCurPos ROW -1, 30; say 'P = Print operator'
             Call SysCurPos ROW   , 30; say 'C = Comm operator'
             Call SysCurPos ROW +1, 30; say 'S = Server operator'
             Call SysCurPos ROW +2, 30; say 'A = Accounts operator'
             say ' Full Name         :' UserInfo.Full_Name
             say ' User Comment      :' UserInfo.Usr_Comment
             say ' Parms             :' UserInfo.Parms
             say ' Workstations      :' UserInfo.Workstations
             say ' Last Logon        :' Strip(UserInfo.Last_logon,,'0A'x)
             say ' Last Logoff       :' Strip(UserInfo.Last_logoff,,'0A'x)
             say ' Account expires   :' UserInfo.Acct_Expires
             say ' Max Storage       :' UserInfo.Max_Storage
             say ' Units per week    :' UserInfo.Units_per_week
             say ' Restricted Hours  :' UserInfo.Restricted_Hours
             say ' Bad passwords     :' UserInfo.Bad_PW_Count
             say ' Succesful logons  :' UserInfo.Num_logons
             say ' Logon Server      :' UserInfo.Logon_Server
         /*  say ' Country code      :' UserInfo.Country_Code
             say ' Code Page         :' UserInfo.Code_Page
           */

             say '0A'x ESC'[0;1;33mLogon Assignments :'
             RC = NetGetInfo(52, 'LogonAsnInfo', SRVNAME, USERID)
             if RC = 0
              then do
                      Call RxStemSort 'LogonAsnInfo'
                      do j = 1 to LogonAsnInfo.count
                         say ' ' LogonAsnInfo.j.device '09'x LogonAsnInfo.j.alias
                      end
                   end
              else say ' -none-'

             say '0A'x ESC'[0;1;35mGroup membership  :'
             RC = NetGetInfo(330, 'UserGroups', SRVNAME, USERID)
             if RC = 0
              then do
                      Call RxStemSort 'UserGroups'
                      do j = 1 to UserGroups.0
                         say ' ' UserGroups.j
                      end
                   end
              else say ' -none-'
             say ESC'[0m'
          end
     else say ESC'[0;1;31m' USERID ':' RC ESC'[0m'

    Return

 INIT: /*------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m' /* Rexx Utilities        */
    Call RgUtils  '/m' /* Rexx Utilities        */
    Call RgLSRXUT '/m' /* Lan Server Rexx Utils */

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC = '1B'x

    RC = NetGetInfo(350, 'WKSTAINFO', '')
    if RC = 0
     then do
             parse value NetMisc(510, WKSTAINFO.Logon_Domain, WKSTAINFO.ComputerName) with RC SRVNAME
             if RC = 0
              then do
                      Call SysFileTree SRVNAME'\IBMLAN$\IBMLAN.INI', 'STEM', 'F'
                      if STEM.0
                       then Nop
                       else do
                               say ESC'[0;1;41m Sorry, you DO NOT have ADMIN Privilege on Domain' WKSTAINFO.Logon_Domain ESC'[0m'
                               Call QUIT
                            end
                   end
              else Nop
          end
     else Nop

    Resource_File = 'RXNET.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS: /*---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List);
    Parse VALUE SysCurPos() With Old_R Old_C;
    Do While Vars_List <> '';
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List;
       Call SysCurPos Row, Column;
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m';
       End;
    Call SysCurPos Old_R, Old_C;

    Return

 GETHELP: /*--------------------------------------------------- GETHELP: ----*/

    Topic1='RXNETHELP'
    Topic_String.Topic1.1=PRGN;
    Topic_List=Topic1;
    Call GETANS
    Call QUIT

    Return

 CHKFILE: /*--------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 QUIT: /*------------------------------------------------------ QUIT: -------*/

    Exit

 /*--------------------------------------------------------------------------*/
