/*---------------------------------------------------------------------------*\
|   Set all Users to a LAN Server 3.0 and higher from an ASCII File           |
|                                             (C) Alain Rykaert - SEP95-JAN99 |
\*---------------------------------------------------------------------------*/
    Version = '2.02'

    Parse Arg Option

    Call Init                    /* Initialisation of DLL's and other stuff*/
    Call ChkOpt                          /* Check Options & display Welcome*/
    Call ChkPWS                               /* Check the PWS & Admin name*/
    Call Main                                            /* Do the main job*/
    Call Quit                                                       /* Quit*/

 MAIN:/* --------------------------------------------------------------------*/

    Call Time('R')

   'if exist' ChkF 'del' ChkF

    EC = 0                                                   /* Error check*/
    HC = 0                    /* check in case the HomeDir routine wants it*/
    ExitCode = X2D('FE00')                          /* Good CID Return code*/

    Do While Lines(InpF)
      LLine = LineIN(InpF)
      OLine = LLine
      Parse Value LLine With Opt ';' LLine
      Select
        When Opt = '' | LLine = '',
                      | Left(Strip(Opt),1) = '*' Then Iterate
        When Translate(Opt) = 'OPT' Then Call Columns
        When Translate(Opt) = 'A'   Then Call AddUser
        When Translate(Opt) = 'D'   Then Call DelUser
        When Translate(Opt) = 'U'   Then Call UpdUser
        Otherwise Iterate
      End
      If EC
        Then Do
               Call LineOut ChkF, OLine
               EC = 0
               ExitCode = X2D('1604')                /* Bad CID return code*/
             End
        Else Nop
    End

    Say '0909'x 'Total Time  =' Trunc(Time('E'),2)

    If HC
      Then Do
             Topic_List = 'ChkHomeDir'
             Call GetAns
             Call Logit 'Set HomeDir(s)', 'Run RXACL With "HomeACL.CSV"'
           End
      Else Nop

    Return

 ADDUSER:/* -----------------------------------------------------------------*/

    i  = 0
    Do While LLine <> ''
      i = i + 1
      COLNAME = Strip(COLNAME.i)
      Parse value LLine With VALUE ';' LLine
      USERINFO.COLNAME = Strip(VALUE)
      If USERINFO.COLNAME = '-none-' | USERINFO.COLNAME = 'No Restriction'
        Then USERINFO.COLNAME = ''                               /* Filters*/
        Else Nop
    End

    USERINFO.PASSWORD = Translate(USERINFO.PASSWORD)

    If POS('N',Translate(USERINFO.FLAGS)) = 0,
     & USERINFO.PASSWORD = '****'
     Then Do
            Call LOGIT 'Add User', USERINFO.NAME, 'Password needed'
            EC = 1
            Return
          End
     Else Nop

    If TRACE
      Then Do j = 1 to COLT
             COLNAME = Strip(COLNAME.j)
             Say '09'x '>'USERINFO.COLNAME'<' C2X(USERINFO.COLNAME)
           End
      Else Nop

    RC = NetAdd(282, 'USERINFO', '\\'SRVNAME)
    If RC = 0
      Then RC = ''
      Else EC = 1
    Call LOGIT 'Add User', USERINFO.NAME, RC

    If USERINFO.HOME_DIR = ''
      Then Nop
      Else Call HOMEDIR

    Return

 DELUSER:/* --------------------------------------------------- DELUSER: ----*/

    i  = 0
    Do While LLine <> ''
      i = i + 1
      ColName = Strip(ColName.i)
      Parse Value LLine With Value ';' LLine
      UserInfo.Colname = Strip(Value)
    End

    Call NetGetInfo 280, 'UserInfo', '\\'SrvName, UserInfo.Name
    If UserInfo.Home_Dir = '-none-'
      Then Nop
      Else Do
             If Left(UserInfo.Home_Dir,2) = '\\'
               Then Resource = UserInfo.Home_Dir
               Else Do
                      Parse Var UserInfo.Home_Dir . '\' HSName '\' Resource
                      HSName = Strip(HSName,'L','\')
                      Resource = '\\'HSName'\'Resource
                    End
             Call DelDirectory Resource
           End

    RC = NetDelete(280, '\\'SrvName, UserInfo.Name)
    If RC = 0
      Then RC = ''
      Else EC = 1

    Call Logit 'Delete User', UserInfo.Name, RC

    Return

 UPDUSER:/* -----------------------------------------------------------------*/

    i  = 0
    Do While LLine <> ''
      i = i + 1
      ColName = Strip(ColName.i)
      Parse value LLine With Value ';' LLine
      UserInfo.ColName = Strip(Value)
    End

    If TRACE
      Then Do j = 1 to ColT
             ColName = Strip(ColName.j)
             Say '09'x '>'UserInfo.ColName'<' C2X(UserInfo.ColName)
           End
      Else Nop

   /* Get OLD User settings */
    RC = NetGetInfo(280, 'OldInfo', '\\'SrvName, UserInfo.Name)
    If RC = 0
      Then RC = ''
      Else Do
             Call Logit 'Get Users', UserInfo.Name, RC
             EC = 1
             Return
           End

    OldInfo.PassWord = '****'  /* The only field which can NOT be retrieved*/

    Do j = 1 to ColT
      ColName = Strip(ColName.j)
      If OldInfo.ColName <> UserInfo.ColName
        Then Select
               When ColName = 'PASSWORD'
                Then Do
                       If Pos('N',Translate(UserInfo.Flags)) = 0
                         Then Call SetInfo
                         Else Nop
                     End
               When ColName = 'PRIV'
                 Then Do
                        Select
                          When Left(UserInfo.ColName,1) = 'A'
                            Then UserInfo.ColName = 'ADMIN'
                          When Left(UserInfo.ColName,1) = 'G'
                            Then UserInfo.ColName = 'GUEST'
                          When Left(UserInfo.ColName,1) = 'U'
                            Then UserInfo.ColName = 'USER'
                          Otherwise Nop
                        End
                        Call SetInfo
                      End
               When ColName = 'HOME_DIR'
                 Then Do
                        Call SetInfo
                        Call HomeDir     /* Do something about the HomeDirs*/
                     End
               Otherwise Call SetInfo
             End
        Else Nop
    End

    Return

 SETINFO:/* -----------------------------------------------------------------*/

    If ColName = 'PASSWORD' | ColName = 'PRIV'
      Then UserInfo.ColName = Translate(UserInfo.ColName)
      Else Nop

    RC = NetSetInfo(280, ColName, UserInfo.ColName, '\\'SrvName, UserInfo.Name)
     If RC = 0
      Then RC = ''
      Else EC = 1

    If ColName = 'PASSWORD'
     Then Call Logit 'Update User', UserInfo.Name '-' 'PASSWORD', RC
     Else Call Logit 'Update User', UserInfo.Name '-' UserInfo.ColName, RC

    Return

 HOMEDIR:/* -----------------------------------------------------------------*/

    If UserInfo.Home_Dir = ''
      Then Return
      Else Nop

    If Left(UserInfo.Home_Dir,2) = '\\'
      Then Parse Upper Value UserInfo.Home_Dir With '\\' HServerName '\' Resource
      Else Parse Upper Value UserInfo.Home_Dir With . ':\' HServerName '\' Resource

    HResource = '\\'HServerName'\'Resource

 /* Say '* HServerName:' HServerName
    Say '* HResource:' HResource */

 /* Check If the destination server is avalaible */

    If NetGetInfo(370, 'ServerModalInfo', '\\'HServerName) <> 0
      Then Do
             Call Logit 'CHK4SRV', 'Server' HServerName 'not found', RC
             Return
           End
      Else Call ChkDir HResource                   /* make dir If not exist*/

 /* Check If the user is (already) defined on the destination server */

    If NetGetInfo(280, 'UserInfo', '\\'HServerName, UserInfo.Name) = 0
      Then Do
             Say '* User' UserInfo.Name' exist on' HServerName

             Call NetDelete 10, '\\'HServerName, HResource/* delete to be shure*/

             ACL.Count    = 1                         /* make a default ACP*/
             ACL.1.UGName = UserInfo.Name
             ACL.1.Access = 'RWCXDAP'

             If NetAdd(10, 'ACL', '\\'HServerName, HResource) = 0
               Then RC = ''
               Else Nop

             Call Logit 'Update ACL', HResource ACL.1.Access, RC
             RC = ''
          End
     Else Do
             Say '* User' UserInfo.Name' Does NOT exist on' HServerName
             HC = 1                         /* Home Directory warning check*/

          /* Check If there is (already) an ACP on the resource */

             RC = NetGetInfo(10, 'Access', '\\'HServerName, HResource)
             If RC = 0              /* If ACP already exist, delete all ACP*/
               Then Call LineOut HomeACL, ' D ;'HResource';'UserInfo.Name
               Else Nop

             Call LineOut HomeACL, ' A ;'HResource';'UserInfo.Name';RWCXDAP'

             Call Stream  HomeACL, 'C', 'Close'

             Call SysSetObjectData HomeACL, 'IconFile='Directory()'\HomeACL.ICO'
          End

    RC = ''

    Return

 CHKDIR:/* -----------------------------------------------------------------*/

    Parse Arg Dir_Name

    RCode = 0                                      /* Reset the Return Code*/

    Dir_Name = Translate(Dir_Name)

    If Stream(Dir_Name, 'C', 'Query Exists') <> ''      /* is this a file ?*/
      Then RCode = 1   /* Bad RC, there already exist a file With this name*/
      Else Do
             Call SysFileTree Dir_Name, 'DirExist', 'Do'/* Does this DIR exist ?*/
             If DirExist.0 = 0
               Then Do
                      RC = SysMKDir(Dir_Name)
                      If RC <> 0
                        Then RCode = 1
                        Else Nop
                    End
               Else Nop
           End

    If RCode = 1
      Then Do
             LOG_Text = 'Error While creating' Dir_Name
             Call Logit 'Create Directory', LOG_Text, RCode
           End
      Else Nop

    Return

 COLUMNS:/* --------------------------------------------------- COLUMNS: ----*/

    BANNER = 'OPT'
    i = 0
    Do While LLine <> ''
       i = i + 1
       Parse value LLine With COLNAME.i ';' LLine
       BANNER = BANNER';'COLNAME.i
    End
    If COLNAME.1 <> 'NAME',
     | COLNAME.2 <> 'PASSWORD'
     Then Do
             OUT = 'Error reading' INPF ': Column 2 MUST be NAME, Column 3 MUST be PASSWORD'
             Call LOGIT OUT
             Exit
          End
     Else Nop
    COLT = i                                    /* Total numbers of columns*/

    Call LineOut CHKF, BANNER

    Return

 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = ''
    INPF    = 'USERS.CSV'
    LOGF    = 'LSMT.LOG'
    CHKF    = 'USERS.CHK'
    PIPE    = ''
    TRACE   = 0
    MUTE    = 0

    OPTION = Translate(OPTION)
    Do While OPTION <> ''
       Parse value OPTION With ARGUMENT ' ' OPTION
       Select
        when Left(ARGUMENT,5) = '/SRV:' Then SRVNAME = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/INP:' Then INPF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:' Then LOGF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/CHK:' Then CHKF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:' Then PIPE    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/HOM:' Then HomeACL = Substr(Argument,6)
        when Left(ARGUMENT,2) = '/M'    Then MUTE    = 1
        when Left(ARGUMENT,2) = '/T'    Then TRACE   = 1
        otherwise Nop
       End
    End

    If SRVNAME = '' Then signal GETHELP

   'If exist' CHKF 'del' CHKF

    If \MUTE
     Then Do
             Topic1 = 'SETWELCOME'
             Topic_String.Topic1.1 = SRVNAME
             Topic_String.Topic1.2 = INPF
             Topic_String.Topic1.3 = LOGF
             Topic_String.Topic1.4 = CHKF
             Topic_String.Topic1.5 = PIPE' '
             Topic_List = 'WELCOMELOGO' Topic1 'SETUSERS'
             Call GETANS
             Parse Value SysCurPos() With Old_R Old_C; '@pause'
             Call SysCurPos Old_R, Old_C; say ESC'[K'
          End
     Else Do
             say 'ServerName =' SRVNAME
             say 'InputFile  =' INPF
             say 'LogFile    =' LOGF
             say 'CheckFile  =' CHKF
          End

    Return

 CHKPWS:/* ---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    If RC = 0
     Then Do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          End
     Else Do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          End
    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m'                                    /* REXX Utilities*/
    Call RgUtils  '/m'                                    /* REXX Utilities*/
    Call RgLSRXUT '/m'                             /* Lan Server REXX Utils*/

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC   = '1B'x
    REDIR = '>NUL 2>NUL'

    Resource_File = 'LSMT.RSC'
    Call CHKFILE Resource_File

    HomeACL = 'HomeACL.CSV'        /* temporary file created by the HOMEDIR*/
                                  /* routine in case ACL must be applied on*/
                            /* another physical machine Then the Primary DC*/
    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List = Ansi_Say(Resource_File Topic_List)
    Parse VALUE SysCurPos() With Old_R Old_C
    Do While Vars_List <> ''
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List
       Call SysCurPos Row, Column
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m'
       End
    Call SysCurPos Old_R, Old_C

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    If \MUTE
     Then Do
             Topic1='SETHELP'
             Topic_String.Topic1.1=PRGN;
             Topic_List=Topic1;
             Call GETANS
          End
     Else say 'Incorrect options.'

    Call QUIT

    Return

 CHKFILE:/* --------------------------------------------------- CHKFILE: ----*/

    Parse Arg File
    RC = Stream(File, 'C', 'Query Exists')
    If RC = ''
      Then Do
             Say ' File' File 'not found.'
             Call Quit
           End
      Else Nop
    Call Stream FILE, 'C', 'Close'

    Return

 LOGIT:/* ----------------------------------------------------- LOGIT: ------*/

    Func = Arg(1); Info = Arg(2); RCod = Arg(3)

    RC = LLogit(LogF, Pipe, AdmName, PrgN, Func, Info, RCod)

    Return

 DELDIRECTORY:/* ------------------------------------------------------------*/
 return                                                 /* not finished yet*/
    Parse Arg Dir2Delete

    Say '---> Directory 2 delete:' Dir2Delete
    Say '(reminder: del function disabled)'

    Call SysFileTree Dir2Delete'\', 'DirCheck', 'DOS'
    Call SysFileTree Dir2Delete'\', 'FileCheck', 'FOS'
    Say ' Directories found:' DirCheck.0
    Say ' Files found:' FileCheck.0
    Total = 0
    Do f = 1 to FileCheck.0
      Total = Total + Stream(FileCheck.f, 'C', 'Query Size')
    End
    Say ' Total found:' Total

    Return

 QUIT:/* ------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.End', PRGN, 1
    Call Stream  'LSMT.End', 'C', 'Close'
    Call Stream   InpF,      'C', 'Close'
    Call Stream   LogF,      'C', 'Close'
    Call Stream   ChkF,      'C', 'Close'
    Exit ExitCode

