/*
 * PATCH.CMD -
 *
 * Copyright (c) 1995 Artisoft, Inc.  All rights reserved.
 * 
 * Copies all entries from LANTASTI.INI to OS2.INI.
 *
 */

'@ECHO OFF'
Trace 'Off'
Address CMD
/*
'CLS'

Say ' '
Say 'LANtastic for OS/2 INI file patch utility, V1.00'
Say 'Copyright (c) 1995, Artisoft.'
Say ' '
*/

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

/* 
 * Get the boot drive, the OS/2 directory path, and the LANtastic
 * installation directory 
 */
bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)
sysdir  = bootdrive||'\os2'

/*
 * Start out by defaulting a few settings that don't get defaulted by 
 * INSTALL, just in case they haven't been created by the programs.
 */
SysIni('USER', "PMNET", "ICONS", "2, 2, 2")     /* large icons */
SysIni('USER', "PMNET", "HINTS", "4")           /* hints in 1 second */

s_zero = D2C(0) || D2C(0)      /* FALSE (0) */
l_zero = s_zero || s_zero
q_zero = l_zero || l_zero

s_one  = D2C(1) || D2C(0)      /* TRUE (1)  */
l_one  = s_one  || s_zero
q_one  = s_one  || s_zero || l_zero

/*Trace 'I'*/
SysIni('USER', 'PMNET', 'RESTCNCT', l_one )     /* restore connections */
SysIni('USER', 'PMNET', 'SAVECNCT', l_one )     /* save connections */   

SysIni('USER', 'PMNET', 'NB_POS', q_zero )      /* position, upper-left */
SysIni('USER', 'PMNET', 'SRVTIME', s_zero )     /* don't set to server time */
SysIni('USER', 'PMNET', 'CONNECTCNT', l_zero )  /* no connections */

sstate = l_one || D2C(2) || D2C(0) || s_zero    /* start server, med. priority */
SysIni('USER', 'PMLTSRV', 'SERVER', sstate)
SysIni('USER', 'PMLTSRV', 'POSITION', q_zero)   /* position, upper-left */

scfg = D2C(2) || D2C(0) || D2C(10) || D2C(0)    /* tasks=2, logins=10 */
SysIni('USER', 'LANtastic', 'Config', scfg)

/*
 * Loop on Apps and keys, copying each to the user INI file.
 */
/*Trace 'I'*/
apps.0 = 0              /* init a stem variable to hold app names */
result = SysIni(sysdir||'\LANTASTI.INI', 'All:', 'apps')
If result == 'ERROR:' Then Do
   Say 'LANtastic for OS/2 installation profile LANTASTI.INI not found '
   Say 'on this machine.  MAKESTRT can''t continue.'
   Say ' '
   Exit 1
End

Do i = 1 to apps.0
   keys.0 = 0              /* init a stem variable to hold key names */
   result = SysIni(sysdir||'\LANTASTI.INI', apps.i,'All:', 'keys')
   If result == 'ERROR:' Then Do
      Say 'Error reading installation profile LANTASTI.INI, PATCH can''t continue.'
      Say ' '
      Exit 1
   End

   /* copy the keys to OS2.INI ('USER') */    
   Do j = 1 to keys.0
      value  = SysIni(sysdir||'\LANTASTI.INI', apps.i, keys.j)
      If value == 'ERROR:' Then Do
         Say 'Error reading installation profile LANTASTI.INI, PATCH can''t continue.'
         Say ' '
         Exit 1
      End
      result = SysIni('USER', apps.i, keys.j, value);
      If result == 'ERROR:' Then Do
         Say 'Error updating user profile OS2.INI, PATCH can''t continue.'
         Say ' '
         Exit 1
      End
   End
End

Say ' '
Say 'User profile OS2.INI updated successfully,'
Say ' '
Exit
