/*

  REXX Script to create a desktop folder for Tunnel/2

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Installing..."

dir = directory() || '\'

say "Creating folder"
call SysCreateObject "WPFolder", "Tunnel/2", "<WP_DESKTOP>", "OBJECTID=<TUNNELFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=10.Helv;BACKGROUND=" || dir || "back.bmp,T;ICONFILE=" || dir || "FOLDER.ICO", "replace"
say "Creating program objects"



call SysCreateObject "WPProgram", "File_ID.DIZ", "<TUNNELFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "FILE_ID.DIZ", "replace"
call SysCreateObject "WPProgram", "FAQ", "<TUNNELFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "FAQ.TXT", "replace"
call SysCreateObject "WPProgram", "Readme", "<TUNNELFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "README.DOC", "replace"
call SysCreateObject "WPProgram", "Readme First", "<TUNNELFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "README.1ST", "replace"
call SysCreateObject "WPProgram", "BMT Registration" || d2c(10) || "Applet", "<TUNNELFOLDER>", "EXENAME=" || dir || 'PURCHASE/' || "PURCHASE.EXE;STARTUPDIR=" || dir || "PURCHASE"";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "Get legal and" || d2c(10) || "Register", "<TUNNELFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "REGISTER.TXT", "replace"
call SysCreateObject "WPProgram", "Tunnel/2" || d2c(10) || "Homepage", "<TUNNELFOLDER>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "http://www.fx.dk/tunnel", "replace"
call SysCreateObject "WPProgram", "The Illustrated" || d2c(10) || "Tunnel/2 Guide", "<TUNNELFOLDER>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "file:///" || dir || "docs\welcome.htm", "replace"
call SysCreateObject "WPProgram", "Tunnel Master", "<TUNNELFOLDER>", "EXENAME=" || dir || 'MASTER/' || TM.EXE";STARTUPDIR=" || dir || "MASTER", "replace"
call SysCreateObject "WPProgram", "Tunnel Slave", "<TUNNELFOLDER>", "EXENAME=" || dir || 'SLAVE/' || TS.EXE";STARTUPDIR=" || dir || "SLAVE", "replace"
say "Installation completed - Tunnel/2"
