# include <stdio.h>
# include <sys/types.h>

# ifndef lint
static char *rcs_id =
	"@(#) $Header: mp_page.c,v 2.4 89/05/25 08:58:28 mark Exp $";
# endif

# include "mp_head.h"

/*
 * mpage:	a program to reduce pages of print so that several pages
 * 	  	of output appear on one printed page.
 *
 * Written by:
 *   ...!uunet!\                       Mark Hahn, Sr Systems Engineer
 *              >pyrdc!mark            Pyramid Technology Corporation
 * ...!pyramid!/                       Vienna, Va    (703)848-2050
 *
 *
 * Copyright (c) 1988 Mark P. Hahn, Herndon, Virginia
 *  
 *     Permission is granted to anyone to make or distribute verbatim
 *     copies of this document as received, in any medium, provided
 *     that this copyright notice notice is preserved, and that the
 *     distributor grants the recipient permission for further
 *     redistribution as permitted by this notice.
 *
 */

/* $Log:	mp_page.c,v $
 * Revision 2.4  89/05/25  08:58:28  mark
 * rearranged the rcs header keywords for better readability.
 * 
 * Revision 2.3  89/05/22  14:41:01  mark
 * Fixed the type-o in the rcs identification string
 * 
 * Revision 2.2  89/05/22  14:38:04  mark
 * Added rcs identification usable with the "what" program
 * 
 * Revision 2.1  89/05/22  14:31:27  mark
 * New Major Revision
 * 
 * Revision 1.1  89/05/22  14:25:52  mark
 * Initial revision
 *  */

set_page()
{
	if (opt_a4) {
		ps_width = 596;
		ps_height = 842;
	} else {
		ps_width = 612;
		ps_height = 792;
	}
}

xbase1()
{
	Debug(DB_POINTS, "%%xbase1: %d\n", pg_sheetmargin + pg_pagemargin);
	return pg_sheetmargin + pg_pagemargin;
}

xbase2()
{
	Debug(DB_POINTS, "%%xbase2: %d\n",  (ps_width / 2) + pg_pagemargin);
	return (ps_width / 2) + pg_pagemargin;
}

ybase1()
{
	Debug(DB_POINTS, "%%ybase1: %d\n", pg_sheetmargin + pg_pagemargin);
	return pg_sheetmargin + pg_pagemargin;
}

ybase2()
{
	Debug(DB_POINTS, "%%ybase2: %d\n",
	      (((ps_height / 2) - pg_sheetmargin) / 2)
	      + pg_sheetmargin + pg_pagemargin);
	return (((ps_height / 2) - pg_sheetmargin) / 2)
	  + pg_sheetmargin + pg_pagemargin;
}

ybase3()
{
	Debug(DB_POINTS, "%%ybase3: %d\n", (ps_height / 2) + pg_pagemargin);
	return (ps_height / 2) + pg_pagemargin;
}

ybase4()
{
	Debug(DB_POINTS, "%%ybase4: %d\n",
	      (((ps_height / 2) - pg_sheetmargin) / 2)
	      + (ps_height / 2) + pg_pagemargin);
	return (((ps_height / 2) - pg_sheetmargin) / 2)
	  + (ps_height / 2) + pg_pagemargin;
}

ytop1()
{
	Debug(DB_POINTS, "%%ytop1: %d\n", ybase1() + yht4());
	return ybase1() + yht4();
}

ytop2()
{
	Debug(DB_POINTS, "%%ytop2: %d\n", ybase2() + yht4());
	return ybase2() + yht4();
}

ytop3()
{
	Debug(DB_POINTS, "%%ytop3: %d\n", ybase3() + yht4());
	return ybase3() + yht4();
}

ytop4()
{
	Debug(DB_POINTS, "%%ytop4: %d\n", ybase4() + yht4());
	return ybase4() + yht4();
}

xwid1()
{
	Debug(DB_POINTS, "%%xwid1: %d\n",
	      ps_width - ((2 * pg_sheetmargin) + (2 * pg_pagemargin)));
	return ps_width - ((2 * pg_sheetmargin) + (2 * pg_pagemargin));
}

xwid2()
{
	Debug(DB_POINTS, "%%xwid2: %d\n",
	      (ps_width / 2) - (pg_sheetmargin + (2 * pg_pagemargin)));
	return (ps_width / 2) - (pg_sheetmargin + (2 * pg_pagemargin));
}

yht1()
{
	Debug(DB_POINTS, "%%yht1: %d\n",
	      ps_height - ((2 * pg_sheetmargin) + (2 * pg_pagemargin)));
	return ps_height - ((2 * pg_sheetmargin) + (2 * pg_pagemargin));
}

yht2()
{
	Debug(DB_POINTS, "%%yht2: %d\n",
	      (ps_height / 2) - (pg_sheetmargin + (2 * pg_pagemargin)));
	return (ps_height / 2) - (pg_sheetmargin + (2 * pg_pagemargin));
}

yht4()
{
	Debug(DB_POINTS, "%%yht4: %d\n",
	      (((ps_height / 2) - pg_sheetmargin) / 2) - (2 * pg_pagemargin));
	return (((ps_height / 2) - pg_sheetmargin) / 2) - (2 * pg_pagemargin);
}

outline_1(outfd)
 FILE *outfd;
{
	/* one page outline */
	fprintf(outfd, "0 setlinewidth\n");
        fprintf(outfd, "%3d %3d moveto\n", pg_sheetmargin, pg_sheetmargin);
	fprintf(outfd, "%3d %3d lineto\n", pg_sheetmargin,
		ps_height - pg_sheetmargin);
	fprintf(outfd, "%3d %3d lineto\n", ps_width - pg_sheetmargin,
		ps_height - pg_sheetmargin);
	fprintf(outfd, "%3d %3d lineto\n", ps_width - pg_sheetmargin,
		pg_sheetmargin);
	fprintf(outfd, "closepath stroke\n");
}

outline_2(outfd)
 FILE *outfd;
{
	/* two page outline */
	outline_1(outfd);
	fprintf(outfd, "%3d %3d moveto\n", pg_sheetmargin, ps_height / 2);
	fprintf(outfd, "%3d %3d lineto\n",  ps_width - pg_sheetmargin,
		ps_height / 2);
	fprintf(outfd, "stroke\n");
}

outline_4(outfd)
 FILE *outfd;
{
	/* four page outline */
	outline_2(outfd);
	fprintf(outfd, "%3d %3d moveto\n", ps_width / 2 , pg_sheetmargin);
	fprintf(outfd, "%3d %3d lineto\n", ps_width / 2 ,
		ps_height - pg_sheetmargin);
	fprintf(outfd, "stroke\n");
}

outline_8(outfd)
 FILE *outfd;
{
	/* eight page outline */
	outline_4(outfd);
	fprintf(outfd, "%3d %3d moveto\n", pg_sheetmargin,
		((ps_height / 2) - pg_sheetmargin) / 2 + pg_sheetmargin);
	fprintf(outfd, "%3d %3d lineto\n", ps_width - pg_sheetmargin,
		((ps_height / 2) - pg_sheetmargin) / 2 + pg_sheetmargin);
	fprintf(outfd, "stroke\n");
	fprintf(outfd, "%3d %3d moveto\n", pg_sheetmargin,
		((ps_height / 2) - pg_sheetmargin) / 2 + (ps_height / 2));
	fprintf(outfd, "%3d %3d lineto\n", ps_width - pg_sheetmargin,
		((ps_height / 2) - pg_sheetmargin) / 2 + (ps_height / 2));
	fprintf(outfd, "stroke\n");
}

mp_outline(outfd, asheet)
 FILE *outfd;
 struct sheet *asheet;
{
	if (opt_outline) {
		(*asheet->sh_outline)(outfd);
	}
}

