/* nec95.c
 *
 * Capture the output to a parallel port to which no printer is
 * connected, and redirect it to another file/device.  On open,
 * prepend the escape code to switch an NEC Silentwriter Model 95
 * to HP LaserJet III mode, send the data, and on close switch
 * back to native PostScript mode.
 *
 * usage is:
 *
 *    NEC95 LPTx LPTy|filename|devicename
 *
 * Written by John W. Cocula 920408
 * from source originally written by Jim Gilliland
 */

#define   INCL_DOSFILEMGR
#define   INCL_DOSMONITORS
#define   INCL_DOSPROCESS
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <process.h>
#include <malloc.h>
#define   LAST        2
 
void main( int argc, char *argv[] );

#pragma pack(1)
 
static struct
   {
   int length;
   char data[158];
   } ibuffer;
 
static struct
   {
   int length;
   char data[158];
   } obuffer;
 
static struct
   {
   unsigned char mflag;
   unsigned char dflag;
   unsigned int sysfilenum;
   char wdata[128];
   } wbuffer;

#pragma pack()
 
void main( int argc, char *argv[] )
{
   HMONITOR    hmon;
   HFILE       hfOutput;
   USHORT      usRC;
   USHORT      cbData, usAction, cbWritten;
   PSZ         pszNULLs;

   static CHAR achIntroString[] =
      "\004serverdict begin 0 exitserver statusdict begin 5 setsoftwareiomode end\004~N16";
   static CHAR achEndString[] =
      "\033*rB\033E\033\177""0\004~N16\004";
 
   puts( "NEC 95 mode-switching device monitor" );

   pszNULLs = (PSZ)calloc(8192,1);

   if ((argc != 3) || !strcmpi( argv[1], argv[2] ))
   {
      puts(
"\nNEC95 - usage is:\r\n"
"\n\tNEC95 LPTx filename|devicename"
"\n\twhere:"
"\n\t\t LPTx     = port set up as LaserJet III (with no printer attached)"
"\n\t\t LPTy     = port to redirect PCL data stream to\r\n"
"\n\tNote: x and y must be different.\r\n" );
      exit( 1 );
   }

   /* Open the device monitor */

   if (0 != (usRC = DosMonOpen( argv[1], &hmon )))
   {
      fprintf( stderr, "DosMonOpen returned code: %u", usRC );
      exit( 1 );
   }
 
   ibuffer.length = obuffer.length = 160;
 
   if (0 != (usRC = DosMonReg( hmon,
                               (PBYTE) &ibuffer,
                               (PBYTE) &obuffer, LAST, 1 )))
      printf( "DosMonReg returned code: %u", usRC );
 
   while (usRC == 0)
   {
      cbData = 132;

      if (0 != (usRC = DosMonRead( (PBYTE) &ibuffer, 0,
                                   (PBYTE) &wbuffer, &cbData )))
         printf( "DosMonRead returned code: %u", usRC );

      /* printf( " mflag=%02x,dflag=%02x -- ", wbuffer.mflag, wbuffer.dflag ); */

      if (wbuffer.mflag & 1)
      {
         /* printf( " Received open packet\n" ); */

         if (0 != (usRC = DosOpen( argv[2], &hfOutput, &usAction,
                                   0L, 0, 0x01, 0x0012, 0L )))
         {
            printf( "Error opening output file/device %s, return code: %u.",
                     argv[2], usRC );
         }
         else
         {
            if (0 != (usRC = DosWrite( hfOutput, achIntroString,
                                       sizeof achIntroString - 1,
                                       &cbWritten )))
               printf( " DosWrite returned code: %u", usRC );

            if (0 != (usRC = DosWrite( hfOutput, pszNULLs, 8192,
                                       &cbWritten )))
               printf( " DosWrite returned code: %u", usRC );
         }

         continue;
      }

      if (wbuffer.mflag & 2)
      {
         /* printf( " Received close packet\n" ); */
         if (0 != (usRC = DosWrite( hfOutput, achEndString,
                                    sizeof achEndString - 1,
                                    &cbWritten )))
            printf( " DosWrite returned code: %u", usRC );

         DosClose( hfOutput );

         continue;
      }

      if (wbuffer.mflag & 4)
      {
         /* printf( " Received flush packet\n" ); */
         if (0 != (usRC = DosMonWrite( (PBYTE) &obuffer,
                                       (PBYTE) &wbuffer, cbData )))
            printf( " DosMonWrite returned code: %u", usRC );

          continue;
      }

      if (wbuffer.dflag == 0)
      {
         /* printf( " Writing %u bytes\n", cbData - 4 ); */
         if (0 != (usRC = DosWrite( hfOutput, wbuffer.wdata, cbData-4,
                                    &cbWritten )))
            printf( " DosWrite returned code: %u", usRC );
      }

   }  /* end while */
 
   /* printf( "Exiting DosMonRead loop\n" ); */

   DosMonClose( hmon );
 
   DosExit( 0, 0 );
}

