/* ePDF installation script v.05*/

"cls"
say;say " ePDF installation.";say

/* - - - - - init RexxUtil - - - - - */

if rxfuncquery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
end


/* - - - - - Get install directory - - - - - */
InstDir = directory()


/* - - - - - add a pipe port  */

if SysIni("SYSTEM", "PM_SPOOLER_PORT", "\PIPE\ePDF") >< ";"||"00"x then do
say " Do you want to create a ePDF printer port?"
say "It is necessary for redirection of your printer jobs to ePDF."
say "Otherwise you have to create postscript files, and then open tese files"
say "with ePDF manually."
say "Note: Make a backup of your system.ini before adding this port!"
say "Type Y+Enter to create the port. Type another key to skip."
pull port_flag
if translate(left(port_flag, 1)) = 'Y' then
do
 say
 say "Creating port \PIPE\ePDF ..."
 call SysIni "SYSTEM", "PM_SPOOLER_PORT", "\PIPE\ePDF",";" || "00"x
 say "...done."
 say
 say " Please point your printer to the new port \PIPE\ePDF, and be sure"
 say "that Printmon PS is running before you start a PDF print job"
 say "(feel free to drop a shadow of PrintMon PS at your startupfilder)."
 say
end
end
else do
say "Existing ePDF print port detected, port installation skipped."
say
end
/* - - - - - object creation - - - - - */

say " Creating WPS objects..."

Call SysCreateObject 'WPFolder', 'ePDF', '<WP_DESKTOP>', 'OBJECTID=<ePDFFOLDER>', 'Update'
Call SysCreateObject 'WPProgram', 'ePDF', '<ePDFFOLDER>', 'OBJECTID=<epdfexe>;EXENAME='||InstDir||'\ePDF.exe;STARTUPDIR='||InstDir||';PROGTYPE=PM;PARAMETERS='||"-PS:'%*'", 'Update'
Call SysCreateObject 'WPProgram', 'PrintMon PS', '<ePDFFOLDER>', 'OBJECTID=<PrintMonPS>;EXENAME='||InstDir||'\print2ps.cmd;STARTUPDIR='||InstDir||';PROGTYPE=WINDOWABLEVIO;MINIMIZED=YES', 'Update'
Call SysCreateObject 'WPProgram', 'ReadMe', '<ePDFFOLDER>', 'OBJECTID=<epdfreadme>;EXENAME=e.exe;STARTUPDIR='||InstDir||';PROGTYPE=PM;PARAMETERS=readme.txt', 'Update'
Call SysCreateObject 'WPProgram', 'Support', '<ePDFFOLDER>', 'OBJECTID=<epdfsupport>;EXENAME=e.exe;STARTUPDIR='||InstDir||';PROGTYPE=PM;PARAMETERS=support.txt', 'Update'
Call SysCreateObject 'WPUrl', 'SubSys homepage', '<ePDFFOLDER>', 'OBJECTID=<ePDFwww>;URL=http://www.subsys.de/ePDF', 'Update'

say "...done."



/* - - - - - create parameter strings - - - - - */

INIfile = InstDir||'\EPDF.INI'
say
say " Do you want to create some useful distiller profiles? If this is the first"
say "time installation of ePDF it is recommended. But if this is an update over"
say "an existing and configured ePDF installation, you should cancel the profile"
say "setup. Otherwise existing profiles will be overwritten."
say "Type Y+Enter to create the profiles. Type another key to skip."

pull profile_flag
if translate(left(profile_flag, 1)) = 'Y' then
do
 say
 say "Creating profiles..."

 say "writing profile for screen optimized PDFs"
 s_par1="-dPDFSETTINGS=/screen -dProcessColorModel=/DeviceRGB -dColorImageResolution=72 -dGrayImageResolution=72 -dMonoImageResolution=300 -r72 -dDownsampleColorImages=true -dDownsampleGrayImages=true -dDownsampleMonoImages=true "
 s_par2="-dColorImageDownsampleType=/Average -dGrayImageDownsampleType=/Average -dMonoImageDownsampleType=/Average -dCompatibilityLevel=1.2 -dAutoRotatePages=/PageByPage -dPreserveOverprintSettings=false -dEmbedAllFonts=false "
 s_par3="-dNOPLATFONTS -dUCRandBGInfo=/Remove"
 s_par=s_par1||s_par2||s_par3
 call SysIni INIfile, 'parameter', 'Screen', s_par

 say "writing profile for ebook optimized PDFs"
 e_par1="-dPDFSETTINGS=/ebook -dProcessColorModel=/DeviceRGB -dColorImageResolution=150 -dGrayImageResolution=150 -dMonoImageResolution=300 -r150 -dDownsampleColorImages=true -dDownsampleGrayImages=true -dDownsampleMonoImages=true "
 e_par2="-dColorImageDownsampleType=/Bicubic -dGrayImageDownsampleType=/Bicubic -dMonoImageDownsampleType=/Bicubic -dCompatibilityLevel=1.2 -dAutoRotatePages=/All -dPreserveOverprintSettings=false -dEmbedAllFonts=true "
 e_par3="-dNOPLATFONTS -dUCRandBGInfo=/Remove"
 e_par=e_par1||e_par2||e_par3
 call SysIni INIfile, 'parameter', 'eBook', e_par

 say "writing profile for printer optimized PDFs"
 pr_par1="-dPDFSETTINGS=/printer -dProcessColorModel=/DeviceRGB -dColorImageResolution=300 -dGrayImageResolution=300 -dMonoImageResolution=1200 -r300 -dDownsampleColorImages=false -dDownsampleGrayImages=false -dDownsampleMonoImages=false "
 pr_par2="-dColorImageDownsampleType=/Bicubic -dGrayImageDownsampleType=/Bicubic -dMonoImageDownsampleType=/Bicubic -dCompatibilityLevel=1.2 -dAutoRotatePages=/None -dPreserveOverprintSettings=true -dEmbedAllFonts=true "
 pr_par3="-dNOPLATFONTS -dUCRandBGInfo=/Preserve"
 pr_par=pr_par1||pr_par2||pr_par3
 call SysIni INIfile, 'parameter', 'Printer', pr_par

 say "writing profile for prepress optimized PDFs"
 ps_par1="-dPDFSETTINGS=/prepress -dProcessColorModel=/DeviceRGB -dColorImageResolution=300 -dGrayImageResolution=300 -dMonoImageResolution=1200 -r300 -dDownsampleColorImages=false -dDownsampleGrayImages=false -dDownsampleMonoImages=false "
 ps_par2="-dColorImageDownsampleType=/Bicubic -dGrayImageDownsampleType=/Bicubic -dMonoImageDownsampleType=/Bicubic -dCompatibilityLevel=1.2 -dAutoRotatePages=/None -dPreserveOverprintSettings=true -dEmbedAllFonts=true "
 ps_par3="-dNOPLATFONTS -dUCRandBGInfo=/Preserve"
 ps_par=ps_par1||ps_par2||ps_par3
 call SysIni INIfile, 'parameter', 'Prepress', ps_par

 say "writing profile for GhostScript default PDF conversion"
 d_par1="-dPDFSETTINGS=/default -dProcessColorModel=/DeviceRGB -dColorImageResolution=72 -dGrayImageResolution=72 -dMonoImageResolution=300 -r72 -dDownsampleColorImages=false -dDownsampleGrayImages=false -dDownsampleMonoImages=false "
 d_par2="-dColorImageDownsampleType=/Subsample -dGrayImageDownsampleType=/Subsample -dMonoImageDownsampleType=/Subsample -dCompatibilityLevel=1.2 -dAutoRotatePages=/PageByPage -dPreserveOverprintSettings=false -dEmbedAllFonts=true "
 d_par3="-dNOPLATFONTS -dUCRandBGInfo=/Remove"
 d_par=d_par1||d_par2||d_par3
 call SysIni INIfile, 'parameter', 'Default', d_par

 say "setting the printer profile as ePDF default"
 call SysIni INIfile, 'ghostscript', 'parameter_selected', 'Printer'
 say "...done. "
end


/* - - - - - asso setup - - - - - */
say
say " Do you want to associate PostScript files (files with the extension '.PS')"
say "with ePDF? Type Y+Enter to enable the association. Type another key to"
say "skip the association setup."

pull asso_flag
if translate(left(asso_flag, 1)) = 'Y' then
do
 say
 say "Creating associations..."
 say
 address cmd '@DEFASSOC F *.PS "<epdfexe>" 2>NUL 1>&2'
 say
 say "...done. ePDF is now the default association for PostScript files."
 say "Please go through the ePDF properties to customize ePDF."
 say "At least you have to configure a distiller (GhostScript)."
end

say " Installation done. Hit ENTER to continue."
pull dummy
call SysOpenObject "<ePDFFOLDER>", 0, "TRUE"


exit