/*
 * nup.h - global definitions for 'nup' program
 */

#ifndef _NUP_H
#define _NUP_H

#define INCL_PM
#define INCL_SPL
#define INCL_SPLERRORS
#define INCL_SPLDOSPRINT
#define INCL_ERRORS

#include <os2.h>

/*
 * Name of Program, Profile
 */

extern  UCHAR   ProgramPath[] ;
extern  UCHAR   ProgramName[] ;
extern  UCHAR   ProfilePath[] ;

/*
 * error handling with Message Box
 */

void    nupMessage(PSZ msg) ;

/*
 * utility for dialog windows
 */

void    dialogAtCenter(HWND hwndDialog) ;
void    dialogAtMouse(HWND hwndDialog)  ;
void    dialogAtWindowBottom(HWND hwndDialog, HWND hwndWindow) ;

/*
 * Window Variables
 */

extern  HAB     habMain     ;

/*
 * Printer Informations
 */

PPRQINFO3   printerDefault(void)   ;
PPRQINFO3   printerRefer(PSZ name) ;

void        printerFillup(HWND hwndLbox) ;
void        printerSelect(HWND hwndLbox, PSZ name) ;
int         printerProp(HAB hab, PPRQINFO3 prt) ;

/*
 * Font Informations
 */

void            fontFill(HWND hwndLbox) ;
void            fontSelect(HWND hwndLbox, PSZ name) ;
PFONTMETRICS    fontRefer(PSZ name) ;

/*
 * Layout Informations
 */

typedef struct _LAYOUT {
    int         index     ;     /* layout number            */
    UCHAR       fname[64] ;     /* font name (FIXED, MBCS)  */
    BOOL        ppf       ;     /* prefer printer font      */
    LONG        ratio     ;     /* char height/line height  */
    LONG        lines     ;     /* number of lines          */
    LONG        columns   ;     /* number of columns        */
    LONG        lmargin   ;     /* left   margin            */
    LONG        rmargin   ;     /* right  margin            */
    LONG        tmargin   ;     /* top    margin            */
    LONG        bmargin   ;     /* bottom margin            */
    LONG        hspace    ;     /* horz. spacing            */
    LONG        vspace    ;     /* virt. spacing            */
    LONG        pgorder   ;     /* page order for 4-up      */
    BOOL        frame     ;     /* draw page frame          */
    BOOL        marker    ;     /* draw center marker       */
    LONG        reserved  ;     /* reserved                 */
} LAYREC, *LAYPTR ;

#define LAYOUT_LIN_MAX  1024
#define LAYOUT_LIN_MIN    16
#define LAYOUT_COL_MAX  1024
#define LAYOUT_COL_MIN    16

#define LAYOUT_MARGIN_MAX   100
#define LAYOUT_MARGIN_MIN     5

#define LAYOUT_ORDER_ROW    0           /* Page Order, Row first    */
#define LAYOUT_ORDER_COL    1           /* Page Order, Column first */

#define LAYOUT_PORT1    0
#define LAYOUT_PORT2    1
#define LAYOUT_PORT4    2
#define LAYOUT_LAND1    3
#define LAYOUT_LAND2    4
#define LAYOUT_LAND4    5

int     layoutInit(HAB han) ;           /* Start  Layout Management */
void    layoutDone(HAB hab) ;           /* Finish Layout Management */

LAYPTR      layoutInfo(int layout) ;    /* Refer to Layout Data     */

int     layoutCur(void) ;               /* Number of current layout */
int     layoutPrev(int layout) ;        /* Returns Previous layout  */
int     layoutNext(int layout) ;        /* Returns Next     layout  */

/*
 * Document Informations
 */

typedef struct _DOCUMENT    *DOCPTR ;

typedef struct _DOCUMENT {
    DOCPTR      prev  ;
    DOCPTR      next  ;
    PSZ         title ;
    PSZ         fname ;
    BOOL        ulink ;
    ULONG       first ;
    ULONG       last  ;
} DOCREC ;

void    docListInit(DOCPTR list) ;
void    docListTerm(DOCPTR list) ;

DOCPTR  docFromFile(PSZ fname) ;
DOCPTR  docFromStdin(void)     ;
void    docDispose(DOCPTR doc) ;

void    docAppend(DOCPTR list, DOCPTR doc) ;
void    docDelete(DOCPTR list, DOCPTR doc) ;

DOCPTR  docFirst(DOCPTR list) ;
DOCPTR  docNext(DOCPTR list, DOCPTR doc) ;

#define docEmpty(list)  (docFirst(list) == NULL)
#define docExist(list)  (docFirst(list) != NULL)

/*
 * Current Selected Objects
 */

extern  PPRQINFO3   thePrt ;
extern  LAYPTR      theLay ;
extern  DOCREC      theDoc ;

/*
 * Messages from Printing Thread
 */

#define WM_USER_PRINT_FILE  (WM_USER + 1)   /* File Start - DOCPTR in mp1 */
#define WM_USER_PRINT_PAGE  (WM_USER + 2)   /* Page Start - page # in mp1 */
#define WM_USER_PRINT_DONE  (WM_USER + 3)   /* Print Done - mesg   in mp1 */
#define WM_USER_PRINT_SUSP  (WM_USER + 4)   /* Suspending - no param      */

/*
 * interactive setup dialog
 */

void    setupPrint(BOOL immediate) ;

/*
 * edit layout
 */

void    editLayout(HWND hwnd, int layout) ;

/*
 * print document
 */

void    printDocument(HWND hwnd) ;

#endif  /* _NUP_H */
