/***********************************************************/
/*                                                         */
/*  SysPHmsg client  -- issue cmommand or message to       */
/*  SysPage daemon from cgi prog.                          */
/*                                                         */
/***********************************************************/
/*
 * Include Files.
 */
#ifdef __OS2__
#include <types.h>
#define perror(x) psock_errno(x)
#define close(x)  soclose(x)
#else
#include <sys/types.h>
#endif
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>


void puthtdesc( char * str )
{
 fprintf( stdout, "Content-TYPE:  text/html\n\n" );
 fprintf( stdout, "<HEAD>\n" );
 fprintf( stdout, "<TITLE>SysPage HTML</TITLE>\n" );
 fprintf( stdout, "</HEAD>\n" );
 fprintf( stdout, "<BODY>\n" );
 fprintf( stdout, "%s\n", str );
 fprintf( stdout, "</BODY>\n" );
}


/*
 * Client Main.
 */
main(int argc, char **argv)
{
    unsigned short port;       /* port client will connect to              */
    struct hostent *hostnm;    /* server host name information             */
    struct sockaddr_in server; /* server address                           */
    int s;                     /* client socket                            */
    unsigned long requestor;   /* IP addr of requestor                     */
    char * loc, * chp;         /* parsing                                  */
    char emsg[80];             /* error description                        */
    char buf[256],
         sbuf[256],
         obuf[256];            /* data buffers                             */


    /*
     */
    if (argc != 1)
       {
        fprintf(stdout,
         "Status: 400 hostname port command/message.\n");
         sprintf( emsg, "Arg is: %s\n", argv[1] );
         puthtdesc( "unexpected args" );
        exit(1);
       }

    /* get the requestor IP */
    requestor = inet_addr( getenv( "REMOTE_ADDR" ) );
    memcpy( obuf, &requestor, 4 );

    /*
     * The host name is the first argument in extra_path. 
     * the command port is the 2nd
     */
    strcpy( buf, getenv( "PATH_INFO" ) );
    if ( buf[0] != '/' ) 
       { fprintf( stdout, "Status: 400 \n" );
         puthtdesc( "No Path_Info" );
         exit(1);
       }
    loc = &buf[0]; loc++;   /* skip slash */
    chp = loc;
    while ( ( *loc ) && ( *loc != '/' ) )
      { loc++;
      }
    if ( *loc != '/' )
       {
       fprintf(stdout, "Status: 400 No UDP port number\n");
       puthtdesc("No UDP port number.");
       exit(2);
       }
    *loc = '\0';
    hostnm = gethostbyname( chp );
    if (hostnm == (struct hostent *) 0)
       {
       fprintf(stdout, "Status: 405 gethostbyname()\n");
       puthtdesc("gethostbyname failed.");
       exit(2);
       }
    loc++; chp = loc;
    while ( ( *loc ) && ( *loc != '/' ) )
      { loc++;
      }
    *loc = '\0';
    /*
     * The port is the second argument.
    */
    port = (unsigned short) atoi( chp );
    
    strcpy( buf, getenv( "QUERY_STRING" ) );

    loc = strtok( buf, "=&" );
    if ( strcasecmp( loc, "LogDisp" ) == 0 )
       {
       loc = strtok( NULL, "&+" );
       if ( loc == NULL )
          { fprintf(stdout, "Status: 400 (1) %s\n");
            puthtdesc( "Bad LogDisp value" );
            exit(1);
          }
       strcpy( sbuf, "\001CMD\002" );
       strcat( sbuf, "LogDisp " );
       strcat( sbuf, loc );
       }
    else
    if ( strcasecmp( loc, "LogMesg" ) == 0 )
       {
       loc += strlen(loc) + 1; chp = loc;
       while ( *chp )  /* rest plus to blank */
          { if ( *chp == '+' ) *chp = ' ';
          chp++;
          }
       strcpy( sbuf, loc );
       }
    else
       { fprintf( stdout, "Status: 400 parm-syntax - %s\n", buf );
         puthtdesc("Unknown INPUT value" );
         exit(2);
       }


    /*
     * Put the server information into the server structure.
     * The port must be put into network byte order.
     */
    server.sin_family      = AF_INET;
    server.sin_port        = htons(port);
    server.sin_addr.s_addr = *((unsigned long *)hostnm->h_addr);

#ifdef __OS2__
    s = sock_init();
    if ( s < 0 )
       {
        fprintf(stdout, "Status: 405 sock_init() failed\n");
        puthtdesc( "sock_init error" );
        exit(2);
       }
#endif

    /*
     * Get a DGRAM  socket.
     */
    if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
       {
        fprintf( stdout, "Status: 405 Socket() %s\n", strerror(errno) );
        puthtdesc( "socket error" );
        exit(3);
       }

    strcpy( &obuf[4], sbuf );
    if ( sendto(s, obuf, (strlen(sbuf)+5), 0, (struct sockaddr *)&server,
                sizeof(server) ) < 0 )
       { fprintf( stdout, "Status 405 sendto() %s\n", strerror(errno) );
         puthtdesc( "sendto() error");
         exit(4);
       }

    close(s);

    fprintf( stdout, "Status: 204 Cmd/Message sent to SysPage\n\n" );
    exit(0);
}
