//
// TAP
// Sample Server Application
// Revision 1.10
//
//  4/20/95   First Created
//
#define INCL_DOSERRORS
#define INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <share.h>
#include <fcntl.h>
#include <string.h>
#include "tapserve.h"
#include "svrsamp.h"

//***
//* Global Data
//* (Hey, this is just a sample!)
//***
HAB hab;
HMODULE hmod = NULLHANDLE;
PTAPSERVERINFO pTapServerInfo;

PAPSZ papszFQFilename = NULL;
ULONG ulFQFCount = 0;
ULONG ulCurrentFile = 0;
ULONG ulFileSize = 0;
ULONG ulCurrentSize = 0;

int iTransferRunning = FALSE;
HFILE hfileTransfer;
BOOL  fFileOpen = FALSE;


//
// void SetStatusLine(HWND hWndDlg, char *msg);
//
// Displays a new message on the status line.
//
// Parameters
// hWndDlg
//   Window handle of the server dialog.
// msg
//   Message to put on the status line.
//
void SetStatusLine(HWND hWndDlg, char *msg)
{
   // Set status line text
   WinSetDlgItemText(hWndDlg,
                     TAP_STATUSLINE_ID,
                     msg);
}

//
// void StopOrStartTransferSimulation(HWND hWnd);
//
// Toggles the transfer simulation on or off.
//
// Parameters
// hWnd
//   Window handle of the server dialog.
//
void StopOrStartTransferSimulation(HWND hWnd)
{
   // Make sure we have a list of files to send
   if (ulFQFCount)
   {
      if (iTransferRunning)
      {
         // Stop the transfer
         WinStopTimer(hab,
                      hWnd,
                      TRANSFER_TIMER);

         // Close the opened file
			if (fFileOpen) {
	         DosClose (hfileTransfer);
				}
			fFileOpen = FALSE;
         ulCurrentFile = 0;
         ulFileSize = 0;
         ulCurrentSize = 0;

         // Let TAP know we are cancelling
         Cancel_TAP(pTapServerInfo);
         EndOfBatch_TAP(pTapServerInfo);

         // Change button text
         WinSetDlgItemText(hWnd,
                           TAP_SERVE_ID,
                           "Simulate Transfer");

         SetStatusLine(hWnd, "Transfer aborted");

         iTransferRunning = FALSE;
      }
      else
      {
      int iSliderPosition;

         // Query current slider position
         iSliderPosition = (int)
            WinSendDlgItemMsg(hWnd,
                              TAP_SPEED_ID,
                              SLM_QUERYSLIDERINFO,
                              (MPARAM) MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                                                    SMA_INCREMENTVALUE),
                              (MPARAM) 0);

         // Start the transfer
         WinStartTimer(hab,
                        hWnd,
                        TRANSFER_TIMER,
                        (ULONG)((50 - iSliderPosition) * 20));

         // Change button text
         WinSetDlgItemText(hWnd,
                           TAP_SERVE_ID,
                           "Stop Transfer");

         // Close current file
			if (fFileOpen) {
	         DosClose (hfileTransfer);
				}
         ulCurrentFile = 0;

         SetStatusLine(hWnd, "Transfer started");

         iTransferRunning = TRUE;
      }
   }
   else
     WinMessageBox(HWND_DESKTOP,
                   hWnd,
                   "You must select one or more files first",
                   "Error",
                   0,
                   MB_OK);
}

//
// void GetFilesToSend(HWND hWnd)
//
// Brings up the file dialog and allows
// the user to select one or more
// files for the transfer simulation.
//
// The array of files is kept as global
// data.
//
// Parameters
// hWnd
//   Window handle of the server dialog.
//
void GetFilesToSend(HWND hWnd)
{
FILEDLG FileDlg;

   // Clear file dialog structure
   memset(&FileDlg, 0, sizeof(FileDlg));

   // Fill in file dialog structure
   FileDlg.cbSize = sizeof(FileDlg);
   FileDlg.fl = FDS_CENTER | FDS_MULTIPLESEL | FDS_OPEN_DIALOG;
   strcpy(FileDlg.szFullFile, "*.*");

   // Call common file dialog
   WinFileDlg(HWND_DESKTOP,
               hWnd,
               &FileDlg);

   // On good return, save our file list
   if ((FileDlg.lReturn == DID_OK) && (FileDlg.ulFQFCount))
   {
      // Free any old file list,
      // keep memory leaks to a minimum <G>
      if (papszFQFilename)
         WinFreeFileDlgList(papszFQFilename);

      papszFQFilename = FileDlg.papszFQFilename;
      ulFQFCount =  FileDlg.ulFQFCount;
   }
}

//
// void TransferTimerTick(HWND hWnd);
//
// This function should be called every
// n milliseconds. During each call, either
// the a new file is opened, file size is
// incremented, a file is closed, or the
// transfer is ended.
//
// This is the main transfer simulation.
//
// Parameters
// hWnd
//   Window handle of the server dialog.
//
void TransferTimerTick(HWND hWnd)
{
   // See if we have a file currently open
   if (fFileOpen)
   {
   char out[CCHMAXPATH * 2];

      // Determine next position in the file
      ulCurrentSize = ((ulCurrentSize + 1024 < ulFileSize) ? ulCurrentSize + 1024 : ulFileSize);

      // Update status line
      sprintf(out, "Transferred %u of %u", ulCurrentSize, ulFileSize);
      SetStatusLine(hWnd, out);

      // Update TAP
      SetCurrentSize_TAP(pTapServerInfo, (LONG)ulCurrentSize);

      // Close file if we've reached the end
      if (ulCurrentSize == ulFileSize)
      {
         sprintf(out, "Closing file", (*papszFQFilename)[ulCurrentFile]);
         SetStatusLine(hWnd, out);

         // Let TAP know we're closing the file
         EndOfFile_TAP(pTapServerInfo);

	      DosClose (hfileTransfer);
			fFileOpen = FALSE;
      }
   }
     else
   {
      // Have we reached the end of the array
      // of files?
      if (ulCurrentFile < ulFQFCount)
      {
      char out[CCHMAXPATH * 2];

         // No file open, open it now and get ready
			{	ULONG ulTemp;
         	if (DosOpen ((*papszFQFilename)[ulCurrentFile], &hfileTransfer, &ulTemp, 0L, FILE_NORMAL, OPEN_ACTION_OPEN_IF_EXISTS|OPEN_ACTION_FAIL_IF_NEW, OPEN_FLAGS_NOINHERIT | OPEN_ACCESS_READONLY | OPEN_SHARE_DENYWRITE, 0L) == NO_ERROR) {
					fFileOpen = TRUE;
					}
				}

         // Determine file size
			{	FILESTATUS3 filestatus;
				DosQueryFileInfo (hfileTransfer, FIL_STANDARD, &filestatus, sizeof (filestatus));
         	ulFileSize = filestatus.cbFile;
				}

         ulCurrentSize = 0;

         // Let TAP know we started a new file
         SetFileName_TAP(pTapServerInfo, (*papszFQFilename)[ulCurrentFile]);
         SetCompleteSize_TAP(pTapServerInfo, (LONG)ulFileSize);
         SetCurrentSize_TAP(pTapServerInfo, 0);

         sprintf(out, "Readying for transfer of %s", (*papszFQFilename)[ulCurrentFile]);
         SetStatusLine(hWnd, out);

         ulCurrentFile ++;
      }
        else
      {
         // Stop the transfer
         WinStopTimer(hab,
                      hWnd,
                      TRANSFER_TIMER);

         // End of file transfer
         iTransferRunning = FALSE;
         SetStatusLine(hWnd, "Transfer complete");
         ulCurrentFile = 0;
			fFileOpen = FALSE;
         ulFileSize = 0;
         ulCurrentSize = 0;

         // Let TAP know that's the last file
         EndOfBatch_TAP(pTapServerInfo);

         // Change button text
         WinSetDlgItemText(hWnd,
                           TAP_SERVE_ID,
                           "Simulate Transfer");
      }
   }
}

//
// MRESULT EXPENTRY ServerDlgProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
//
// Server dialog proc
//
MRESULT EXPENTRY ServerDlgProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
MRESULT mResult = 0;

   switch (msg)
   {
      case WM_TIMER :
      {
         switch (SHORT1FROMMP(mp1))
         {
            case TRANSFER_TIMER :
               TransferTimerTick(hWnd);
               break;

            default :
               mResult = WinDefDlgProc(hWnd, msg, mp1, mp2);
               break;
         }

         break;
      }

      case WM_CONTROL :
      {
         switch (SHORT1FROMMP(mp1))
         {
            case TAP_SPEED_ID :
               if (SHORT2FROMMP(mp1) == SLN_CHANGE)
               {
               int iSliderPosition;

                   // Query current slider position
                   iSliderPosition = (int)
                      WinSendDlgItemMsg(hWnd,
                                        TAP_SPEED_ID,
                                        SLM_QUERYSLIDERINFO,
                                        (MPARAM) MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                                                              SMA_INCREMENTVALUE),
                                        (MPARAM) 0);

                   // Set new timer frequency
                   if (iTransferRunning)
                     WinStartTimer(hab,
                                   hWnd,
                                   TRANSFER_TIMER,
                                   (ULONG)((50 - iSliderPosition) * 20));
               }
               break;

            default :
               mResult = WinDefDlgProc(hWnd, msg, mp1, mp2);
               break;
         }
         break;
      }

      case WM_COMMAND :
      {
         switch (SHORT1FROMMP(mp1))
         {
            case TAP_SPEED_ID :
               if (SHORT2FROMMP(mp1) == SLN_CHANGE)
               {
               int iSliderPosition;

                   // Query current slider position
                   iSliderPosition = (int)
                      WinSendDlgItemMsg(hWnd,
                                        TAP_SPEED_ID,
                                        SLM_QUERYSLIDERINFO,
                                        (MPARAM) MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                                                              SMA_INCREMENTVALUE),
                                        (MPARAM) 0);

                   // Set new timer frequency
                   if (iTransferRunning)
                     WinStartTimer(hab,
                                   hWnd,
                                   TRANSFER_TIMER,
                                   (ULONG)((50 - iSliderPosition) * 20));
               }
               break;

            case TAP_FILES_ID :
               GetFilesToSend(hWnd);
               break;

            case TAP_APPLICATION_ID :
               SelectApplication_TAP(pTapServerInfo,
                                     HWND_DESKTOP,
                                     hWnd,
                                     hmod);
               break;

            case TAP_SERVE_ID :
               StopOrStartTransferSimulation(hWnd);
               break;

            default :
               mResult = WinDefDlgProc(hWnd, msg, mp1, mp2);
               break;
         }
         break;
      }

      default :
         mResult = WinDefDlgProc(hWnd, msg, mp1, mp2);
         break;
   }

   return mResult;
}

INT main(int argc, char **argv)
{
HMQ hmq;

	argc = argc;
	argv = argv;

	// Initialize TAP server
   pTapServerInfo = InitializeServer_TAP(TAP_SERVER_VERSION);

   // Initialize PM
   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 0);

   // Load modal sample server dialog
   WinDlgBox(HWND_DESKTOP,
             HWND_DESKTOP,
             ServerDlgProc,
             hmod,
             TAP_SERVER_DLG,
             NULL);

   // DeInitialize PM
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);

   // DeInitialize TAP server
   DeInitializeServer_TAP(pTapServerInfo);

	return (0);
}

