#ifndef _TAPSERVER
#define _TAPSERVER
//
// TAPSERVER.H
//
// TAP
// File Transfer Data Sharing
// Server Code
// Revision 1.00
//
// 12/28/94
//
#define TAP_SERVER_VERSION 	"LiveWire/WPS 1.0a"   // Max 30 chars
#include "tap.h"

typedef struct _TAPINFO
{
	ULONG  ulFlags;
	UCHAR  szFileName[CCHMAXPATH];  // Fully qualified file name
	LONG   lCurrentFileSize;        // Partial current size of the file
	LONG   lCompleteFileSize;       // Size the file will be when complete (-1 if unknown)
} TAPINFO, *PTAPINFO;

typedef struct _TAPSERVERINFO
{
	ULONG cb;	 			// Number of bytes in this structure

	HMTX hServerMutex;   // Semaphore for controlling access to server

	HFILE *phWritePipe;  // Array of pipe write handles currently opened
	LONG  lNumPipes;   	// Number of pipes currently opened

	TID tidTAPServer;    // Thread ID of the TAP Server
	HEV hevUpdate;       // Semaphore is released when an update is needed
	LONG lShutdown;      // True if the server should shut down
	LONG lFileOpen;		// True if a file is currently open (BOF => lFileOpen = TRUE, EOF => lFileOpen = FALSE)

	UCHAR szVersion[32];

	TAPINFO tiTapInfo;   // Data to be passed over the pipe
} TAPSERVERINFO, *PTAPSERVERINFO;

typedef struct _LAUNCHINFO
{
   ULONG cb;            // Number of bytes in this structure

   PTAPSERVERINFO pTapServerInfo;
   UCHAR szProgram[CCHMAXPATH];
   UCHAR szParams[CCHMAXPATH];
   UCHAR szTitle[CCHMAXPATH];
} LAUNCHINFO, *PLAUNCHINFO;

//
// For information on the functions prototyped below
// see TAPSERVER.C
//
int SelectApplication_TAP(PTAPSERVERINFO pTapServerInfo,
								  HWND hWndParent,
								  HWND hWndOwner,
								  HMODULE hmod);

int GetApplications_TAP(char *pszApplications,
									PULONG pulSize);

int GetApplicationInfo_TAP(char *szAppName,
									PTAPAPPENTRY pTapAppInfo);

PTAPSERVERINFO InitializeServer_TAP(char szVersion[]);

int DeInitializeServer_TAP(PTAPSERVERINFO pTapServerInfo);

int StartApplication_TAP(PTAPSERVERINFO pTapServerInfo,
									char *szAppPath,
									char *szAppParams,
									char *szAppTitle);

int SetFileName_TAP(PTAPSERVERINFO pTapServerInfo,
							char *szFileName);

int SetCompleteSize_TAP(PTAPSERVERINFO pTapServerInfo,
								long lCompleteFileSize);

int SetCurrentSize_TAP(PTAPSERVERINFO pTapServerInfo,
								long lCurrentFileSize);

int EmergencyClose_TAP(PTAPSERVERINFO pTapServerInfo);

int Cancel_TAP(PTAPSERVERINFO pTapServerInfo);

int EndOfFile_TAP(PTAPSERVERINFO pTapServerInfo);

int EndOfBatch_TAP(PTAPSERVERINFO pTapServerInfo);

void ServerThread_TAP(void *ServerInfo);

void LaunchApplicationThread_TAP(void *data);

FNWP SelectApplicationDlgProc;

#endif

