/************************************************************************/
/* cron.cmd                                                          */
/* Created: 23 Jan 1998                                                 */
/* Author: J. Pedone                                                    */
/* jpedone@flash.net                                                    */
/************************************************************************/
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call sysloadfuncs

Signal on Halt
tab='09'x
cr = '0d'x
lf = '0a'x

/* Get present working directory */
	workdir = Directory()
	cworkdir = workdir
	fworkdir = workdir||'\'

/* get time info */
	currMin = time('m')-time('h')*60
	disp_min = currMin
	if disp_min < 10 then disp_min = '0'disp_min
	currHour = time('h')
	today = date('s')
	currYear = substr(today,1,4)
	currMonth = substr(today,5,2)
	CurrDay = substr(today,7,2)
	today = date('w')
	currDow = wordPos(today,'Sunday Monday Tuesday Wednesday Thursday Friday Saturday')
	say 'Cron started at 'currHour':'disp_min' on 'currMonth'/'currDay'/'currYear

/* get time of program stop */
	call stream fworkdir'cron.ini','C','Open'
	line = linein(fworkdir'cron.ini')
	call stream fworkdir'cron.ini','C','Close'
	parse var line stop.h stop.m stop.mo stop.d stop.y stop.dow

/* check to see if anything was missed */
	do while rc <> 'READY:'
		rc=Stream(fworkdir'crontab','C','Open')
		call SysSleep 1
	End
	do while lines(fworkdir'crontab') > 0
		line = linein(fworkdir'crontab')
		parse var line minutes''hours''days''months''dows''years''session''type''file''parameters''pworkdir''close
		if currMin < stop.min Then minutes = '*'
		isMin   = late(minutes, currMin, stop.m)
		if currHour < stop.h Then hours = '*'
		isHour  = late(hours, currHour, stop.h)
		if currDay < stop.d Then days = '*'
		isDay   = late(days,currDay, stop.d)
		if currMonth < stop.mo Then months = '*'
		isMonth = late(months,currMonth, stop.mo)
		if currDOW < stop.dow Then dows = '*'
		isDow   = late(dows,currDow, stop.dow)
		if currYear < stop.y Then years = '*'
		isYear = late(years,curryear, stop.y)
		if isMin & isHour & isDay & isMonth & isDow & isYear then do
				If type = 'Message' then file = ''
				'@detach 'fworkdir'\msgbox.exe  Missed 'translate(type,'pm','PM')' detected:      ('file parameters')'
		End
	End
	Call stream fworkdir'crontab','c','close'

do forever
/* determine current time and date */
	currMin = time('m')-time('h')*60
	currHour = time('h')
	today = date('s')
	currYear = substr(today,1,4)
	currMonth = substr(today,5,2)
	CurrDay = substr(today,7,2)
	today = date('w')
	disp_min = currMin
	if disp_min < 10 then disp_min = '0'disp_min
	currDow = wordPos(today,'Sunday Monday Tuesday Wednesday Thursday Friday Saturday')
	
/* Parse and check the crontab file */
	do while rc <> 'READY:'
		rc=Stream(fworkdir'crontab','C','Open')
		call SysSleep 1
	End
	do while lines(fworkdir'crontab') > 0
		line = linein(fworkdir'crontab')
		parse var line minutes''hours''days''months''dows''years''session''type''file''parameters''pworkdir''close
		isMin   = matches(minutes, currMin)
		isHour  = matches(hours, currHour)
		isDay   = matches(days,currDay)
		isMonth = matches(months,currMonth)
		isDow   = matches(dows,currDow)
		isYear = matches(years,curryear)

/* check the time and launch if it's time */
		if isMin & isHour & isDay & isMonth & isDow & isYear then do
			if type = 'Message' Then Do
				say 'Launching message at 'currHour':'disp_min' on 'currMonth'/'currDay'/'currYear
				'@detach 'fworkdir'\msgbox.exe 'file''parameters
			End
			Else Do
				If session <> 'Detached' Then Do
					start_string = '@Start'
					If close = 'Yes' Then start_string = start_string' /c'
					if session = 'Minimized' then start_string = start_string' /min'
					if session = 'Full Screen' then start_string = start_string' /fs'
					if session = 'Window' then start_string = start_string' /win'
				End
				If session = 'Detached' Then Do
					start_string = 'Detach'
				End
				wd = strip(pworkdir,'B')
				if lastpos('\',wd) = length(wd) then do
					plen = length(wd)-1
					if plen > 1 Then Do
						wd = substr(wd,1,plen)
					End
				End
				rc = directory(wd)
				start_string||' '||strip(file,'B')||' '||strip(parameters,'B')
		 		call SysSleep 2
				rc = directory(cworkdir)
				say 'launching '||start_string||' '||strip(file,'B')||' '||strip(parameters,'B')||' at '||currHour||':'||disp_min||' on '||currMonth||'/'||currDay||'/'||currYear
			End 	/* Else */
		End 	/* if time */
	End 	/* While */
	call stream fworkdir'crontab','C','Close'
	rc = lineout(fworkdir'cron.ini',currHour disp_min currMonth currDay currYear currDOW,1) 
	call stream fworkdir'cron.ini','C','Close'
	call sysSleep 60-(time('s')-time('m')*60)

End  /* main loop */

matches:
	args = arg(1)
	if args='*' then return 1
	matched = 0
	parse var args value ',' args
	do while value<>''
		if value=arg(2) then matched = 1
		parse var value from '-' to
		if from<=arg(2) & arg(2)<=to then matched = 1
		parse var args value ',' args
	end
return matched

late:
	args = arg(1)
	if args='*' then return 1
	matched = 0
	parse var args value ',' args
	do while value<>''
		if value=arg(2) | value = arg(3) then matched = 1
		parse var value from '-' to
		if (from<=arg(2) & arg(2)<=to) | ((from>=arg(3) & arg(3)>=to) & to <> '') then matched = 1
		parse var args value ',' args
	end
return matched

halt:
	say 'Cron stopped at 'currHour':'disp_min' on 'currMonth'/'currDay'/'currYear
	rc = Stream(fworkdir'crontab','C','Close')
	rc = Stream(fworkdir'cron.ini','C','Close')
/* end of file */
