/*---------------------------------------------------------------------------
** IBM DSK & VMDISK Viewer filter & Extract wrapper v0.03 for Connect/2
**
** Accepts uncompressed DSK (created by SAVEDSKF or DISKIMAGE), VMDISK
** (created by VMDISK) and PM Diskcopy own disk image formats
**
** Uses PMDIMGEX.EXE v1.0b from the package PM Diskcopy 2.4 (PMD24E.ZIP)
**
** Filters output from PMDIMGEX.EXE:
**     22606  19.05.2000  15:15  A---  FIX\REQ.1\SRV_PROD.REQ
** to format suitable for CN:
**     DOCUMENT.TXT        34987  05.21.95  12:54:08
**
** Installation (place this file to path_to_CN\util and fill in an archiver
** record as shown):

[] Modify user defined Archiver setup ͻ
                                                                              
  Trademark          IBM DSK Image               List modifier          @     
  View command       pmdimgex.exe -v $ARC $MSG($CN\util\dsk.cmd)              
                                                 Default extension      dsk   
  View dir command                                                            
  Packer name                                    Exec options                 
  Unpacker name      $CN\util\dsk.cmd $USR        [ ] Swap main body          
  Extract            e $ARC $SRC                  [ ] Switch to user screen   
  Extract with dirs  x $ARC $SRC                  [X] Load COMMAND.COM        
  Add                                             [X] Enable Win95 LFN        
  Add with dirs                                   [ ] Prompt on overwrite     
  Move                                                                        
  Move with dirs                                 Name mask  *.dsk             
  Delete                                                                      
  Test                                           Environment condition        
  Password                                                                 
                                                                              
ͼ

**
** NOTES: 1. PMDIMGEX.EXE should be somewhere in the path or you have to
**           adjust the View command above and the variable G.extractor below.
**        2. If the extraction of big amount of files does not work (when
**           you extract a big directory, for example) lower the value of the
**           G.max_arg_len variable.
**-------------------------------------------------------------------------*/

G.extractor     = 'pmdimgex.exe'
G.max_arg_len   = 1010

parse arg cmd arc src
cmd = translate( cmd )

select
    when cmd = 'E'  then call extract arc, src, '-j'
    when cmd = 'X'  then call extract arc, src
    when cmd = ''   then call filter
    otherwise nop
end

exit

filter: procedure expose G.

    list_started = 0

    do while( lines() \= 0 )
        str = linein()
        if( str = '' ) then iterate
        if( \list_started &,
            str = '---------  ----------  -----  ----  ------------',
          ) then do
            list_started = 1
            iterate
        end
        if( list_started ) then do
            i = pos( '.', str )
            if( i < 5 ) then iterate
            fsize = substr( str, 1, i-3 )
            parse value substr( str, i-2 ) with fdate ftime . fname

            /* fix pmdimgex bug with thousand delimiter */
            str = translate( fsize, ' ', 'FF'x )
            fsize = ''
            do i = 1 to words( str )
                fsize = fsize||word( str, i )
            end
            if( fsize = '<DIR>' ) then iterate

            parse var fdate s1'.'s2'.'s3
            fdate = s2'.'s1'.'right( s3, 2 )

            say '"'strip( fname )'"' fsize fdate ftime
        end
    end

    return

extract: procedure expose G.

    parse arg arc, src, add_sw

    /* fix pmdimgex bug with backslashes */
    dest = strip( directory(), 'T', '\' )

    arg_beg = add_sw arc
    arg_end = '-d' dest '1>con 2>con'
    max_len = G.max_arg_len - length( arg_beg arg_end ) - 1

    n = 1
    if( left( src, 1 ) = '@' ) then do
        list = strip( src, 'L', '@' )
        src.1 = ''
        do while lines( list )
            str = fixslash( linein( list ) )
            if( length( src.n str ) > max_len ) then do
                n = n + 1
                src.n = ''
            end
            src.n = src.n str
        end
        call lineout list
    end
    else do
      src.1 = fixslash( src )
    end

    do i = 1 to n
        G.extractor arg_beg src.i arg_end
    end

    return

fixslash: procedure

    /* fix pmdimgex bug with backslashes */
    if( arg(1) \= '' & pos( '\', arg(1) ) = 0 ) then
        return '"\'strip( arg(1), 'B', '"' )'"'

    return arg(1)

