(*
 * Extended Attributes handling library
 *
 * Copyright (c) 2000 by Alexander Trunov [2:5069/10, jnc@os2.ru]
 *
 * History:
 *  2000/08/14  initial implementation
 *)

{$Use32+}

library EALib;

{$CDecl+,OrgName+,I-,S-,Delphi+}

{$LINKER
  DESCRIPTION      "EALib - Extended Attributes handling library (c) 2000 by Alexander Trunov [2:5069/10, jnc@os2.ru]"
  DATA MULTIPLE NONSHARED

  EXPORTS
    INITEALIB           = InitEALib
    ENUMEAS             = EnumEAs
    RETRIEVEEA          = RetrieveEA
    STOREEA             = StoreEA
    GETEATYPE           = GetEAType
    RETRIEVESTRINGSIZE  = RetrieveStringSize
    RETRIEVESTRING      = RetrieveString
    BUILDEAFROMSTRING   = BuildEAFromString
}

uses
  Objects, Strings, Os2Def, Os2Base;

const
  malloc: function(cb: Integer): Pointer = nil;

function InitEALib(ma: Pointer): Boolean;
begin

  Result := ma <> nil;

  malloc := ma;

end;

function _NewStr(const S: string): PString;
var
  P: PString;
begin
  if S = '' then P := nil else
  begin
    P := malloc(Length(S) + 1);
    P^ := S;
  end;
  Result := P;
end;

function EnumEAs(handle: ULONG; coll: PStringCollection): Integer;
var
  fst4: FILESTATUS4;
  ulEntry, ulCount, ulSize: ULONG;
  pvBuf: PFEA2;
begin

  Result := DosQueryFileInfo(handle, FIL_QUERYEASIZE, fst4, SizeOf(fst4));

  if Result = NO_ERROR then
  begin

    ulSize := fst4.cbList * 2;
    GetMem(pvBuf, ulSize);

    ulEntry := 1;

    while True do
    begin

      ulCount := 1;

      Result := DosEnumAttribute(ENUMEA_REFTYPE_FHANDLE, PChar(@handle),
        ulEntry, pvBuf^, ulSize, ulCount, ENUMEA_LEVEL_NO_VALUE);

      if Result = NO_ERROR then
      begin

        if ulCount = 0 then
          Break;

        coll^.AtInsert(coll^.Count, _NewStr(StrPas(PChar(@pvBuf^.szName))));

        Inc(ulEntry, ulCount);

      end
      else
        Break;

    end;

  end;

  FreeMem(pvBuf);

end;

function RetrieveEA(handle: ULONG; pszName: PChar; var ea: Pointer;
  var ulEASize: Cardinal): Integer;
var
  ulFEASize, ulGEASize, ulOffset: ULONG;
  eaop: EAOP2;
  fst4: FILESTATUS4;
begin

  Result := DosQueryFileInfo(handle, FIL_QUERYEASIZE, fst4, SizeOf(fst4));

  if Result = NO_ERROR then
  begin

    ulFEASize := 4 + StrLen(pszName) + 1 + fst4.cbList * 2; // approx. :)
    ulGEASize := 4 + 4 + 1 + StrLen(pszName) + 1;

    GetMem(eaop.fpFEA2List, ulFEASize);
    GetMem(eaop.fpGEA2List, ulGEASize);

    eaop.fpGEA2List^.cbList := ulGEASize;
    eaop.fpGEA2List^.list[0].oNextEntryOffset := 0;
    eaop.fpGEA2List^.list[0].cbName := StrLen(pszName);
    StrCopy(eaop.fpGEA2List^.list[0].szName, pszName);

    eaop.fpFEA2List^.cbList := ulFEASize;

    Result := DosQueryFileInfo(handle, FIL_QUERYEASFROMLIST, eaop,
      SizeOf(eaop));

    if Result = NO_ERROR then
    begin

      ulOffset := ULONG(@eaop.fpFEA2List^.list[0]) +
        eaop.fpFEA2List^.list[0].cbName + SizeOf(FEA2);

      ulEASize := eaop.fpFEA2List^.list[0].cbValue;

      ea := malloc(ulEASize);

      Move(Pointer(ulOffset)^, ea^, ulEASize);

    end;

    FreeMem(eaop.fpGEA2List);
    FreeMem(eaop.fpFEA2List);

  end;

end;

function StoreEA(handle: ULONG; pszName: PChar; ea: Pointer;
  ulEASize: ULONG): Integer;
var
  eaop: EAOP2;
  ulFEASize, ulOffset: ULONG;
begin

  ulFEASize := 4 + 4 + 1 + 1 + 2 + StrLen(pszName) + 1 + ulEASize;

  GetMem(eaop.fpFEA2List, ulFEASize);

  eaop.fpFEA2List^.cbList := ulFEASize;

  with eaop.fpFEA2List^.list[0] do
  begin

    oNextEntryOffset := 0;
    fEA := 0;
    cbName := StrLen(pszName);
    cbValue := ulEASize;
    StrCopy(PChar(@szName), pszName);
    ulOffset := ULONG(@eaop.fpFEA2List^.list[0]) + cbName + SizeOf(FEA2);
    Move(ea^, Pointer(ulOffset)^, ulEASize);

  end;

  Result := DosSetFileInfo(handle, FIL_QUERYEASIZE, eaop, SizeOf(eaop));

  FreeMem(eaop.fpFEA2List);

end;

function GetEAType(ea: Pointer): SmallWord;
begin

  if ea = nil then
    Result := 0
  else
    Result := PUSHORT(ea)^;

end;

function RetrieveStringSize(ea: Pointer): ULONG;
begin

  if ea = nil then
    Result := 0
  else
    Result := PUSHORT(ULONG(ea) + 2)^;

end;

function RetrieveString(ea: Pointer; pszValue: PChar): PChar;
var
  ulLen: ULONG;
begin

  ulLen := RetrieveStringSize(ea);

  if ulLen = 0 then
    pszValue[0] := #0
  else
    StrLCopy(pszValue, PChar(ULONG(ea) + 4), ulLen);

  Result := pszValue;

end;

function BuildEAFromString(pszValue: PChar; var ulEASize: Cardinal): Pointer;
begin

  ulEASize := StrLen(pszValue) + 1 + 2 + 2;

  Result := malloc(ulEASize);

  PUSHORT(Result)^ := EAT_ASCII;
  PUSHORT(ULONG(Result) + 2)^ := StrLen(pszValue);

  StrLCopy(PChar(ULONG(Result) + 4), pszValue, StrLen(pszValue));

end;

initialization

end.

