(*
 * Extended Attributes handling library usage example
 *
 * Copyright (c) 2000 by Alexander Trunov [2:5069/10, jnc@os2.ru]
 *
 * History:
 *  2000/08/14  initial implementation
 *)

{$Use32+}
uses
  VpSysLow, EALibInt, Objects;

const
  newLONGNAME = 'new longname';

var
  h: Longint;
  coll: PStringCollection;
  ea: Pointer;
  eaSize, eaType, lnSize: Cardinal;
  pszValue: PChar;

procedure DumpColl(coll: PStringCollection);
var
  i: Integer;
begin

  Writeln('item count: ', coll^.Count);

  for i := 0 to coll^.Count - 1 do
    Writeln('item #', i, ': "', PString(coll^.Items^[i])^, '"');

end;

function malloc(cb: Integer): Pointer; cdecl;
begin
  GetMem(Result, cb);
end;

begin

  InitEALib(@malloc);

  if SysFileOpen('107.wav', OPEN_ACCESS_READWRITE or OPEN_SHARE_DENYNONE,
    h) = 0 then
  begin

    coll := New(PStringCollection, Init(5, 10));

    Writeln('EnumEAs returned rc#=', EnumEAs(h, coll), #13#10);

    DumpColl(coll);

    Writeln;

    Writeln('RetrieveEA returned rc#=', RetrieveEA(h, '.LONGNAME', ea,
      eaSize), ', and ea=', Longint(ea));

    if ea <> nil then
    begin

      eaType := GetEAType(ea);
      Writeln('ea type ::= ', eaType);

      if eaType = $fffd then  // $fffd = EAT_ASCII;
      begin

        lnSize := RetrieveStringSize(ea);

        Writeln('.LONGNAME size ::= ', lnSize);

        GetMem(pszValue, lnSize + 1);
        Writeln('.LONGNAME ::= "', RetrieveString(ea, pszValue), '"');
        FreeMem(pszValue);

      end;

      FreeMem(ea);

      Writeln('trying to write new .LONGNAME -- "', newLONGNAME, '"..');

      ea := BuildEAFromString(newLONGNAME, eaSize);

      Writeln('StoreEA returned rc#=', StoreEA(h, '.LONGNAME', ea, eaSize));

      FreeMem(ea);

    end;

    Dispose(coll, Done);

    SysFileClose(h);

  end;

end.
