/*
 * The IBM HandShaker for OS/2 (CONNECT/2) plugins API
 * Copyright (c) 2000 by Alexander Trunov [2:5069/10, jnc@os2.ru]
 *
 * The IBM HandShaker (c) 1991-2000 by KHEMZ, Inc.
 *
 * This API is subset of The FAR File and Archive Manager.
 * The FAR File and Archive Manager (c) by Eugene Roshal [roshal@rarsoft.com]
 *
 * History:
 *  2000/08/20  Initial implementation
 *
 */

#include <os2def.h>

#ifndef __CONNECT_H__
#define __CONNECT_H__

// OpenPlugin ////////////////////////////////////////////////////////////////

const OPEN_PLUGINS_INFO = 0x00000001; // open from plugins menu
const OPEN_EDITOR       = 0x00000002; // open from CONNECT/2 editor

// ProcessEditorEvent ////////////////////////////////////////////////////////

const EE_READ   = 0x00000001; // file just have been read, but editor window
                              // has not yet displayed
const EE_SAVE   = 0x00000002; // called before saving
const EE_CLOSE  = 0x00000003; // called after closing editor window
const EE_REDRAW = 0x00000004; // called on every editor window drawing

// EditorControl /////////////////////////////////////////////////////////////

enum
{
  ECTL_GETSTRING = 0x00000001, // get string information
  ECTL_GETINFO   = 0x00000002, // get editor information
  ECTL_ADDCOLOR  = 0x00000003, // specify color for string area
  ECTL_GETCOLOR  = 0x00000004, // get color of a string area
  ECTL_SETSTRING = 0x00000005  // set string information
};

const EOPT_EXPANDTABS       = 0x00000001; // use tab characters option is off
const EOPT_PERSISTENTBLOCKS = 0x00000002; // non-persistent blocks is off
const EOPT_DELREMOVESBLOCKS = 0x00000004; // always off
const EOPT_AUTOINDENT       = 0x00000008; // auto indent is on
const EOPT_SAVEFILEPOSITION = 0x00000010; // always on
const EOPT_AUTODETECTTABLE  = 0x00000020; // always off
const EOPT_CURSORBEYONDEOL  = 0x00000040; // cursor is beyond of line-end

typedef struct EditorInfo
{
  int   EditorID;      // current active editor window
  char *FileName;      // filename being edited
  int   WindowSizeX,   // editor
        WindowSizeY,   //        window size
        TotalLines,    // total lines in edited file
        CurLine,       // current absolute line
        CurPos,        // current absolute position
        CurTabPos,     //  not implemented
        TopScreenLine, // current absolute top line
        LeftPos,       //  not implemented
        Options,       // options, EOPT_*
        TabSize;       // current tab size
  int   Reserved[8];
} *PEditorInfo;

typedef struct EditorGetString
{
  int   StringNumber; // -1 - get current string
  char *StringText,   // string data
        StringEOL;    // end of line sequence used in string
  int   StringLength, // length of data, pointed by StringText
        SelStart,     // now always -1
        SelEnd;       // now always -1
} *PEditorGetString;

typedef struct EditorSetString
{
  int   StringNumber; // -1 - set current string
  char *StringText;   // points to data to set
  int   StringLength; // length of the data, pointed by StringText
                      // StringEOL always ignored, therefore no decl.
} *PEditorSetString;

typedef struct EditorColor
{
  int StringNumber,   // number of string to process, -1 - current
      ColorItem,      // number of color area to get information about
      StartPos,       // string area
      EndPos,         //             to set color
      Color;          // color to set
} *PEditorColor;

typedef APIRET( APIENTRY *PFNEDITORCONTROL )( int hEditor, int iCommand, void *pParam );

// ProfileControl ////////////////////////////////////////////////////////////

enum
{
  POT_GETDATA = 0x00000001, // get profile information
  POT_SETDATA = 0x00000002  // set profile information
};

typedef struct ProfileAction
{
  char *PluginName;    // plugin name
  int   OperationType; // operation type, POT_*
  char *KeyName;       // key name
  int   DataLen;       // data length
  void *Data;          // data
} *PProfileAction;

typedef APIRET( APIENTRY *PFNPROFILECONTROL )( PProfileAction ppa );

// SetStartupInfo ////////////////////////////////////////////////////////////

typedef struct PluginStartupInfo
{
  int               StructSize;      // size of this structure
  char              ModuleName[260]; // full name with path of plugin module
  PFNEDITORCONTROL  EditorControl;   // address of EditorControl function
  PFNPROFILECONTROL ProfileControl;  // address of ProfileControl function
} *PPluginStartupInfo;

#endif
