/*
 *      INSTALL.CMD - RUNCMD V1.40 - C.Langanke 1999
 *
 *      installs a WPS folder for RUNCMD
 *
 *      Specify Parameter /B for batch processing. This will
 *      prevent INSTALL.CMD from opening the folder and the readme.
 */
/* The first comment is used as online help text */

 SIGNAL ON HALT NAME HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 env       = 'OS2ENVIRONMENT';
 TRUE      = (1 = 1);
 FALSE     = (0 = 1);
 CrLf      = '0d0a'x;
 Redirection = '1>NUL 2>&1';
 '@ECHO OFF'
 Title = CmdName Info;

 /* some OS/2 Error codes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.SHARING_VIOLATION  = 32;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 GlobalVars = 'Title CmdName env TRUE FALSE CrLf Redirection ERROR.';

 /* load RexxUtil */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* defaults */
 GlobalVars = GlobalVars 'BootDrive MessageFile MessageFileVersion'
 Flag.Batch         = FALSE;
 CallDir            = GetCallDir();
 BootDrive          = GetInstDrive();
 ConfigFile         = BootDrive'\CONFIG.SYS';
 ExecFile           = BootDrive'\_RUNCMD.CMD';

 /* determine message file */
 LanguageTag        = GetLanguageTag();
 MessageFileVersion = '1.40';
 MessageFile        = CallDir'\run'LanguageTag'.msg';

 IF (\FileExist(MessageFile)) THEN
    MessageFile = CallDir'\runeng.msg';
 IF (\FileExist(MessageFile)) THEN
 DO
    SAY  'Cannot find message file.';
    EXIT(ERROR.FILE_NOT_FOUND);
 END;


 SIGNAL ON HALT NAME HALT_NLS

 DO UNTIL (TRUE)
    /* get parms */
    ARG Parms
    IF (POS('/B', Parms) > 0) THEN
       Flag.Batch = TRUE;

    /* show Title */
    SAY;
    SAY GetNlsString('Title');
    SAY;

    /* is RUNCMD already added to config.sys ? */
    rc = SysFileSearch( 'RUNCMD.EXE', ConfigFile, 'Line.');
    IF (rc \= ERROR.NO_ERROR) THEN
    DO
       SAY  GetNlsString('ErrorSysFileSearch', rc);
       LEAVE;
    END;
    IF (Line.0 > 0) THEN
       SAY  CmdName':' GetNlsString('ErrorAlreadyIncluded', ConfigFile);
    ELSE
    DO
       rc = LINEOUT(ConfigFile, '');
       IF (rc \= ERROR.NO_ERROR) THEN
       DO
          SAY  CmdName':' GetNlsString('ErrorCannotAdd', ConfigFile);
          SAY  '    CALL='CallDir'\RUNCMD.EXE';
       END;
       ELSE
       DO
          rc = LINEOUT(ConfigFile, 'REM ****** RUNCMD ****');
          rc = LINEOUT(ConfigFile, '    CALL='CallDir'\RUNCMD.EXE');
          rc = LINEOUT(ConfigFile, '');
          rc = LINEOUT(ConfigFile);
          SAY  CmdName':' GetNlsString('InfoAdded', ConfigFile);
       END;
    END;

    /* create object */
    SAY;
    CALL CHAROUT, GetNlsString('InfoCreateObjects') '... ';
    rc = SysCreateObject( 'WPFolder',  GetNlsString('IconFolder'),   '<WP_DESKTOP>',      'CCVIEW=NO;OBJECTID=<RUNCMD_FOLDER>;', 'U');
    rc = SysCreateObject( 'WPProgram', GetNlsString('IconProgram'),  '<RUNCMD_FOLDER>',   'CCVIEW=NO;PROGTYPE=WINDOWABLEVIO;EXENAME='CallDir'\RUNCMD.EXE;OBJECTID=<RUNCMD_PROGRAM>;', 'U');
    rc = SysCreateObject( 'WPProgram', GetNlsString('IconHelp'),     '<RUNCMD_FOLDER>',   'CCVIEW=NO;PROGTYPE=WINDOWABLEVIO;EXENAME=*;STARTUPDIR='CallDir';PARAMETERS=/C RUNCMD /H & PAUSE;OBJECTID=<RUNCMD_HELP>;', 'U');
    rc = SysCreateObject( 'WPProgram', GetNlsString('IconReadme'),   '<RUNCMD_FOLDER>',   'CCVIEW=NO;PROGTYPE=PM;EXENAME=E.EXE;PARAMETERS='CallDir'\Readme;OBJECTID=<RUNCMD_README>;', 'U');
    rc = SysCreateObject( 'WPProgram', GetNlsString('IconSetBreak'), '<RUNCMD_FOLDER>',   'CCVIEW=NO;PROGTYPE=WINDOWABLEVIO;MINIMIZED=YES;EXENAME=*;PARAMETERS=/C TYPE NUL>RUNCMD || ECHO ;OBJECTID=<RUNCMD_SETBREAK>;', 'U');
    rc = SysCreateObject( 'WPProgram', GetNlsString('IconDelBreak'), '<RUNCMD_FOLDER>',   'CCVIEW=NO;PROGTYPE=WINDOWABLEVIO;MINIMIZED=YES;EXENAME=*;PARAMETERS=/C DEL RUNCMD || ECHO ;OBJECTID=<RUNCMD_DELBREAK>;', 'U');
    rc = SysCreateObject( 'WPProgram', GetNlsString('IconEditExec'), '<RUNCMD_FOLDER>',   'CCVIEW=NO;PROGTYPE=PM;EXENAME=E.EXE;PARAMETERS='ExecFile';OBJECTID=<RUNCMD_EDITEXEC>;', 'U');
    SAY 'Ok.';

    IF (\Flag.Batch) THEN
    DO
       rc = SysOpenObject('<RUNCMD_FOLDER>', 'DEFAULT', 1);
       rc = SysOpenObject('<RUNCMD_FOLDER>', 'DEFAULT', 1);
       rc = SysOpenObject('<RUNCMD_README>', 'DEFAULT', 1);
       rc = SysOpenObject('<RUNCMD_README>', 'DEFAULT', 1);
    END;

    /* create template for RUNCMD.CMD */
    IF (\FileExist(ExecFile)) THEN
    DO
       rc = LINEOUT( ExecFile, '@ECHO OFF');
       rc = LINEOUT( ExecFile, ' SETLOCAL');
       rc = LINEOUT( ExecFile, '');
       rc = LINEOUT( ExecFile, ': - 'GetNlsString('ExecFileComment'));
       rc = LINEOUT( ExecFile);
    END;
 END;

 EXIT(rc);

/* ------------------------------------------------------------------------- */

HALT_NLS:
 SAY;
 SAY GetNlsString('Halt');
 EXIT(ERROR.GEN_FAILURE);

HALT:
 SAY;
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 SAY;
 SAY Title
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 DO WHILE (ThisLine \= ' */')
    ThisLine = LINEIN(Thisfile);
    SAY SUBSTR(ThisLine, 7);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ========================================================================= */
PullVariable: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG Default, Message

 SAY;
 CALL CHAROUT, Message '['Default'] : ';
 PARSE PULL PullVar;
 IF (LENGTH(PullVar) > 0) THEN
    RETURN(PullVar);
 ELSE
    RETURN(Default);

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE  EXPOSE (GlobalVars)
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE EXPOSE env
 ARG DirName, EnvVarName

 /* Default: OS2 directory */
 IF (DirName = '') THEN DirName = '\OS2';

 /* Default: PATH  */
 IF (EnvVarName = '') THEN EnvVarName = 'PATH';

 PathValue = VALUE(EnvVarName,,env);

 DirName = ':'DirName';';
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ------------------------------------------------------------------------- */
LoadMsgString: PROCEDURE  EXPOSE (GlobalVars)
 PARSE ARG MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 Message = SysGetMessage(MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
 RETURN(LEFT(Message, LENGTH(Message) - 2));

/* ========================================================================= */
GetNlsString: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG MessageId, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 /* default values */
 Message     = '*** Message' Id 'not found. ***';

 /* default values */
 MessageFileIdText = 'RUNCMD_MESSAGEFILE';
 IF (MessageFileVersion \= '') THEN
    MessageFileIdText = MessageFileIdText'_'MessageFileVersion;

 /* load MessageIds and YesNo Keys*/
 MessageFileInfo        = LoadMsgString(0, MessageFile)
 PARSE VAR MessageFileInfo MessageFileId MessageLanguage MessageFileKeys MessageListcount
 IF ((MessageFileIdText \= MessageFileId) | (LENGTH(MessageFileKeys) \= 2))THEN
 DO
    SAY 'Invalid message file' MessageFile;
    EXIT(ERROR.INVALID_DATA);
 END;

 /* load Messagelist*/
 MessageList = '';
 DO i = 1 TO MessageListcount
    MessageList = MessageList LoadMsgString(i, MessageFile)
 END;

 /* handle special id YesNoKeys */
 IF (MessageId = 'YESNOKEYS') THEN
    RETURN(MessageFileKeys);

 /* read message ids */
 MessagePos   = WORDPOS(TRANSLATE(MessageId), TRANSLATE(MessageList));
 IF (MessagePos > 0) THEN
 DO
    ThisMessage = LoadMsgString(MessagePos + MessageListcount, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
    IF (ThisMessage \= '') THEN
       Message = ThisMessage;
 END;

 RETURN(Message);

/* ========================================================================= */
GetLanguageTag: PROCEDURE EXPOSE (GlobalVars)

 LanguageTag = 'eng';
 SyslevelFile = BootDrive'\OS2\INSTALL\SYSLEVEL.OS2';

 ValidIds     = '0EG';
 LanguageTags = 'eng eng deu';

 DO UNTIL (TRUE)
    CurrCsd = CHARIN(SyslevelFile, 45, 8);
    IF (CurrCsd = '') THEN
    DO
       SAY 'Cannot determine language of OS/2 version.';
       EXIT(ERROR.INVALID_DATA);
    END;
    LanguageId = SUBSTR( CurrCsd, 3, 1);
    LanguageIndex = POS( LanguageId, ValidIds);
    IF (LanguageIndex = 0) THEN
       LEAVE;

    LanguageTag = WORD( LanguageTags, LanguageIndex);

 END;

 /* cleanup */
 rc =  STREAM(SyslevelFile, 'C', 'CLOSE');
 RETURN(LanguageTag);

