/****************************************************************/
/* MAKEOBJ.CMD  REXX Program to install CIDSETUP object 	*/
/*								*/
/* Assumes this program is being run from the directory where   */
/* all of the CIDSETUP files have been unzipped			*/
/****************************************************************/


/* Load REXXUTIL functions					*/
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs


curdir = directory()

/* If in root directory, curdir will be x:\ so need to strip \  */
if LENGTH(curdir)=3 then curdir = SUBSTR(curdir,1,2)

/* Add the CIDSETUP Program Object				*/

classname='WPProgram'
title=    'CIDSETUP'
location= '<WP_DESKTOP>'
setup=    'OBJECTID=<CIDSETUP>;'||,
	  'EXENAME='curdir'\cidsetup.exe;'||,
	  'ICONFILE='curdir'\cidsetup.ico;'
call BuildObject	  


exit


/****************************************************************/
/* SUBROUTINES							*/

/****************************************************************/
/* Build Object Procedure					*/

BuildObject:

  result = SysCreateObject(classname, title, location, setup, 'f')

  if result = 1 then 
    say 'Successful!!  'title 'has been created!'
  else 
    say 'NOT!  Failed to create 'title'.  Return code is 'result

Return


