/* DANSK.CMD: Installr MEMSIZE p dansk. */

'@Echo Off'
'CHCP 850'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installrer MEMSIZE...'
Say ''


/* Verify the existence of the various component files. */

Language = 'DANSK'

Result = SysFileTree( 'MEMSIZE2.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEJL: MEMSIZE2.EXE ikke fundet!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEJL: 'Language'.DLL ikke fundet!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEJL: 'Language'.HLP ikke fundet!'
  Signal DONE
  End

/* Sprg efter installationskataloget. */

BootDrive = Filespec('Drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))
Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = BootDrive'\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Venligst indtast den fulde sti der peger p hvor du nsker'
Say '  MEMSIZE installeret (standard 'Default'): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Dan installationskataloget hvis ndvendigt. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEJL: Kan ikke oprette installationskataloget.'
    Signal DONE
    End
  End
Say ''


/* Save the target directory. */

SysIni( "USER", "MEMSIZE", "INIPATH", Directory )
SysIni( Directory"\MEMSIZE2.INI", "MEMSIZE", "INIPATH", Directory )


/* Sprg efter installations folder - (Ask for the target folder.) */

Say 'nsker du at placere MEMSIZE i start folderen? (J/N)'
Pull YesNo
If YesNo = "J" Then
  Do
  Folder = '<WP_START>'
  Say 'Objekt bliver placeret i start folderen.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Objekt placeres p arbejdspladsen.'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Udfr installationen. */

Say 'Kopierer MEMSIZE til 'Directory' ...'
Copy MEMSIZE2.EXE Directory                  '1>NUL'
Copy "OBJECTS.OS2\"Language".DLL" Directory"\MEMSIZE2.DLL" '1>NUL'
Copy "OBJECTS.OS2\"Language".HLP" Directory"\MEMSIZE2.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE2.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE2.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE2.INF"
      End
   "HLP2INF" Directory"\MEMSIZE2.HLP"
   End

Result = SysFileTree( "SNPSHOT2.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNPSHOT2.EXE" Directory"\SNPSHOT2.EXE"  '1>NUL'
   End

Say 'Opretter program objekt...'
Type = 'WPProgram'
Title = 'System ressourcer'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE2.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objekt oprettet!  Frdig.'
Else
  Say 'FEJL: Objekt ikke oprettet.'

Signal DONE

FAILURE:
Say 'REXX fejl.'
Signal DONE

HALT:
Say 'REXX stoppet.'
Signal DONE

SYNTAX:
Say 'REXX syntax fejl.'
Signal DONE

DONE:
Exit
