/* NORSK.CMD: Installerer MEMSIZE p norsk. */

'@Echo Off'
'CHCP 850'

/* Hent REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialiser */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installerer MEMSIZE...'
Say ''


/* Sjekk eksistensen av de forskjellige komponentfilene. */

Language = 'NORSK'

Result = SysFileTree( 'MEMSIZE2.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: MEMSIZE2.EXE ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: 'Language'.DLL ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: 'Language'.HLP ikke funnet!'
  Signal DONE
  End

/* Spr etter installasjonskatalogen. */

BootDrive = Filespec('Drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))
Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = BootDrive'\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Vennligst oppgi fullt navn for den katalogen hvor du nsker'
Say '  MEMSIZE installert (standard 'Default'): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Lag installasjonskatalogen om ndvendig. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEIL: Kan ikke opprette installasjonskatalogen.'
    Signal DONE
    End
  End
Say ''


/* Save the target directory. */

SysIni( "USER", "MEMSIZE", "INIPATH", Directory )
SysIni( Directory"\MEMSIZE2.INI", "MEMSIZE", "INIPATH", Directory )


/* Spr etter ml-katalog. */

Say 'nsker du  plassere MEMSIZE i oppstart-katalogen? (J/N)'
Pull YesNo
If YesNo = "J" Then
  Do
  Folder = '<WP_START>'
  Say 'Programobjekt plasseres i oppstart-katalogen.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Programobjekt plasseres p arbeidsomrdet.'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Gjr installasjonen. */

Say 'Kopierer MEMSIZE til 'Directory' ...'
Copy MEMSIZE2.EXE Directory                  '1>NUL'
Copy "OBJECTS.OS2\"Language".DLL" Directory"\MEMSIZE2.DLL" '1>NUL'
Copy "OBJECTS.OS2\"Language".HLP" Directory"\MEMSIZE2.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE2.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE2.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE2.INF"
      End
   "HLP2INF" Directory"\MEMSIZE2.HLP"
   End

Result = SysFileTree( "SNPSHOT2.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNPSHOT2.EXE" Directory"\SNPSHOT2.EXE"  '1>NUL'
   End

Say 'Oppretter programobjekt...'
Type = 'WPProgram'
Title = 'Systemressurser'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE2.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objekt opprettet!  Ferdig.'
Else
  Say 'FEIL: Objekt ikke opprettet.'

Signal DONE

FAILURE:
Say 'REXX feil.'
Signal DONE

HALT:
Say 'REXX stoppet.'
Signal DONE

SYNTAX:
Say 'REXX syntaks feil.'
Signal DONE

DONE:
Exit
