/* UNINSTAL.CMD: Uninstall MEMSIZE. */

'@Echo Off'
'CHCP 850'


/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

/* Confirm the user's intentions. */

Call SysCls
Say 'Do you wish to uninstall MEMSIZE? (Y/N)'
Pull YesNo
If \ ( YesNo = "Y" ) Then Signal Done


/* Announce the start of the destruction . . . */

Say 'Removing MEMSIZE...'
Say ''

/* Determine MEMSIZE directory. */

Default = SysIni('USER', 'MEMSIZE2', 'INIPATH' )
If Default = 'ERROR:' Then Do
  Say 'ERROR: MEMSIZE does not appear to be installed on this system.'
  Signal DONE
  End

If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)


/* Remove every MEMSIZE file from the install directory. */

Result = SysFileTree( Default"\MEMSIZE2.EXE", 'Files', 'F' )
If Files.0 > 0 Then Do
  Say "Removing MEMSIZE2.exe."
  'Erase' Default'\MEMSIZE2.exe'
  End

Result = SysFileTree( Default"\MEMSIZE2.DLL", 'Files', 'F' )
If Files.0 > 0 Then Do
  Say "Removing MEMSIZE2.dll."
  'Erase' Default'\MEMSIZE2.dll'
  End

Result = SysFileTree( Default"\MEMSIZE2.HLP", 'Files', 'F' )
If Files.0 > 0 Then Do
  Say "Removing MEMSIZE2.hlp."
  'Erase' Default'\MEMSIZE2.hlp'
  End

Result = SysFileTree( Default"\MEMSIZE2.INI", 'Files', 'F' )
If Files.0 > 0 Then Do
  Say "Removing MEMSIZE2.INI."
  'Erase' Default'\MEMSIZE2.INI'
  End

Result = SysFileTree( Default"\MEMSIZE2.DOC", 'Files', 'F' )
If Files.0 > 0 Then Do
  Say "Removing MEMSIZE2.doc."
  'Erase' Default'\MEMSIZE2.doc'
  End

Result = SysFileTree( Default"\MEMSIZE2.INF", 'Files', 'F' )
If Files.0 > 0 Then Do
  Say "Removing MEMSIZE2.inf."
  'Erase' Default'\MEMSIZE2.inf'
  End

Result = SysFileTree( Default"\MEMSIZE2.LOG", 'Files', 'F' )
If Files.0 > 0 Then Do
   Say "Removing MEMSIZE2.log."
   'Erase' Default'\MEMSIZE2.log'
   End

Result = SysFileTree( Default"\SNPSHOT2.EXE", 'Files', 'F' )
If Files.0 > 0 Then Do
   Say "Removing SNPSHOT2.exe."
   'Erase' Default'\SNPSHOT2.exe'
   End

Result = SysFileTree( Default"\*.*", 'Files', 'F' )
If Files.0 == 0 Then Do
   Say "Removing directory "Default"."
   'rmdir' Default
   End


/* Destroy the MEMSIZE WPS objects. */

Say "Removing WPS objects."
Result = SysDestroyObject( "<MEMSIZE>" )


/* Remove the USER/MEMSIZE/INIPATH entry. */

Say "Removing forwarding entry in OS2.INI."
Result = SysIni('USER', 'MEMSIZE', 'DELETE:' )
Result = SysIni('USER', 'MEMSIZE2', 'DELETE:' )


/* Terminate procedure. */

If Files.0 == 0 Then Do
   Say "Done.  You will still need to manually"
   Say "  remove UNINSTAL.CMD."
   End /* do */
Else Do
   Say "Done.  You will still need to manually"
   Say "  remove UNINSTAL.CMD and the directory"
   Say "  '"Default"'."
   End /* do */
Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
