/*Ŀ*/
/*                                                                          */
/* PROGRAM NAME: PMSPY                                                      */
/* -------------                                                            */
/*  A PM program that is used to look at or 'spy' on the message queue of   */
/*  other PM applications windows.                                          */
/*                                                                          */
/* COPYRIGHT:                                                               */
/* ----------                                                               */
/*  Copyright (C) International Business Machines Corp., 1992               */
/*                                                                          */
/* DISCLAIMER OF WARRANTIES:                                                */
/* -------------------------                                                */
/*  The following [enclosed] code is sample code created by IBM Corporation.*/
/*  This sample code is not part of any standard IBM product and is provided*/
/*  to you solely for the purpose of assisting you in the development of    */
/*  your applications.  The code is provided "AS IS", without warranty of   */
/*  any kind.  IBM shall not be liable for any damages arising out of your  */
/*  use of the sample code, even if they have been advised of the           */
/*  possibility of such damages.                                            */
/*                                                                          */
/* For details on what this program does etc., please see the PMSPY.C file. */
/*                                                                          */
/**/

/*Ŀ*/
/* PMSPYINI.H                                                               */
/*                                                                          */
/* interface definitions for PMSPYINI.C                                     */
/**/

/*Ŀ*/
/* INI file data                                                            */
/**/
typedef struct                            /* template for data in INI file    */
{
  FONTNAME    szListFont;                 /* current SPY list font            */

  SWP         swpAgent;                   /* current SPY window position      */

  CHAR        szLog    [CCHMAXPATH],      /* current LOG     file             */
              szProfile[CCHMAXPATH];      /* current PROFILE file             */

}  INI_DATA,
 *PINI_DATA;

/*Ŀ*/
/* Function declarations                                                    */
/**/
extern BOOL WriteSpyINI(HWND      hFrame,   /* HWND(Agent's frame) */
                        LONG      Agent,    /* one-origin "agent" */
                        PINI_DATA pIni);    /* INI data to write */

extern BOOL ReadSpyINI(HWND      hFrame,   /* HWND(Agent's frame) */
                       LONG      Agent,    /* one-origin "agent" */
                       PINI_DATA pIni);    /* INI data to read */
