/* REXX program to build the desktop object for PMSysLvl */

parse source target_dir                                     /* Let's get the name of this cmd file */

parse var target_dir junk junk target_dir                   /* Let's get rid of the OS/2 Command parts of the sourceline */

target_dir=reverse(target_dir)                              /* Turn the directory name around */

position=pos("\",target_dir)                                /* Find the first (really last) '\' character */

target_dir=right(target_dir,length(target_dir)-position)    /* Let's prune the '\PMSLINST.CMD' from the end of the target_dir */

target_dir=reverse(target_dir)||'\'                         /* Let's turn it back around & add a '\' */

'@echo off'
'CLS'

call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

SAY 'Creating desktop object for PMSyslvl'


classname = 'WPProgram'
title     = 'PMSysLevel'
location  = '<WP_DESKTOP>'
iconparm  = 'ICONFILE='|| target_dir || '\PMSYSLVL.ICO;'
setup     = 'EXENAME=' || target_dir || '\PMSYSLVL.EXE;'||,
            'PROGTYPE=PM;'
call SysCreateObject classname, title, location, setup, 'r'

call SysDropFuncs

Say 'Desktop object successfully created for PMSysLevel'

