/* AddBook.cmd
 *
 * add one book icon to the books folder, and if necessary,
 * create the OS/2 Books folder used by Suntan Special
 *
 * AddBook supports OS/2 INF and PDF file extensions. All other
 * extensions are treated as plain text.
 *
 * AddBook returns 1 for failure, 0 for success
 *
 * Copyright (C) 2017 Blonde Guy
 * All Rights Reserved
 */

helpName = arg(1) /* name of the book */
helpFile = arg(2) /* fully qualified filename of help file */
helpID =   arg(3) /* object ID for the help file */

/* parameter checking */
if helpName = '' | helpFile = '' | helpID = '' then do
   call LogCdi "AddBook("helpName"," helpFile"," helpID") is in error"
   call LogCdi "no object was created."
   return 1
end

helpFolderName = 'OS/2 Books'

/* handle non-inf books */
ext = translate(right(helpFile, 3))
if ext = 'INF' then do
   viewName = FindBootDrive() || ':\os2\view.exe'
end
else if ext = 'PDF' then do
   lucide = cdglobal('appsDir') || '\lucide\lucide.exe'
   if stream(lucide, 'c', 'query exists') <> '' then do
      viewName = lucide
   end
   else do
      qpdfview = cdglobal('appsDir') || '\qpdfview\qpdfview.exe'
      if stream(qpdfview, 'c', 'query exists') <> '' then do
         viewName = qpdfview
      end
      else do
         ac = SysIni('USER', 'OS2 Kit for Acrobat Reader', 'Path')
         if ac <> 'ERROR:' then do
            ac = strip(ac, 't', d2c(0))
            viewName = ac || '\ar5os2.exe'
            if stream(viewName, 'c', 'query exists') = '' then do
               viewName = ac || '\aros2.exe'
               if stream(viewName, 'c', 'query exists') = '' then do
                  call LogCdi "AddRedBook failed to find Acrobat Reader"
                  return
               end
            end
         end
         else do
            call LogCdi "AddRedBook failed to find any Acrobat Reader"
            return
         end
      end
   end
end
else do
   viewName = 'e.exe'
end

call LogCdi "creating" helpName "object"
helpDir = strip(filespec('d', helpFile) || filespec('p', helpFile), 't', '\')
rc = SysCreateObject('WPProgram', helpName, '<WP_DESKTOP>',,
                     'OBJECTID=' || helpID || ';' ||,
                     'EXENAME=' || viewName || ';' ||,
                     'PARAMETERS=' || filespec('n', helpFile) || ';' ||,
                     'STARTUPDIR=' || helpDir || ';', 'UpdateIfExists')
if rc = 0 then do
   call LogCdi "AddBook: could not create book object"
   return 4
end

helpFolderID = '<BG_OS2BOOKS_FOLDER>'
rc = SysMoveObject(helpID, helpFolderID)
if rc = 0 then do
   helpParentID = cdglobal('helpFolder')
   if helpParentID = '' then do
      helpParentID = '<WP_ASSISTANCE>'
   end
   
   helpDir = strip(filespec('d', helpFile) || filespec('p', helpFile), 't', '\')

   rc = SysCreateObject('WPFolder', helpFolderName, helpParentID,,
                        'OBJECTID=' || helpFolderID ||';OPEN=ICON',,
                        'UpdateIfExists')
   if rc = 0 then do
      call LogCdi "Could not create" helpFolderName "Folder"
      return 5
   end

   /* move object to the new books folder */
   call SysMoveObject helpID, helpFolderID
end

address cmd '@sendmsg "' || helpFolderName || '" WM_CLOSE'

return 0
