/* LogCdi.cmd
 * logging function for Suntan Special
 *
 * Copyright (C) 2015 Blonde Guy
 * All Rights Reserved
 */

parse arg message

/* don't log or echo display commands */
if left(message, 1) \= '!' then do

   /* prepend a timestamp to the message */
   logmsg = date() time() message

   /* put the message on the screen */
   say message
   
   /* append the timestamped  message to the log file */
   suntanDir = strip(SysIni('USER', 'Suntan Special', 'Settings'), 't', d2c(0))
   if suntanDir <> 'ERROR:' then do
      LogName = suntanDir || '\cd-log.txt'
      call lineout LogName, logmsg
      call lineout LogName
   end
end
else do
   logmsg = message
end

/* send the message to the display monitor */
pipename = '\pipe\suntan'

call SysWaitNamedPipe pipename, -1
call stream pipename, 'c', 'open write'
call lineout pipename, logmsg
call stream pipename, 'c', 'close'

return
