/* Save Boot Manager
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command saves Boot Manager settings, then programs
 *   boot manager to always boot the current partition. RestoreBootManager
 *   undoes the changes.
 *
 *   SaveBootManager is useful when running a process such as FixPak 15
 *   which reboots the machine twice. The reboot command is guaranteed
 *   to start the current partition only once.
 *
 * Copyright (C) 2005 Blonde Guy
 * All Rights Reserved
 */

productName = 'Save Boot Manager'
productDate = '2006-12-28 19:28:56'
productCategory = 'Configuration'

parse arg appsDir
call LogCdi "Saving bootmanager defaults"
setbootFile = appsDir || '\Suntan\setboot.txt'
if stream(setbootFile, 'c', 'query exists') = '' then do
   call LogCdi "saving boot manager settings in" setbootFile
   address cmd '@setboot /q >' setbootFile
   call LogCdi "setboot returned" rc
end

call LogCdi "Looking up boot partition name"
bootPartition = getboot(setbootFile)

call LogCdi "setting bootmanager default to" bootPartition
address cmd '@setboot /1:"' || bootPartition || '"'
if rc <> 0 then do
   call LogCdi 'setboot /1:"' || bootPartition || '" returned' rc
end
address cmd '@setboot /X:1'
if rc <> 0 then do
   call LogCdi "Warning: setboot /X:1 returned" rc
end

call LogCdi productName "complete"
return 0


/* get boot manager data */
getboot:
parse arg setbootFile
call LogCdi "parsing boot information in" setbootFile
parse value linein(setbootFile) with . timeout
parse value linein(setbootFile) with . . index
parse value linein(setbootFile) with . mode
parse value linein(setbootFile) with . . System0
parse value linein(setbootFile) with . . System1
parse value linein(setbootFile) with . . System2
parse value linein(setbootFile) with . . System3
parse value linein(setbootFile) with . . currentSystem

timeout = strip(timeout)
index = strip(index)
mode = strip(mode)
System0 = strip(System0)
System1 = strip(System1)
System2 = strip(System2)
System3 = strip(System3)
currentSystem = strip(currentSystem)

if currentSystem = '' then do
   currentSystem = 'None'
end

say "Boot Manager Data"
say "Timeout" timeout
say "Index" index
say "Mode" mode
say "System 0" system0
say "System 1" system1
say "System 2" system2
say "System 3" system3
say "Current System" currentSystem

return currentSystem
