/* Present a path dialog to the user, and return the user's response
 *
 * Arguments
 *   arg(1) - the dialog name. This will be the title line for VIO and the
 *            name of the tab on the Display Monitor.
 *   arg(2) - the current path.
 *   arg(3) - instructions to the user.
 *
 * Copyright (C) 2006 Blonde Guy
 * All Rights Reserved
 */

pipeName = '\pipe\suntan'
dialogName = 'sourceDir'


if arg() = 0 then do
   oldPath = cdglobal('sourceDir')
   response = EditPath(dialogName, oldPath, "Test the edit path screen.")
   say response
   exit
end

call SysWaitNamedPipe pipename, -1
pipestate = stream(pipeName, 'c', 'open')
if left(pipestate, 8) = 'NOTREADY' then do
   dialogName = arg(1)
   defaultValue = arg(2)
   say dialogName
   say ""
   call SayWords arg(3)
   say ""
   say "Press Enter to accept a value of" defaultValue
   say "or enter a new value and press Enter."
   parse pull response
   if response = '' then do
      response = defaultValue
   end
   response = 'dc=' || response
end
else do
   x = arg(1)
   do i = 2 to arg()
      x = x || d2c(10) || arg(i)
   end

   call lineout pipeName, "!editpath" x
   
   call SysSleep 1
   
   response = ''
   do until response \= ''
      pipeState = stream(pipeName, 'c', 'open')
      if left(pipestate, 8) = 'NOTREADY' then return arg(2)
      call lineout pipeName, "!dialogwait"
      response = linein(pipeName)
      call SysSleep 1
   end
end

return substr(response, 4)
