/* QuerySettings.cmd
 *
 * Description
 *   QuerySetting(keyword, 'Value') returns the current value of the setting
 *   QuerySetting(keyword, 'DefaultValue') returns the default value of the setting
 *   QuerySetting(keyword, 'Instructions') returns the instructions for the setting
 *   QuerySetting(keyword, 'Prompt') returns the name, value and instructions for the setting
 *   QuerySetting(keyword, 'Query') obtains a value from the user for the setting
 *   QuerySetting('All') returns a semicolon delimited list of all settings keywords
 *
 * Copyright (C) 2017 Blonde Guy
 * All Rights Reserved
 */

productName = 'Query Settings'
dialogName = 'Edit Setting'
signal on syntax

keyword = strip(arg(1))
command = arg(2)

suntanDir = strip(SysIni('User', 'Suntan Special', 'Settings'), 't', d2c(0))
if suntanDir = 'ERROR:' then suntanDir = '.'

if translate(keyword) = 'SUNTANDIR' then return suntanDir

if keyword = 'All' then do
   return All()
end

/* testing */
if command = 'Prompt' then do
   return getPrompt()
end

if command = 'Value' then do
   return getValue(keyword)
end

if command = 'Query' then do
   return getQuery(keyword)
end

interpret 'return' keyword || '(' || command || ')'


syntax:
/* if keyword is not found, return empty string */
if rc <> 43 then do
   call LogCdi "Syntax error was signaled. keyword =" keyword "command =" command
   call LogCdi "Condition" Condition('c') "was raised"
   call LogCdi "QuerySettings: Error" rc "on line" sigl
   call LogCdi ErrorText(rc)
end

response = 'syntax error'
return response

all: /* reflection in REXX */
response = ''
do i=1 to sourceline()
   this = sourceline(i)
   if pos(':', this) > 0 then do
      thisLabel = left(this, pos(':', this))
      if pos(' ', thisLabel) = 0,
         & thisLabel \= 'all:',
         & thisLabel \= 'syntax:',
         & thisLabel \= 'getSetting:',
         & thisLabel \= 'CurrentSetting:',
         & thisLabel \= 'getPrompt:',
         & thisLabel \= 'getValue:',
         & thisLabel \= 'getQuery:',
         & thisLabel \= 'makeBody:' then do
         response = response || left(this, pos(':', this) - 1) || ';'
      end
   end
end
response = strip(response, 't', ';')
return response

getSetting:
settingsFile = suntanDir || '\Settings.Txt'
if stream(settingsFile, 'c', 'query exists') = '' then do
   call LogCdi "Warning: the settings file" settingsFile "was not found."
   return ''
end
do while lines(settingsFile)
   this = linein(settingsFile)
   if left(this, 1) = ';' then iterate
   parse var this ky '=' vl
   if translate(keyword) = translate(ky) then do
      call stream settingsFile, 'c', 'close'
      return strip(vl)
   end
end
call stream settingsFile, 'c', 'close'
return ''

getQuery:
interpret 'return' keyword || '(' || command || ')'
return ''

getValue:
response = getSetting(keyword)
if response \= '' then do
   interpret 'r=' response
   return r
end
response = QuerySettings(keyword, 'DefaultValue')
if response = 'syntax error' then do
   return ''
end
interpret 'r=' response
return r

getPrompt:

cr = d2c(13)
instructions = QuerySettings(keyword, 'Instructions')
if instructions = '' | instructions = 'syntax error' then do
   Instructions = "Description not available"
end
response = getSetting(keyword)
if response \= '' & response <> 'syntax error' then do
   interpret 'r=' response
end
else do
   response = QuerySettings(keyword, 'DefaultValue')
   if response = 'syntax error' then do
      response = "''"
   end
   interpret 'r=' response
end
return "Setting Name:" keyword || cr ||,
       "Value:" r || cr || cr ||,
       Instructions


makeBody:

cr = d2c(13)
bi = QuerySettings(keyword, 'Instructions')
bc = CurrentSetting(keyword)
if pos("'", bc) = 0 then do
   bc = "'"bc"'"
end
abv = "bv =" bc
interpret abv
body = "Variable Name:" keyword || cr ||,
       "Current Value:" bv || cr ||,
       "Current Setting:" CurrentSetting(keyword) || cr || cr ||,
       instructions
return body

CurrentSetting:

keyword = arg(1)

bc = getSetting(keyword)
if bc = '' then do
   bc = QuerySettings(keyword, 'Value')
end

if right(bc, 1) = "'" & left(bc, 1) = "'" then do
   bc = strip(bc, 'b', "'")
end

return bc

/* begin indivdual keyword functions here */

appsDir:
defaultValue = "FindBootDrive() || ':\bin'"
instructions = "Suntan Special installs applications to an applications directory.",
               "Each application is installed in a subdirectory of the applications",
               "directory. In most cases, the applications directory must support",
               "long names. Enter the name of the applications directory."
if command = 'Query' then do
   tappsdir = query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
   return strip(tappsdir, 't', '\')
end
return value(command)

sourceDir:
defaultValue = "Directory('..\setup')"
Instructions = 'Suntan Special installs applications from a number of source',
               'directories. These directories are examined in the order listed',
               'for the requested application.'
if command = 'Query' then do
   return editpath(dialogName, CurrentSetting(keyword), "Variable Name:" keyword || d2c(13) || d2c(13) || Instructions)
end
return value(command)

utilDir:
defaultValue = "cdglobal('appsDir') || '\utils'"
Instructions = 'Suntan Special creates one directory to hold all the extra command',
               'line utilities that it installs. Enter a value if you wish to override',
               'the default setting.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

username:
defaultValue = "'userid'"
Instructions = 'Suntan Special will create an automatic login object.',
               'Enter the username for the login object. If you do not',
               'use the File and Print Client or LAN Server, then this',
               'entry must be blank.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

password:
defaultValue = "'password'"
Instructions = 'Suntan Special will create an automatic login object.',
               'Enter the password for the login object. If you do not',
               'use the File and Print Client or LAN Server, then this',
               'entry must be blank.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

domain:
defaultValue = "'ibmpeer'"
Instructions = 'Suntan Special will create an automatic login object.',
               'Enter the domain name for the login object. If this',
               'computer is not part of a domain, then this entry must',
               'be blank.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

tempDir:
defaultValue = "FindBootDrive() || ':\temp'"
Instructions = 'Suntan Special will create and use a temporary directory. The',
               'temporary directory will be used for installers that need space',
               'that is used only during the install. In most cases, the',
               'temporary directory must support',
               'long names. The TEMP and TMP environment',
               'variables will be updated to the temporary directory.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

downloadDir:
defaultValue = "cdglobal('tempDir')"
Instructions = 'The download directory is the default location for files copied',
               'from the Internet. Suntan Special will create the download directory',
               'and set up Netscape preferences to use the download directory.',
               'Enter the download directory.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

bookmarkFile:
defaultValue = "''"
Instructions = 'Suntan Special will place a default bookmark file into every',
               'Netscape, Mozilla and Firefox profile. Enter the name of the bookmark file.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

hostsFile:
defaultValue = "''"
Instructions = 'Suntan Special will copy this hosts file into the %etc% directory.',
               'The hosts file is part of TCP/IP which allows the computer to',
               'locate other computers without looking them up on the name server.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

resolvFile:
defaultValue = "''"
Instructions = 'Suntan Special will copy this resolv file into the %etc% directory.',
               'The resolv file is part of TCP/IP which specifies the name servers.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

passwdFile:
defaultValue = "''"
Instructions = 'Suntan Special will copy this tcp/ip password file into the %etc% directory.',
               'The tcp/ip password file is part of TCP/IP which specifies account',
               'information for all users.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

backupDir:
defaultValue = "FindBootDrive() || ':\Backup'"
Instructions = 'Suntan Special will install any needed operating system fixes. The',
               'fix process requires a backup and an archive directory to store',
               'the files replaced in the fix process.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

archiveDir:
defaultValue = "FindBootDrive() || ':\Archive'"
Instructions = 'Suntan Special will install any needed operating system fixes. The',
               'fix process requires a backup and an archive directory to store',
               'the files replaced in the fix process.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

polarbarMailDir:
defaultValue = "''"
Instructions = 'Suntan Special will install an icon to launch the Polarbar mailer.',
               'If you have a current Polarbar installation, enter the location here',
               'and Suntan Special will create an icon to launch it.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

mozillaHome:
defaultValue = "''"
Instructions = 'Suntan Special will install the Mozilla family of web browsers.',
               'It is best to store the profile away from the code, to facilitate',
               'a smooth upgrade from version to version of Warpzilla. Enter',
               'the directory to be used to store those profiles.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

mozillaPluginDir:
defaultValue = "''"
Instructions = 'Suntan Special will install the Mozilla family of web browsers.',
               'To specify a common directory to use for plugins fill in a value',
               'for the mozilla plugin directory. This directory will be shared.',
               'by each browser.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

sddKeyName:
defaultValue = "''"
Instructions = 'Suntan Special will install SciTech Display Doctor Pro.',
               'If you are a registered user, Suntan Special will enter your',
               'registration automatically. The registration information consists of',
               'a key name and a key code. The key name is typically your name,',
               'and the key code is typically a large hexadecimal number.',
               'Enter the Display Doctor key name.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)


sddKeyCode:
defaultValue = "''"
Instructions = 'Suntan Special will install SciTech Display Doctor Pro.',
               'If you are a registered user, Suntan Special will enter your',
               'registration automatically. The registration information consists of',
               'a key name and a key code. The key name is typically your name,',
               'and the key code is typically a large hexadecimal number.',
               'Enter the Display Doctor key code.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

snapKeyName:
defaultValue = "''"
Instructions = 'Suntan Special will install SciTech SNAP Graphics.',
               'If you are a registered user, enter the SNAP key name,',
               'and Suntan Special will register SNAP Graphics',
               'automatically.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)


snapKeyCode:
defaultValue = "''"
Instructions = 'Suntan Special will install SciTech SNAP Graphics.',
               'If you are a registered user, enter the SNAP key code,',
               'and Suntan Special will register SNAP Graphics',
               'automatically.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

ijfireKey:
defaultValue = "''"
Instructions = 'Suntan Special will install InJoy Firewall.',
               'If you are a registered user, Suntan Special will enter your',
               'registration automatically. Enter the name of a file containing',
               'your registration information.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

rsjKeyFile:
defaultValue = "''"
Instructions = 'Suntan Special will install RSJ CD-Writer.',
               'If you have a RSJ license key, which is usually a file',
               'named "CDWFS.KEY". Enter the name of the license key file.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

rsjKey2File:
defaultValue = "''"
Instructions = 'Suntan Special will install RSJ CD-Writer.',
               'If you are upgrading RSJ, you need to have',
               'the key for the prior version of RSJ, license',
               'key, which is usually a file named "CDWFS.KEY".',
               'Enter the name of the prior version license key file.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

rsjCDString:
defaultValue = "''"
Instructions = 'Suntan Special will install RSJ CD-Writer.',
               'If you have a special CD-RW setup string to add to the cddrv.inf',
               'file, Suntan Special will add it automatically. Enter the',
               'CD-ROM setup string.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)


pauseTime:
defaultValue = "60"
Instructions = 'Suntan Special sequences are written with pause commands',
               'after reboot commands. Set pauseTime to the number of seconds',
               'Suntan Special is to wait using the pause command.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

turboMode:
defaultValue = "0"
Instructions = 'Suntan Special will reboot the computer as many times as',
               'needed to install all the software specified. Set turboMode to',
               'to 0 to make Suntan Special to display a message before',
               'rebooting the computer.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

adminUser:
defaultValue = "''"
Instructions = 'Suntan Special will install DB2 and WebSphere. To do so, an account',
               'needs to be set up for the database administrator. Enter the user ID',
               'to be used for the System Administrator'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

adminPassword:
defaultValue = "''"
Instructions = 'Suntan Special will install DB2 and WebSphere. To do so, an account',
               'needs to be set up for the database administrator. Enter the password',
               'to be used for the System Administrator'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

db2SystemName:
defaultValue = "''"
Instructions = 'Suntan Special will install DB2. To do so, the database system name',
               'needs to be assigned. Enter the DB2 system name.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

osVersion: /* should be a choice */
defaultValue = "''"
detos = value('osdir',,'os2environment')
if detos = '' then detos = FindBootDrive() || ':\OS2'
Instructions = 'Suntan Special needs to know base directory the OS version for the system being',
               'configured. Normally this is automatically detected. Enter a value',
               'to override the manual detection. The automatically detected version is "' || detos || '".'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

AudioDriver: /* should be a choice */
defaultValue = "''"
Instructions = 'Suntan Special can install the Audio Driver. Enter the name of',
               'an audio driver to be installed.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

PrinterDriver: /* should be a choice */
defaultValue = "''"
Instructions = 'Suntan Special can install the Printer Driver. Enter the name of',
               'a printer driver to be installed.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

VideoDriver: /* should be a choice */
defaultValue = "''"
Instructions = 'Suntan Special can install the Video Driver. Enter the name of',
               'a video driver to be installed.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

MouseDriver: /* should be a choice */
defaultValue = "''"
Instructions = 'Suntan Special can install the Mouse Driver. Enter the name of',
               'a mouse driver to be installed.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

NetworkDriver: /* should be a choice */
defaultValue = "''"
Instructions = 'Suntan Special can install the Network Driver. Enter the name of',
               'a network driver to be installed.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

cdLetter:
defaultValue = "''"
Instructions = 'Suntan Special needs to access a CD-ROM drive. If you need to',
               'force Suntan Special to use a particular CD-ROM, enter',
               'the drive letter to use with that CD-ROM. Leave this entry blank',
               'to let Suntan Special choose the CD-ROM drive letter.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

useRSJ:
defaultValue = "''"
Instructions = 'Suntan Special can use RSJ CD-Writer to access the CD-ROM drive.',
               'If you are using RSJ CD-Writer to access the CD-ROM, enter',
               'the drive letter to use with RSJ CD-Writer. Leave this entry blank',
               'if you do not use RSJ.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

phoneUser:
defaultValue = "'suntan-user'"
Instructions = 'You can query the Suntan Special Server for updates to software',
               'and applications. This setting represents the username this version',
               'of Suntan Special uses to authenticate with the server.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

phonePassword:
defaultValue = "'OS2Expert'"
Instructions = 'You can query the Suntan Special Server for updates to software',
               'and applications. This setting represents the password this version',
               'of Suntan Special uses to authenticate with the server.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

phoneHomeURL:
defaultValue = "'ftp://ftp.blondeguy.com/SuntanV6/update.zip'"
Instructions = 'You can query the Suntan Special Server for updates to software',
               'and applications. This setting names one of the files this version',
               'of Suntan Special retrieves from the server.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

setupDir:
defaultValue = "cdglobal('appsDir') || '\Suntan\Setup'"
Instructions = 'Suntan Special maintains a software repository of the setup',
               'programs of applications that it can install. In most cases,',
               'the setup directory must support long names. The setup',
               'directory is where applications are copied from the Suntan',
               'Special CD-ROM during installation. If the SaveWebApps setting',
               'is set, Suntan Special saves applications that it retrieves',
               'from the server in the setup directory.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

java2Home:
defaultValue = "''"
Instructions = 'OS/2 Kit for Java mimics the IBM Java implementations',
               'for OS/2 and defaults the user.home system property',
               'to the Java home (java.home) directory. If you want to',
               'override this setting, enter your value here.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

helpFolder:
defaultValue = "'<WP_ASSISTANCE>'"
Instructions = 'Suntan Special will copy help files to a common help',
               'folder. Enter the Object ID of the help folder.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

Flash5Key:
defaultValue = "''"
Instructions = 'Flash 5 requires a key to confirm registration.',
               'Without this key, Flash 5 will put up a nag screen',
               'every so often.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

hostname:
defaultValue = "''"
Instructions = 'Specify the hostname of this computer. Hostname is used',
               'by the WebSphere scripts to control urls for testing and',
               'configuration.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

batchMode:
defaultValue = "'Normal'"
Instructions = 'When a sequence is executed in Suntan Special, each application',
               'listed is installed, one after another. Specify "Normal" to keep',
               'this behavior, and "SingleStep" to put up a dialog before each',
               'application.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), 'Normal', 'SingleStep')
end
return value(command)

gamesFolderName:
defaultValue = "'Games'"
Instructions = 'When Suntan Special installs an application that is a game, it',
               'moves the program object or folder to the games folder.',
               'Specify the name of the games folder to be used for this',
               ' purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

gamesFolderParent:
defaultValue = "'<WP_PROGRAMSFOLDER>'"
Instructions = 'When Suntan Special installs an application that is a game, it',
               'moves the program object or folder to the games folder.',
               'Specify the parent ID of the games folder to be used for',
               'this purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

gamesFolderID:
defaultValue = "'<WP_GAMES>'"
Instructions = 'When Suntan Special installs an application that is a game, it',
               'moves the program object or folder to the games folder.',
               'Specify the object ID of the games folder to be used for',
               'this purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

ProgramFolderName:
defaultValue = "'Programs'"
Instructions = 'When Suntan Special installs an application, it',
               'moves the Programs object or folder to a global Programs folder.',
               'Specify the name of the global Programs folder to be used for this',
               ' purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

ProgramFolderParent:
defaultValue = "'<WP_DESKTOP>'"
Instructions = 'When Suntan Special installs an application, it',
               'moves the program object or folder to a global Programs folder.',
               'Specify the parent ID of the global Programs folder to be used for',
               'this purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

ProgramFolderID:
defaultValue = "'<WP_PROGRAMSFOLDER>'"
Instructions = 'When Suntan Special installs an application, it',
               'moves the program object or folder to a global Programs folder.',
               'Specify the object ID of the global Programs folder to be used for',
               'this purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

OpenOfficeKey:
defaultValue = "''"
Instructions = 'When Suntan Special installs OpenOffice.org version 1.x,',
               'it can display a text file with the license key obtained',
               'from the vendor. Enter the name of the text file containing',
               'the license key.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

PMViewKey:
defaultValue = "''"
Instructions = 'When Suntan Special installs PMView, it can display a',
               'text file with the license key obtained from the vendor. Enter',
               'the name of the text file with this information.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

ftpdrc:
defaultValue = "''"
Instructions = 'When Suntan Special installs Peter Moylan''s ftpserver, it can',
               'copy the configuration file, ftpdrc, to the product directory.',
               'To keep the default configuration of ftpserver, leave this entry',
               'blank. Enter the name of your ftpdrc file.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

dhcpnetname:
defaultValue = "'blondenet'"
Instructions = 'DHCP server configuration requires a network name. Enter',
               'the network name for your network. This name will be used',
               'only for DHCP services.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

dhcpsubnet:
defaultValue = "'192.168.0.0'"
Instructions = 'DHCP server configuration requires a subnet. Enter the subnet,',
               'ending with .0, for the subnet for your network. Together',
               'with a subnet mask, this will determine your subnet.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

dhcpsubnetmask:
keytemp = keyword
defaultValue = "'255.255.255.0'"
Instructions = 'DHCP server configuration requires a subnet mask. Enter the subnet,',
               'mask, for the subnet for your network. Together',
               'with a subnet (currently' QuerySettings('dhcpsubnet', 'Value') || '),',
               'this will determine your subnet.'
keyword = keytemp
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

dhcprangelow:
defaultValue = "'192.168.0.65'"
keytemp2 = keyword
Instructions = 'DHCP server configuration requires a range of ip addresses to give.',
               'to clients. The range should be inside your subnet. The current',
               'subnet is' QuerySettings('dhcpsubnet', 'Value') 'and the current',
               'subnet mask is' QuerySettings('dhcpsubnetmask', 'Value') || '.',
               'Enter the start of the range for your subnet.'
keyword = keytemp2
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

dhcprangehigh:
defaultValue = "'192.168.0.254'"
keytemp3 = keyword
Instructions = 'DHCP server configuration requires a range of ip addresses to give.',
               'to clients. The range should be inside your subnet. The current',
               'subnet is' QuerySettings('dhcpsubnet', 'Value') 'and the current',
               'subnet mask is' QuerySettings('dhcpsubnetmask', 'Value') || '.',
               'The start of the range is' QuerySettings('dhcprangelow', 'Value') || '.',
               'Enter the end of the range for your subnet.'
keyword = keytemp3
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

injoydialerkey:
defaultValue = "''"
Instructions = 'Enter the location of the key file for Injoy Dialer',
               'version 1.4. This software is protected by a key',
               '(without the key it works for 30 days).'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

gcjavalicense:
defaultValue = "''"
Instructions = 'Enter the location of the key file for Golden Code',
               'Java version 1.4.1. This license file is obtained from',
               'Golden Code Development. Installation of Golden Code Java',
               'will not proceed without this key.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

marscfg:
defaultValue = "''"
Instructions = 'Enter the location of the configration file for mars.',
               'The configuration file has your name and key in it, as',
               'modified according to e-mail from SNoA. You may take the',
               'mars.cfg file from a previous installation of mars.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

ndfskey:
defaultValue = "''"
Instructions = 'Enter the location of the file containing the NetDrive',
               '3.x license information, which should have come by e-mail.',
               'When installing NetDrive, Suntan Special will display this',
               'file so you may copy the information to the registration',
               'application.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

vpckey:
defaultValue = "''"
Instructions = 'Enter the location of the file containing the Connectix',
               'VPC license information, which should have come with the',
               'product. When installing VPC, Suntan Special will display this',
               'file so you may copy the information to the registration',
               'application.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

vslickkey:
defaultValue = "''"
Instructions = 'Enter the location of the file containing the Visual',
               'Slickedit license information, which should have come',
               'with the product. When installing Visual Slickedit,',
               'Suntan Special will display this file.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

weaselcfg:
defaultValue = "''"
Instructions = 'Enter the location of the Weasel ini file. If you have a previous',
               'Weasel installation to migrate to this computer, Suntan Special will',
               'copy the weasel.ini file from the old installation.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

normanKey:
defaultValue = "''"
Instructions = 'Enter the keycode for Norman Virus Control. Norman will send a',
               'keycode with each registered copy of NVC, Suntan Special will',
               'prompt with this keycode when the Norman installer asks for it.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

ba2000key:
defaultValue = "''"
Instructions = 'Enter the location of the file containing the Back Again/2000',
               'license information, which should have come with the',
               'product. Suntan Special will display this',
               'file so you may copy the information to the registration',
               'screen.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

blondeDir:
defaultValue = "''"
Instructions = 'This is the root directory for the web server. Enter this',
               'directory to hold the files needed to test the WebSphere',
               'installation. This can also be the root of your website.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

blondeDir2:
defaultValue = "''"
Instructions = 'This is the auxilery root directory for the web server. Enter this',
               'directory to hold the root of a website that is under construction.',
               'The url of this directory will be your servername/new.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

nosaRootDir:
defaultValue = "''"
Instructions = 'The Netlabs Open Source Archive client needs a root directory',
               'to store its files. This is likely to be your personal coding',
               'directory.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

cvsHomeDir:
defaultValue = "''"
Instructions = 'CVS (Concurrent Versioning System) needs a home directory to',
               'store its files. This is likely to be off your personal coding',
               'directory.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

Mesa2Key:
defaultValue = "''"
Instructions = 'Mesa2 requires a license key. Enter the name of the license',
               'key file.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end

return value(command)

FC2Key:
defaultValue = "''"
Instructions = 'File Commander/2 requires a license key. Enter the name',
               'of the license key file.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

DFSeeKey:
defaultValue = "''"
Instructions = 'DFSee requires a license key file. Enter the name',
               'of the license key file. Leave they key filename blank',
               'to run DFSee unlicensed.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)

devFolderName:
defaultValue = "'Development'"
Instructions = 'When Suntan Special installs a development application, it',
               'moves the program object or folder to a global Development folder.',
               'Specify the name of the global Development folder to be used for this',
               ' purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

devFolderParent:
defaultValue = "'<WP_PROGRAMSFOLDER>'"
Instructions = 'When Suntan Special installs a development application, it',
               'moves the program object or folder to a global Development folder.',
               'Specify the Parent ID of the global Development folder to be used for this',
               ' purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

devFolderID:
defaultValue = "'<WP_DEVFLDR>'"
Instructions = 'When Suntan Special installs a development application, it',
               'moves the program object or folder to a global Development folder.',
               'Specify the Object ID of the global Development folder to be used for this',
               ' purpose.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

showWebApps:
defaultValue = '1'
Instructions = 'Suntan Special will show the availablity of applications',
               'to be installed from the Web. Set showWebApps to',
               '1 (one) to make Suntan Special show web',
               'applications.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

showLocalApps:
defaultValue = '1'
Instructions = 'Suntan Special will show the availablity of applications',
               'to be installed from the Local System. Set showLocalApps to',
               '1 (one) to make Suntan Special show locally stored',
               'applications.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

saveWebApps:
defaultValue = '0'
Instructions = 'Suntan Special will save applications that it downloads',
               'to the setup directory if saveWebApps is set to 1. Set',
               'saveWebApps to 0 (zero) to make Suntan Special delete',
               'any downloaded applications after installation is complete.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

OpenOfficeUser:
defaultValue = "Default"
Instructions = 'OpenOffice.org 2.0 requires a user name to be set by default.',
               'This default user name will be stored in the USER environment',
               'variable.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)

AutoCheckUpdates:
defaultValue = '0'
Instructions = 'Suntan Special will check for updates by contacting the Blonde Guy',
               'website at program startup. Set to 0 to disable the check.',
               'If the check is disabled, Suntan Special will check for updates',
               'only when the Refresh button.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

showNotInstalled:
defaultValue = '1'
Instructions = 'Suntan Special will show applications available for download',
               'which have not yet been installed. Set to 0 to hide.',
               'such applications, and show only updates to applications that',
               'have already been installed.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

showUpdateAvailable:
defaultValue = '1'
Instructions = 'Suntan Special will show applications for which an update',
               'that is newer than the one currently installed. Set to 0 to hide.',
               'such applications, and show only applications that',
               'have not been installed, or that are up to date.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

showUptoDate:
defaultValue = '1'
Instructions = 'Suntan Special will show installed applications that are up',
               'to date, and have no newer version available. Set to 0 to hide.',
               'applications that are up to date, and show only applications that',
               'have not been installed, or that have an available update.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

ShowSuccessDialog:
defaultValue = '1'
Instructions = 'Suntan Special will show a dialog for 10 seconds after the',
               'successful installation of any application. Set to 0 to disable',
               'showing the dialog, or to 1 to enable showing the dialog.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

UnixRoot:
defaultValue = "FindBootDrive() || ':'"
Instructions = 'This is the directory to be used as the root of the',
               'Filesystem Hierarchy Standard (FHS). This is required to be',
               'just the drive letter followed by a colon (such as C:) and',
               'this designates the root of the drive will be used as the',
               'FHS root.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)

userPPDDir:
defaultValue = ''
Instructions = 'This is the directory to be used to hold all the user',
               'Printer Definition Files (PPD). These are used by the psprint',
               'installation to install psprint postscript driver with the user',
               'printers included.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)


DropboxClientKey:
defaultValue = ''
Instructions = 'When Suntan Special installs the Dropbox plugin, it can display a',
               'text file with the license key obtained from the vendor. Enter',
               'the name of the text file with this information.'
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "File")
end
return value(command)


PMMailAccounts:
defaultValue = "cdglobal('appsDir') || '\PMMail\Accounts'"
Instructions = "PMMail/2 uses an accounts directory to hold its data.",
               "The accounts directory is located under the PMMail",
               "directory unless the user specifies otherwise. If a",
               "separate accounts directory is to be used, enter",
               "the location here. The spell check dictionaries",
               "will be stored under the accounts directory.",
               "Leave the entry blank to use the default location."
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Directory")
end
return value(command)


ArcaNoaeSoftwareChoice:
defaultValue = "''"
Instructions = "This parameter sets the default drivers to install",
               "from the set produced by Arca Noae. An empty string",
               "tells the install program to prompt the user. The string",
               "contains the keyword for each driver separated by spaces."
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)


UniaudAdapter:
defaultValue = "''"
Instructions = "When Uniaud is found in Config.Sys, the Adapter number",
               "tells the driver which audio hardware to use. If the system",
               "has only one audio adapter, leave this blank. Typical systems",
               "with two adapters may benefit from a value of 1."
if command = 'Query' then do
   return query(dialogName, CurrentSetting(keyword), makeBody(), "Text")
end
return value(command)


ftpdstartup:
defaultValue = '1'
Instructions = 'When installing FTP Server, set to 1 to create an object',
               'in the Startup Folder so FTP Server will be started at',
               'system startup time.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)


yumignorerpmdb:
defaultValue = '0'
Instructions = 'When yum is used to install applications and libraries,',
               'sometimes an error in rpmdb is reported. Set to 1 to ignore',
               'this error or set to 0 to display the error screen and wait.'
if command = 'Query' then do
   return choice(dialogName, makeBody(), CurrentSetting(keyword), '0', '1')
end
return value(command)

