/* install GCC 4 runtime libraries needed for all Qt 4 installations. 
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command installs GCC 4 runtime libraries needed for all Qt 4
 *   installations. On OS/2 the libraries are installed to OS2\DLL, while
 *   on eCS, the libraries are installed to eCS\DLL. On ArcaOS, the
 *   installation is skipped, as the libraries are installed and maintained
 *   by RPM/YUM.
 *
 *   The installation is unattended.
 *
 * Copyright (C) 2018 Blonde Guy
 * All Rights Reserved
 */

productName = "GCC 4 Core"
productDate = '2015-12-07 19:46:26'
productCategory = 'Library'
productID = ''
fileURL = 'ftp://ftp.netlabs.org/pub/gcc/gcc4core-1_3_1.wpi;' ||,
          'ftp://ftp.netlabs.org/pub/gcc/libc-0_6_6-csd6.wpi'

parse arg appsDir
osdir = value('osdir',,'os2environment')
if osdir = '' then do
   osdir = FindBootDrive() || ':\OS2'
end
else if translate(substr(osdir, 3)) = 'SYS' then do
   call LogCdi productName "is not needed for ArcaOS"
   return 0
end
installDir = osdir || '\dll'
originalDir = Directory()
call LogCdi "Installing" productName "to" installDir

call LogCdi "Locating existing WarpIN installation"
wiloc = strip(SysIni("USER", "WarpIN", "Path"), 't', d2c(0))
if wiloc = 'ERROR:' then do
   call LogCdi "WarpIN was not found." productName "will not be installed."
   return 1
end


WarpINDist = 'libc-0_6_6-csd6.wpi'
zXCD = 'libc-0_6_6-csd6.xcd'

queue 'ReadConfigFile'
queue 'ReplaceLine filename= filename="' || originalDir || '\' || WarpINDist || '">'
queue 'ReplaceLine path="H:\ECS\DLL" path="' || installDir || '"'
queue 'WriteConfigFile'
queue 'exit'

wrc = DoWarpIN(zXCD)

if wrc <> 0 then do
   call LogCdi "KLIBC runtime installation did not complete."
   return 1
end

WarpINDist = 'gcc4core-1_3_1.wpi'
zXCD = 'gcc4core-1_3_1.xcd'

queue 'ReadConfigFile'
queue 'ReplaceLine filename= filename="' || originalDir || '\' || WarpINDist || '">'
queue 'ReplaceLine path="H:\ecs\dll" path="' || installDir || '"'
queue 'ReplaceLine path="H:\ecs\DOC\GCC4" path="' || osdir || '\DOC\GCC4"'
queue 'WriteConfigFile'
queue 'exit'

wrc = DoWarpIN(zXCD)

if wrc <> 0 then do
   call LogCdi "GCC 4 Core installation did not complete."
   return 1
end

call LogCdi "Operation Complete."
return 0
