/* reboot
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command reboots the computer. If the turbo mode is 0,
 *   message is displayed before rebooting. Both IBM boot manager
 *   and AiR-Boot are supported.
 *
 * Copyright (C) 2019 Blonde Guy
 * All Rights Reserved
 */

productName = 'System Reboot'
productDate = '2019-07-09 10:00:00'
productCategory = 'Operation'
turboMode = cdglobal('turboMode')

/* put up message dialog if not Turbo mode */
title = 'System Reboot'
cr = d2c(13)
if turboMode = 0 then do
   waitmode = 1
   message = title || cr || cr || cr || "The system will restart."
end
else do
   waitmode = 6
   message = title || cr || cr || cr || "The system will restart in 10 seconds."
end

message = message "After the system restarts, Suntan",
          "Special will continue. If the system does not reboot automatically,",
          "reboot the system manually, and Suntan Special will continue." || cr ||,
          cr || "Press OK to reboot the system."
call MessageDialog title, waitmode, message

call LogCdi "Rebooting at" date() time()
cdLetter = cdglobal('cdLetter')
if cdLetter = '' then do
   call ejectCD
end

/* check for AiR-Boot vs. IBM setboot */
setbootpgm = 'IBM'
address cmd '@setboot /q | rxqueue'
if rc <> 0 then do
   call LogCdi "Return code from setboot was" rc
   setbootpgm = 'None'
end
else do while queued() > 0
   parse pull lvmline
   if lvmline = 'Boot Manager is not installed.' then do
      setbootpgm = 'None'  /* was setbootpgm 'Wrong' */
   end
   if pos('AiR-BOOT', lvmline) <> 0 then do
      setbootpgm = 'AiR-BOOT'
   end
end

/* select boot program */
bootpgm = 'setboot'
select
   when setbootpgm = 'IBM Wrong' then do
      bootpgm = 'setaboot'
      call LogCdi "IBM setboot found, but AiR-Boot installed, using AiR-Boot."
   end
   when setbootpgm = 'AiR-BOOT Wrong' then do
      bootpgm = 'setiboot'
      call LogCdi "AiR-Boot setboot found, but IBM boot manager installed, using IBM."
   end
   when setbootpgm = 'None' then do
      call LogCDi "No boot manager found, using reboot.exe"
      address cmd '@reboot'
      call LogCdi "After reboot, using shutdown."
      call Shutdown
      return 0
   end
   otherwise do
      call LogCdi "using" setbootpgm
   end
end

/* reboot using lvm volume name if possible */
volName = ''
fspec = SysSearchPath('PATH', 'lvm.exe')
if fspec <> '' then do
   /* funky check for too old version of rexxutil */
   call SysFileTree FindBootDrive() || ':\os2\dll\rexxutil.dll', 'ud'
   parse var ud.1 umonth '/' uday '/' uyear urest
   if uyear < 50 then do

      /* rexxutil is new enough to have this function */
      ftime = SysGetFileDateTime(fspec)
      if left(ftime, 4) > 2000 then do
         address cmd '@' || fspec '/query:all | rxqueue'
         if rc <> 0 then do
            call LogCdi "Return code from" fspec "was" rc
         end
         
         do while queued() > 0
            parse pull lvmline
            if left(lvmline,2) = sysbootdrive() then do
               parse value lvmline with bootdrive 4 volname 24 voltype volstatus volfs volsize
            end
         end
      
         volName = strip(volName)
      
         if volName <> '' then do
            if bootpgm = 'AiR-Boot' then do
               volname = translate(volname)
            end
            if pos(' ', volname) > 0 then do
               call LogCdi "rebooting volume" FindBootDrive()
               address cmd '@' bootpgm '/ibd:' || FindBootDrive()
            end
            else do
               call LogCdi "rebooting volume named" volname
               address cmd '@' bootpgm '/iba:"' || volname || '"'
               if rc = 8 then do
                  call LogCdi "Boot Manager is not installed: rebooting current volume"
                  address cmd '@' bootpgm '/b'
               end
               if rc <> 0 then do
                  call LogCdi "Error" rc "rebooting from" volname
               end
            end
            call LogCdi "Using reboot.exe"
            address cmd '@reboot'
            call LogCdi "After reboot, using shutdown."
            call Shutdown
      
            return 0
         end
      end
   end
end

call LogCdi "Could not find boot volume name using LVM -- reboot using drive letter" FindBootDrive()
address cmd '@' bootpgm '/ibd:' || FindBootDrive()
if rc <> 0 then do
   call LogCdi "Error" rc "rebooting from" FindBootDrive()
end

call LogCdi "Using reboot.exe"
address cmd '@reboot'
call LogCdi "After reboot, using shutdown."
call Shutdown
return 1


Shutdown:

/*
call LogCdi "shutting down in 11 seconds..."
call SysSleep 1
address cmd '@sendmsg "Suntan Special Display Monitor" WM_COMMAND 0 0'
call SysSleep 10
*/

address cmd '@go -cp CAD_POP'
if rc = 1 then do
   address cmd '@go -k CAD_POP'
   if rc = 0 then do
      call LogCdi "Terminated CAD_POP automatically"
   end
   else do
      call LogCdi "Error" rc "terminating CAD_POP"
   end
end

ecsShut = FindBootDrive() || ':\ecs\bin\shutdown.exe'
if stream(ecsShut, 'c', 'query exists') <> '' then do
   call LogCdi "shut down using eCS command line"
   address cmd '@' || ecsShut 'R' || volName
   if rc <> 0 then do
      call LogCdi "Error" rc "shutting down (eCS)"
   end
end

call LogCdi "shut down using OS/2 command line"
call SysSleep 1
address cmd '@' || FindBootDrive() || ':\os2\install\shutdown'
if rc <> 0 then do
   call LogCdi "Error" rc "shutting down (OS/2)"
end

return
