/* killclkmgr.cmd -- send shutdown message to ClkMgr */
/*
   Version 1.1, 23-Oct-2002'
   Copyright (C) 2002, Pieter Bras.  All rights reserved.

  description:  sends kill signal to running ClkMgr.exe
     requires:  OS/2 RexxUtil.dll with semaphore functions

       author:  Pieter Bras
       e-mail:  pbras@pobox.com
*/
sem = '\SEM32\CLKMGR\CLKMGR.KILL'
hsem = ''				    /* initialized in case of error */

signal on halt
signal on novalue
signal on syntax

/* initialize OS/2 RexxUtil functions */
if LoadLib( 'RexxUtil', 'SysLoadFuncs') then
   call Fatal 'RexxUtil.dll not found'

if rxFuncQuery( 'SysCreateEventSem') <> 0 then do	/* if not available */
   call beep 1500, 250
   call Fatal 'Semaphore functions unavailable -- please update your version of REXX'
   end

hsem = SysCreateEventSem( sem)
if hsem = '' then
   call Fatal 'Unable to create semaphore' sem
rc = SysOpenEventSem( hsem)
if rc \= 0 then
   call Fatal 'SysOpenEventSem: rc =' rc
rc = SysPostEventSem( hsem)
/* error codes:    0  NO_ERROR
                 299  ERROR_ALREADY_POSTED */
if rc \= 0 & rc \= 299 then
   call Fatal 'SysPostEventSem: rc =' rc
say 'semaphore posted:' sem
rc = SysCloseEventSem( hsem)
exit 0

/* Conditionally load a DLL and register its functions.
   returns: 1 if error, 0 otherwise
*/
LoadLib: procedure
   parse arg lib, proc
   if RxFuncQuery( proc) <> 0 then do
      call RxFuncAdd proc, lib, proc
      str = 'call' proc
      signal on syntax name LoadLibFail
      interpret str
      end
   return 0
      
LoadLibFail:
   call RxFuncDrop proc
   return 1

/**********************************************************************/
/* and just in case... */

Fatal:
   if hsem \= '' then
      rc = SysCloseEventSem( hsem)
   say arg( 1)
   exit 1

halt:
   call Fatal 'Program halted by operator'

novalue:
   say 'Uninitialized variable on line:' sigl
   say sourceline( sigl)
   call Fatal

syntax:
   say 'Syntax error on line:' sigl
   say sourceline( sigl)
   call Fatal

/* <eof> */
