/*
From: John Allen <john.allen@ie.ibm.com>
Newsgroups: comp.os.os2.utilities
Subject: Re: Time system has been up?
Date: Tue, 01 Apr 1997 10:26:28 +0000
Organization: John Allen Computing Ltd.
Lines: 52
Message-ID: <3340E2D3.3844@ie.ibm.com>
References: <5grjn0$iji@news-central.tiac.net>
Reply-To: john.allen@ie.ibm.com
NNTP-Posting-Host: allenj2.hursley.ibm.com
Mime-Version: 1.0
Content-Type: text/plain; charset=us-ascii
Content-Transfer-Encoding: 7bit
X-Mailer: Mozilla 2.02E (OS/2; I)


Here's the code to do it. (Compiles find with VAC++ 3.0)
*/

#define INCL_BASE
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>

int main()
{
    ULONG   uptime;
    APIRET  rc;
    
	if ((rc = DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, &uptime, sizeof
uptime)) == NO_ERROR)
        {
        ULONG seconds = uptime / 1000;
        
        ULONG days = seconds / (60L * 60L * 24L);
        seconds -= days * 60L * 60L * 24L;
        
        ULONG hours = seconds / (60L * 60L);
        seconds -= hours * 60L * 60L;
        
        ULONG minutes = seconds / (60L);
        seconds -= minutes * 60L;

        if ((days == 0) && (hours == 0))
           printf("This system has been running %lu minutes, %lu seconds\n",
             minutes, seconds);
        else
          if (days == 0)
             printf("This system has been running %lu hours, %lu minutes, %lu seconds\n",
                 hours, minutes, seconds);
        else
        printf("This system has been running %lu days, %lu hours, %lu minutes, %lu seconds\n",
            days, hours, minutes, seconds);

        }
    else
        {
        printf("error: DosQuerySysinfo, rc = %i\n", rc);
        }
	
    return EXIT_SUCCESS;
}
