
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.43
 */


/*
 * File: uptime.c
 *
 * Class for Workplace Shell uptime monitor.
 *
 * Methods.
 *
 * This module contains the new and overridden class and instance methods,
 * and immediate support procedures; nothing else.
 *
 * Bob Eager   October 2004
 *
 */

#ifndef SOM_Module_uptime_Source
#define SOM_Module_uptime_Source
#endif
#define uptime_Class_Source

#pragma	strings(readonly)

#pragma	hdrfile "main.pch"		/* Precompile these headers only */
#define INCL_DOS
#define	INCL_DOSERRORS
#define	INCL_WIN
#include <os2.h>
#pragma	hdrstop

#pragma	alloc_text(a_init_seg, wpSetup)
#pragma	alloc_text(a_init_seg, yesno)

#include <time.h>

#include "uptime.ih"
   
#include "resource.h"
#include "dialog.h"
#include "key.h"
#include "helpdefs.h"
#include "common.h"

/* Definitions */

#define	HELP_LIBRARY_NAME		"UPTIME.HLP"

/* Forward references */

static	BOOL	yesno(PSZ);

/* Local storage */

static	char	classname[] = "uptime";	/* Used often, allocated once */



/***********************************************************************
*                                                                      *
*                  Class methods                                       *
*                                                                      *
***********************************************************************/

/*
 * clsQueryModuleHandle
 * --------------------
 *
 * New method.
 *
 * Returns a module handle to the DLL implementing the class.
 * The handle is cached locally to avoid repeated calls to the
 * system to get the same information.
 *
 */

SOM_Scope HMODULE  SOMLINK clsQueryModuleHandle(M_uptime *somSelf, 
                                                 Environment *ev)
{
	somId id;
	PSZ path;

	static HMODULE hmod = (HMODULE) NULLHANDLE;

	/* M_uptimeData *somThis = M_uptimeGetData(somSelf); */
	M_uptimeMethodDebug("M_uptime","clsQueryModuleHandle");

	if(hmod == (HMODULE) NULLHANDLE) {	/* First time through only */
		id = somIdFromString(classname);/* Allocate an ID for class */
		path = _somLocateClassFile(	/* Get path to the DLL */
				SOMClassMgrObject,
				id,
				uptime_MajorVersion,
				uptime_MinorVersion);

		/* Use the path to get the module handle */

		DosQueryModuleHandle(path, &hmod);

		SOMFree((VOID *) id);		/* Free the ID space */
	}

	return(hmod);
}


/*
 * wpclsQueryDefaulthelp
 * ---------------------
 *
 * Overridden method.
 *
 * Returns the help library name and default panel ID for General Help.
 *
 */


SOM_Scope BOOL  SOMLINK wpclsQueryDefaultHelp(M_uptime *somSelf, 
                                              PULONG pHelpPanelId, 
                                              PSZ pszHelpLibrary)
{
	/* M_uptimeData *somThis = M_uptimeGetData(somSelf); */
	M_uptimeMethodDebug("M_uptime","wpclsQueryDefaultHelp");

	*pHelpPanelId = HLP_GENERAL;
	strcpy(pszHelpLibrary, HELP_LIBRARY_NAME);

	return(TRUE);
}


/*
 * wpclsQueryDefaultView
 * ---------------------
 *
 * Overridden method.
 *
 * Returns the default view for new objects in the class. The default
 * view of an 'uptime' class object is OPEN_WATCH.
 *
 */

SOM_Scope ULONG  SOMLINK wpclsQueryDefaultView(M_uptime *somSelf)
{
	/* M_uptimeData *somThis = M_uptimeGetData(somSelf); */
	M_uptimeMethodDebug("M_uptime","wpclsQueryDefaultView");

	return(OPEN_WATCH);
}


/*
 * wpclsQueryIconData
 * ------------------
 *
 * Overridden method.
 *
 * Returns the size of an ICONINFO structure, and optionally an actual
 * ICONINFO structure containing the default class icon. This gives the
 * class a different default icon from the "FS in a red circle" one.
 *
 */

SOM_Scope ULONG  SOMLINK wpclsQueryIconData(M_uptime *somSelf, 
                                            PICONINFO pIconInfo)
{
	/* M_uptimeData *somThis = M_uptimeGetData(somSelf); */
	M_uptimeMethodDebug("M_uptime","wpclsQueryIconData");

	if(pIconInfo != (PICONINFO) NULL) {	/* Structure to be filled in */
		pIconInfo->fFormat = ICON_RESOURCE;
		pIconInfo->hmod = _clsQueryModuleHandle(
					somSelf,
					somGetGlobalEnvironment());
		pIconInfo->resid = ICN_MAIN;
	}

	return(sizeof(ICONINFO));
}


/*
 * wpclsQueryTitle
 * ---------------
 *
 * Overridden method.
 *
 * Returns a default title for instances of the class. If this were
 * not done, the default title would be that of the parent class.
 *
 */

SOM_Scope PSZ  SOMLINK wpclsQueryTitle(M_uptime *somSelf)
{
	/* M_uptimeData *somThis = M_uptimeGetData(somSelf); */
	M_uptimeMethodDebug("M_uptime","wpclsQueryTitle");

	return(classname);
}


/***********************************************************************
*                                                                      *
*                  Instance methods                                    *
*                                                                      *
***********************************************************************/

/*
 * wpAddOptionsPage
 * ---------------
 *
 * New instance method.
 *
 * Adds the Options page to the properties notebook.
 *
 */

SOM_Scope ULONG  SOMLINK wpAddOptionsPage(uptime *somSelf,  Environment *ev, 
                                          HWND hwndNoteBook)
{
	PAGEINFO pi;
	SOMClass *myclass = _somGetClass(somSelf);
	HMODULE hmod = _clsQueryModuleHandle(myclass, ev);

	/* uptimeData *somThis = uptimeGetData(somSelf); */
	uptimeMethodDebug("uptime","wpAddOptionsPage");

	/* Clear out the PAGEINFO structure, then fill in just the
	   fields that we actually need. */

	memset((PCH) &pi, 0, sizeof(PAGEINFO));
	pi.cb			= sizeof(PAGEINFO);
	pi.hwndPage		= NULLHANDLE;
	pi.pfnwp		= OptionsPageDlgProc;
	pi.resid		= hmod;
	pi.pCreateParams	= somSelf;
	pi.dlgid		= DLG_OPTIONS;
	pi.usPageStyleFlags	= BKA_MAJOR;
	pi.usPageInsertFlags	= BKA_FIRST;
	pi.pszName		= "~Options";
	pi.idDefaultHelpPanel	= HLP_OPTIONS;
	pi.pszHelpLibraryName	= HELP_LIBRARY_NAME;

	return(_wpInsertSettingsPage(somSelf, hwndNoteBook, &pi));
}


/*
 * wpSetup
 * -------
 *
 * Overridden parent instance method.
 *
 * Performs instance data initialisation on a newly created object,
 * using information from the setup string.
 *
 * If wpSetup returns FALSE, the creation of the object is terminated.
 *
 */

SOM_Scope BOOL  SOMLINK wpSetup(uptime *somSelf, PSZ pszSetupString)
{
	char temp[MAXTEMP+1];
	int m, n;
	ULONG templen;
	Environment *env = somGetGlobalEnvironment();

	/* uptimeData *somThis = uptimeGetData(somSelf); */
	uptimeMethodDebug("uptime","wpSetup");

	templen = MAXTEMP;		/* Must be set before calling scan */
	if(_wpScanSetupString(
			somSelf,
			pszSetupString,
			"REFRESH_INTERVAL",
			temp,
			&templen) != 0) {
		n = atoi(temp);
		if(n < MIN_REFRESH_INTERVAL) n = MIN_REFRESH_INTERVAL;
		if(n > MAX_REFRESH_INTERVAL) n = MAX_REFRESH_INTERVAL;
		__set_refreshinterval(somSelf, env, n);
	} else __set_refreshinterval(somSelf, env, DEFAULT_REFRESH_INTERVAL);

	templen = MAXTEMP;		/* Must be set before calling scan */
	if(_wpScanSetupString(
			somSelf,
			pszSetupString,
			"UPTIME_METHOD",
			temp,
			&templen) != 0) {
		n = strlen(temp);
		if(strnicmp(temp, "SWAPFILE", n) == 0) {
			m = DLG_METHOD_SWAPFILE;
		}
		if(strnicmp(temp, "TIMER", n) == 0) {
			m = DLG_METHOD_TIMER;
		}
		if(strnicmp(temp, "DRIVER", n) == 0) {
			m = DLG_METHOD_DRIVER;
		}
		__set_method(somSelf, env, m);
	} else __set_method(somSelf, env, DEFAULT_METHOD);

	/* Allow the parent class to scan for its own setup keywords */

	return (uptime_parent_WPAbstract_wpSetup(somSelf, pszSetupString));
}


/*
 * wpInitData
 * ----------
 *
 * Overridden parent instance method.
 *
 * Performs instance data initialisation when the object is awakened.
 *
 */

SOM_Scope void  SOMLINK wpInitData(uptime *somSelf)
{
	uptimeData *somThis = uptimeGetData(somSelf);
	uptimeMethodDebug("uptime","wpInitData");

	/* Let the parent class initialise its own data */

	uptime_parent_WPAbstract_wpInitData(somSelf);

	/* Initialise pointer to dialog info structure for Watch view,
	   to make sure that we don't attempt to free unallocated space;
	   also because we must not attempt to send messages to the
	   dialog procedure when it is not active. */

	_dlginfo = (ULONG) NULL;
}


/*
 * wpAddObjectWindowPage
 * ---------------------
 *
 * Overridden parent instance method.
 *
 * Returns SETTINGS_PAGE_REMOVED to remove the "Window" page from the
 * Properties notebook; this page is not needed for an object that never
 * really opens!
 *
 */

SOM_Scope ULONG  SOMLINK wpAddObjectWindowPage(uptime *somSelf, 
                                               HWND hwndNotebook)
{
	/* uptimeData *somThis = uptimeGetData(somSelf); */
	uptimeMethodDebug("uptime","wpAddObjectWindowPage");

	return(SETTINGS_PAGE_REMOVED);	/* Removes Window page from Properties */
}


/*
 * wpAddSettingsPages
 * ------------------
 *
 * Overridden instance method.
 *
 * The override is needed so that we can add new pages to the properties
 * notebook.
 *
 */

SOM_Scope BOOL  SOMLINK wpAddSettingsPages(uptime *somSelf, HWND hwndNotebook)
{
	Environment *ev = somGetGlobalEnvironment();
	int rc;

	/* uptimeData *somThis = uptimeGetData(somSelf); */
	uptimeMethodDebug("uptime","wpAddSettingsPages");

	/* Let the parent class add its own settings pages first */

	uptime_parent_WPAbstract_wpAddSettingsPages(somSelf, hwndNotebook);

	/* New pages are added at the start of the notebook, so our own
	   three will appear first. They are of course added in reverse
	   order of the way they need to appear */

	rc = _wpAddOptionsPage(somSelf, ev, hwndNotebook);
	if(rc == 0) return(0);
	/* More pages go in here */
	return(rc);
}


/*
 * wpMenuItemSelected
 * ------------------
 *
 * Overridden instance method.
 *
 * The override is needed so that we can handle our own added menu items.
 *
 */

SOM_Scope BOOL  SOMLINK wpMenuItemSelected(uptime *somSelf, HWND hwndFrame, 
                                           ULONG ulMenuId)
{
	Environment *env = somGetGlobalEnvironment();

	uptimeData *somThis = uptimeGetData(somSelf);
	uptimeMethodDebug("uptime","wpMenuItemSelected");

	switch(ulMenuId) {
		case IDM_ABOUT:
			return(ClientAbout(clsQueryModuleHandle(somSelf, env)));

		case IDM_WATCH:
			if(_wpViewObject(
				somSelf,
				NULLHANDLE,
				OPEN_WATCH,
				NULLHANDLE) == NULLHANDLE) return(FALSE);
			return(TRUE);

		case IDM_CLOSEVIEW:
			return(ClientCloseView(somThis, env));
	}

	/* Otherwise let the parent class handle its own menu items */

	return(uptime_parent_WPAbstract_wpMenuItemSelected(somSelf, 
                                                      hwndFrame, 
                                                      ulMenuId));
}


/*
 * wpMenuItemHelpSelected
 * ----------------------
 *
 * Overridden instance method.
 *
 * The override is needed so that we can provide help for our own added
 * menu items.
 *
 */

SOM_Scope BOOL  SOMLINK wpMenuItemHelpSelected(uptime *somSelf, 
                                               ULONG MenuId)
{
	uptimeData *somThis = uptimeGetData(somSelf);
	uptimeMethodDebug("uptime","wpMenuItemHelpSelected");

	switch(MenuId) {
		case IDM_ABOUT:
			return(_wpDisplayHelp(
				somSelf,
				HLP_ABOUT,
				HELP_LIBRARY_NAME));

		case IDM_CLOSEVIEW:
			return(_wpDisplayHelp(
				somSelf,
				HLP_CLOSEVIEW,
				HELP_LIBRARY_NAME));

		case IDM_WATCH:
			return(_wpDisplayHelp(
				somSelf,
				HLP_WATCH,
				HELP_LIBRARY_NAME));
	}

	/* Otherwise, let the parent class provide help for its own
	   menu items */

	return (uptime_parent_WPAbstract_wpMenuItemHelpSelected(somSelf, 
								MenuId));
}



/*
 * wpModifyMenu
 * ------------
 *
 * Overridden instance method.
 *
 * This method is overridden in order to modify the contents of the
 * pop-up menu.
 *
 */

SOM_Scope BOOL  SOMLINK wpModifyMenu(uptime *somSelf, HWND hwndMenu, 
                                     HWND hwndCnr, ULONG iPosition, 
                                     ULONG ulMenuType, ULONG ulView, 
                                     ULONG ulReserved)
{	BOOL rc;
	MENUITEM props;
	SOMClass *myclass = _somGetClass(somSelf);
	HMODULE hmod = _clsQueryModuleHandle(
				myclass,
				somGetGlobalEnvironment());

	/* uptimeData *somThis = uptimeGetData(somSelf); */
	uptimeMethodDebug("uptime","wpModifyMenu");

	/* Add the "Close view" and "About" items to the top level menu */

	rc = _wpInsertMenuItems(
		somSelf,
		hwndMenu,
		iPosition,
		hmod,
		ID_POPUPMENU1,
		WPMENUID_PRIMARY);
	if(rc == FALSE) return(rc);

	/* Add the "Watch" item to the "Open" menu */

	rc = _wpInsertMenuItems(
		somSelf,
		hwndMenu,
		iPosition,
		hmod,
		ID_POPUPMENU2,
		WPMENUID_OPEN);
	if(rc == FALSE) return(rc);

	/* Let the parent add its own menu items now */

	rc = uptime_parent_WPAbstract_wpModifyMenu(somSelf, hwndMenu, 
                                                hwndCnr, iPosition, 
                                                ulMenuType, ulView, 
                                                ulReserved);
	return(rc);
}



/*
 * wpSaveState
 * -----------
 *
 * Overridden instance method.
 *
 * This method is overridden in order to allow persistent data to be saved.
 *
 */

SOM_Scope BOOL  SOMLINK wpSaveState(uptime *somSelf)
{
	Environment *env = somGetGlobalEnvironment();
	ULONG value;

	uptimeData *somThis = uptimeGetData(somSelf);
	uptimeMethodDebug("uptime","wpSaveState");

	/* Save all of the integers */

	value = __get_refreshinterval(somSelf, env);
	_wpSaveLong(somSelf, classname, KEY_INTERVAL, value);
	value = __get_method(somSelf, env);
	_wpSaveLong(somSelf, classname, KEY_METHOD, value);

	/* Let the parent class save its state too */

	return(uptime_parent_WPAbstract_wpSaveState(somSelf));
}


/*
 * wpRestoreState
 * --------------
 *
 * Overridden instance method.
 *
 * This method is overridden in order to allow persistent data to be restored.
 *
 */

SOM_Scope BOOL  SOMLINK wpRestoreState(uptime *somSelf, ULONG ulReserved)
{
	Environment *env = somGetGlobalEnvironment();
	ULONG value;

	uptimeData *somThis = uptimeGetData(somSelf);
	uptimeMethodDebug("uptime","wpRestoreState");

	/* Restore all of the integers */

	_wpRestoreLong(somSelf, classname, KEY_INTERVAL, &value);
	__set_refreshinterval(somSelf, env, value);
	_wpRestoreLong(somSelf, classname, KEY_METHOD, &value);
	__set_method(somSelf, env, value);

	/* Let the parent class restore its state too */

	return(uptime_parent_WPAbstract_wpRestoreState(somSelf, ulReserved));
}


/*
 * wpOpen
 * ------
 *
 * Overridden instance method.
 *
 * This method is overridden in order to allow the object to open its
 * Watch view. This view uses a dummy, normally hidden window;
 * its real purpose is to start the main client loop.
 *
 */

SOM_Scope HWND  SOMLINK wpOpen(uptime *somSelf, HWND hwndCnr, ULONG ulView, 
                               ULONG param)
{
	uptimeData *somThis = uptimeGetData(somSelf);
	uptimeMethodDebug("uptime","wpOpen");

	/* Open a Watch view if requested */

	if(ulView == OPEN_WATCH) {
		SOMClass *myclass = _somGetClass(somSelf);
		Environment *env = somGetGlobalEnvironment();
		PCLIENTDATA cd;

		/* Build the data structure to send to the view window
		   procedure */

		cd = (PCLIENTDATA) _wpAllocMem(
					somSelf,
					sizeof(CLIENTDATA),
					NULL);

		cd->cb			= sizeof(CLIENTDATA);
		cd->so			= somSelf;
		cd->env			= env;
		cd->hmod		= _clsQueryModuleHandle(
						myclass,
						env);
		cd->hwnd		= (HWND) NULL;	/* Filled in by window */
		cd->ObjHandle		= _wpQueryHandle(somSelf);
		cd->refreshinterval	= __get_refreshinterval(somSelf, env);
		cd->method		= __get_method(somSelf, env);
		_dlginfo = (ULONG) cd;	/* Needed by "Refresh" menu item */

		return(Client(cd));
	}

	/* Otherwise let the parent deal with it */

	return(uptime_parent_WPAbstract_wpOpen(somSelf, hwndCnr, ulView, 
                                          param));
}
