/**************/
/*            */
/* bantest.c  */
/*            */
/**************/

#include <os2werr.h>
#include <stdio.h>
#include <string.h>
#include "bantest.h"
#include <lange.h>
#include <banners.h>

#define  CLIENT_CLASS "BANNER_CLIENT_CLASS"
#define  OSDIR_VAR_NAME "OSDIR"

HAB      hab;
BOOL     bWasReady;
LANGE    hLange=NULL;

void MorphToPM(void)
{
   PPIB pib;
   PTIB tib;

   DosGetInfoBlocks(&tib, &pib);

   // Change flag from VIO to PM:
   if (pib->pib_ultype==2) pib->pib_ultype = 3;
}

void translateMenu(HWND hwndMenu)
{
   USHORT count=(USHORT)WinSendMsg(hwndMenu, MM_QUERYITEMCOUNT, MPFROMLONG(0L), MPFROMLONG(0L));
   USHORT i;
   for (i=0; i<count; i++)
   {
      CHAR szInput[256]="";
      CHAR szOutput[256]="";
      SHORT id=(USHORT)WinSendMsg(hwndMenu, MM_ITEMIDFROMPOSITION, MPFROMSHORT(i), MPFROMLONG(0L));
      if (id!=MIT_ERROR)
      {
         MENUITEM mi;
         if (WinSendMsg(hwndMenu, MM_QUERYITEMTEXT, MPFROM2SHORT(id, 256), (MPARAM)szInput))   // Got text
            if (!LngGetString(hLange, szInput, szOutput, 256))
               WinSendMsg(hwndMenu, MM_SETITEMTEXT, MPFROM2SHORT(id, 256), (MPARAM)szOutput);
            if (WinSendMsg(hwndMenu, MM_QUERYITEM, MPFROM2SHORT(id, FALSE), (MPARAM)&mi)) // Got MENUITEM structure
               if (mi.hwndSubMenu)
                  translateMenu(mi.hwndSubMenu);
      }
   }
}

MRESULT EXPENTRY wpMyWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

int main(void)
{
   APIRET      rc = NO_ERROR;   /* Return code                     */

   MorphToPM();

   hab=WinInitialize(0);
   if (hab)
   {
      HMQ hmq = WinCreateMsgQueue(hab, 0);
      if (hmq)
      {
         CHAR szBuffer[CCHMAXPATH];
         PSZ  pszOSDirectory;

         if (DosScanEnv(OSDIR_VAR_NAME, &pszOSDirectory))
            pszOSDirectory=NULL;
         if (pszOSDirectory) // eComStation
         {
            strcpy(szBuffer, pszOSDirectory);
            strcat(szBuffer, "\\LANG\\bantest.nls");
         }
         if (LngOpenDialect(szBuffer, &hLange))
            LngOpenDialect("bantest.nls", &hLange);

         printf("hLange=\"%x\"\n", hLange);

         if (WinRegisterClass(hab, CLIENT_CLASS, wpMyWindowProc, CS_SIZEREDRAW, 2*sizeof(PVOID)))
         {
            HWND hwndClient;
            ULONG flCreateFlags=FCF_TITLEBAR|FCF_MENU|FCF_SYSMENU|FCF_MINMAX|FCF_SIZEBORDER|FCF_NOBYTEALIGN|FCF_TASKLIST|FCF_SCREENALIGN|FCF_SHELLPOSITION;
            HWND hwndMain;
            LngGetString(hLange, "Banner System Test", szBuffer, 255);
            hwndMain= WinCreateStdWindow(HWND_DESKTOP, WS_VISIBLE, &flCreateFlags, CLIENT_CLASS, szBuffer, WS_VISIBLE, 0, ID_MAIN, &hwndClient);
            if (hwndMain)
            {
               QMSG qmsg;
               translateMenu(WinWindowFromID(hwndMain, FID_MENU));
               WinSetActiveWindow(HWND_DESKTOP, hwndMain);
               while(WinGetMsg(hab, &qmsg, NULLHANDLE, 0, 0))
                  WinDispatchMsg(hab, &qmsg);
               WinDestroyWindow(hwndMain);
            }
            else
            {
               rc=-4;
               fprintf(stderr, "WinCreateStdWindow error!\n");
            }
         }
         else
         {
            rc=-3;
            fprintf(stderr, "WinRegisterClass error!\n");
         }
         WinDestroyMsgQueue(hmq);
      }
      else
      {
         rc=-2;
         fprintf(stderr, "WinCreateMsgQueue error!\n");
      }
      WinTerminate(hab);
   }
   else
   {
      rc=-1;
      fprintf(stderr, "WinInitialize error!\n");
   }
   return rc;
}

MRESULT EXPENTRY wpMyWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch(msg)
   {
      case WM_CREATE:
      {
         PBANNERDATA    pBannerData;
         ULONG ulBufSize;

         APIRET rc=DosAllocMem((PPVOID)&pBannerData, sizeof(BANNERDATA), PAG_READ|PAG_WRITE|PAG_COMMIT|OBJ_ANY);
         if (rc)
         {
            fprintf(stderr, "DosAllocMem() failed! rc=%d\n", rc);
            return (MRESULT)TRUE;
         }

         if (!WinSetWindowPtr(hwnd, 4, pBannerData))
         {
            fprintf(stderr, "WinSetWindowPtr() failed!\n");
            DosFreeMem(pBannerData);
            return (MRESULT)TRUE;
         }

         pBannerData->ulTimeout=1000;
         pBannerData->flFlags=BF_FRAME_SOLID|BF_CLOSEBUTTON|BF_IMAGE;
         pBannerData->ulBackgroundColor=CLR_RED;
         pBannerData->ulForegroundColor=CLR_BLUE;
         pBannerData->ulWidth=256;
         pBannerData->ulHeight=128;
         pBannerData->ulId=0;
         pBannerData->fsAlarmSound=WA_NOTE;
         LngGetString(hLange, "Test", pBannerData->szTitle, 63);
         LngGetString(hLange, "There was a young lady of Bute Who played on a silver-gilt flute; She played several jigs To her uncle's white pigs, That amusing young lady of Bute.",
                      pBannerData->szText, 255);
         pBannerData->szFontNameSize[0]='\0';   // Empty string
         bWasReady=bsIsReady();
         WinStartTimer(hab, hwnd, ID_TIMER, 200);
         return (MRESULT)FALSE;
      }

      case WM_TIMER:
         if (SHORT1FROMMP(mp1)==ID_TIMER)
         {
            BOOL bReady=bsIsReady();
            if (bReady==bWasReady)
               break;
            WinInvalidateRect(hwnd, NULL, FALSE);
            bWasReady=bReady;
         }
         break;

      case BWM_CLICKED:
      {
         DosBeep(1000, 100);
         return (MRESULT)FALSE;
      }

      case WM_PAINT:
      {
         RECTL rclPaint;
         HPS hps=WinBeginPaint(hwnd, NULLHANDLE, &rclPaint);
         if (hps)
         {
            LONG     hTotalDrawn;   // total characters drawn
            LONG     hDrawn;        // total characters drawn
            USHORT   cy;
            SHORT    vmargin;
            USHORT   aLines[64];
            USHORT   numLines=0;
            USHORT   lineHeight;
            USHORT   i;
            RECTL    rcl1;
            PSZ      pszText=bWasReady?"Banner System is enabled!"
                                      :"Banner System is disabled! Please, enable Banner System.";
            CHAR     szBuffer[256];
            LONG     hText;
            RECTL    rclWindow;

            LngGetString(hLange, pszText, szBuffer, 256);

            hText =  strlen(szBuffer);

            WinFillRect(hps, &rclPaint, CLR_BACKGROUND);

            WinQueryWindowRect(hwnd, &rclWindow);

            GpiSetColor(hps, bWasReady?CLR_GREEN:CLR_RED);

            // Calculate text height
            for (lineHeight=0, numLines=0, cy = 0, hTotalDrawn = 0;  hTotalDrawn <  hText; numLines++)
            {  // draw the text
               rcl1.xLeft=rclWindow.xLeft;
               rcl1.yBottom=rclWindow.yBottom;
               rcl1.xRight=rclWindow.xRight;
               rcl1.yTop=rclWindow.yTop;

               aLines[numLines]=hTotalDrawn;

               hDrawn = WinDrawText(hps,                       // presentation-space handle
                                    hText - hTotalDrawn,       // length of text to draw
                                    szBuffer + hTotalDrawn,     // address of the text
                                    &rcl1,                     // rectangle to draw in
                                    0L,                        // foreground color
                                    0L,                        // background color
                                    DT_WORDBREAK | DT_TOP | DT_CENTER | DT_QUERYEXTENT);

               if (hDrawn)
                  hTotalDrawn += hDrawn;
               else
                  break;                      // text could not be drawn

               if (lineHeight==0)
                  lineHeight=(rcl1.yTop-rcl1.yBottom);
               cy+=lineHeight;
            }

            vmargin=(rclWindow.yTop-rclWindow.yBottom-cy);
            vmargin=vmargin<0?0:vmargin/2;

            rcl1.xLeft=rclWindow.xLeft;
            rcl1.yBottom=rclWindow.yBottom+vmargin;
            rcl1.xRight=rclWindow.xRight;
            rcl1.yTop=rclWindow.yTop-vmargin;

            for (i=0; i<numLines; i++)
            {
               hDrawn = WinDrawText(hps,                   // presentation-space handle
                                    hText - aLines[i],     // length of text to draw
                                    szBuffer + aLines[i],   // address of the text
                                    &rcl1,                 // rectangle to draw in
                                    0L,                    // foreground color
                                    0L,                    // background color
                                    DT_WORDBREAK | DT_TOP | DT_CENTER | DT_TEXTATTRS);
               rcl1.yTop-=lineHeight;
            }

            WinEndPaint(hps);
         }
         break;
      }

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
         {
            case IDM_COMMAND_EXIT:
               WinSendMsg(hwnd, WM_CLOSE, MPFROMLONG(0L), MPFROMLONG(0L));
               break;

            case IDM_COMMAND_ADD:
            {
               PBANNERDATA pBannerData=WinQueryWindowPtr(hwnd, 4L);
               WinDlgBox(HWND_DESKTOP, hwnd, BannerDlgProc, NULLHANDLE, IDD_BANNER, pBannerData);
               break;
            }

            case IDM_ABOUT:
               WinDlgBox(HWND_DESKTOP, hwnd, AboutDlgProc, NULLHANDLE, IDD_ABOUT, NULL);
               break;
         }
         break;

      case WM_INITMENU: // Disable commands, if Banner System is not ready
         if (SHORT1FROMMP(mp1)==IDM_COMMAND)
            WinEnableMenuItem((HWND)mp2, IDM_COMMAND_ADD, bWasReady);
         break;

      case WM_SAVEAPPLICATION:
      {
         break;
      }

      case WM_CLOSE:
      {
         CHAR szTitle[256], szText[256];
         LngGetString(hLange, "Quit application", szTitle, 255);
         LngGetString(hLange, "Are you sure?", szText, 255);
         if (WinMessageBox(HWND_DESKTOP, hwnd, szText, szTitle, 0L, MB_OKCANCEL|MB_QUERY)==MBID_CANCEL)
            return (MRESULT)0;
         break;
      }

      case WM_DESTROY:
      {
         PBANNERDATA    pBannerData=WinQueryWindowPtr(hwnd, 4L);
         if (pBannerData)
            DosFreeMem(pBannerData);
         break;
      }
   }
   return WinDefWindowProc(hwnd, msg, mp1, mp2);
}
