/******************************************************************************
*
*   AboutDlgProc()
*
*   DESCRIPTION: Dialog Procedure for PM Maps About page
*
******************************************************************************/

#define INCL_DEV
#define INCL_DOS
#include "bantest.h"
#include <banners.h>
#include <ecomedia.h>
#include <ecolange.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>

#define BUF_MAXLEN 128

/******************************/
/*                            */
/* This function translates   */
/* dialog controls with LANGE */
/*                            */
/******************************/

PSZ alarms[14]={"None",
                "Warning",
                "Informational",
                "Error",
                "Opening window",
                "Closing window",
                "Begin drag",
                "End drag",
                "System startup",
                "System shutdown",
                "Shred",
                "Lockup",
                "Alarm clock",
                "Printer error"};

void LocalizeWindow(HWND hwnd, LANGE hLange)
{

   CHAR  szOriginalText[BUF_MAXLEN];
   CHAR  szTranslatedText[BUF_MAXLEN];
   if (WinQueryWindowText(hwnd, BUF_MAXLEN, szOriginalText))
      if (!LngGetString(hLange, szOriginalText, szTranslatedText, BUF_MAXLEN))
         WinSetWindowText(hwnd, szTranslatedText);
}

void LocalizeDialog(HWND hwnd)
{
    extern LANGE hLange;
    if (hLange) // Check if LANGE initialized correctly
    {
      HWND  hwndNext;
      HENUM henum=WinBeginEnumWindows(hwnd);    // Let's enumerate thru all the child windows
      while((hwndNext=WinGetNextWindow(henum))!=NULLHANDLE)
      {
         CHAR szClassName[4];
         if (WinQueryClassName(hwndNext, 4, szClassName))
         {
            if (szClassName[0]=='#')
            {
               int wc=atoi(szClassName+1);
               // Don not translate contents of those controls
               if(wc==((int)WC_ENTRYFIELD&0xFF))
                  continue;
                  if(wc==((int)WC_SPINBUTTON&0xFF))
                                         continue;
                  if(wc==((int)WC_MLE&0xFF))
                                         continue;
               }
            LocalizeWindow(hwndNext, hLange);
         }
      }
      WinEndEnumWindows(henum);

      // Localize dialog itself
      LocalizeWindow(hwnd, hLange);
   }
}

void FillAlarmList(HWND hwndDlg, USHORT usComboBoxId, USHORT usSoundSelected)
{
   extern LANGE hLange;
   int   i;
   HWND  hwndComboBox=WinWindowFromID(hwndDlg, usComboBoxId);
   if (hwndComboBox)
   {
      for(i=0; i<14; i++)
      {
         CHAR szTranslatedText[BUF_MAXLEN];
         LngGetString(hLange, alarms[i], szTranslatedText, BUF_MAXLEN);
         WinSendMsg(hwndComboBox, LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(&szTranslatedText));
      }
      WinSendMsg(hwndComboBox, LM_SELECTITEM, MPFROMSHORT(usSoundSelected), MPFROMLONG(TRUE));
   }
}

MRESULT EXPENTRY BannerDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg)
   {
      case WM_INITDLG:
      {
         PBANNERDATA pBannerData=(PBANNERDATA)mp2;
         HPOINTER    hPtr;
         extern HAB hab;

//         WinRestoreWindowPos("Banner System Test", "Main Window Position", hwndDlg);
         WinSetWindowPtr(hwndDlg, QWL_USER, pBannerData);

         hPtr=WinLoadPointer(HWND_DESKTOP, 0L, IDI_BANNER_ICON_SOLID);
         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_OPTIONS_BORDER_TYPE, VM_SETITEM, MPFROM2SHORT(1, 2), MPFROMLONG(hPtr));
         hPtr=WinLoadPointer(HWND_DESKTOP, 0L, IDI_BANNER_ICON_RAISED);
         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_OPTIONS_BORDER_TYPE, VM_SETITEM, MPFROM2SHORT(1, 3), MPFROMLONG(hPtr));
         hPtr=WinLoadPointer(HWND_DESKTOP, 0L, IDI_BANNER_ICON_INSET);
         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_OPTIONS_BORDER_TYPE, VM_SETITEM, MPFROM2SHORT(1, 4), MPFROMLONG(hPtr));

         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SETTINGS_TIMEOUT, SPBM_SETLIMITS, MPFROMLONG(65535L), MPFROMLONG(0L));
         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SETTINGS_TIMEOUT, SPBM_SETCURRENTVALUE, MPFROMSHORT(pBannerData->ulTimeout), MPFROMLONG(0L));

         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SETTINGS_ID, SPBM_SETLIMITS, MPFROMLONG(65535L), MPFROMLONG(0L));
         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SETTINGS_ID, SPBM_SETCURRENTVALUE, MPFROMSHORT(pBannerData->ulId), MPFROMLONG(0L));

         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SIZE_WIDTH, SPBM_SETLIMITS, MPFROMLONG(640L), MPFROMLONG(0L));
         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SIZE_WIDTH, SPBM_SETCURRENTVALUE, MPFROMLONG(pBannerData->ulWidth), MPFROMLONG(0L));

         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SIZE_HEIGHT, SPBM_SETLIMITS, MPFROMLONG(480L), MPFROMLONG(0L));
         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SIZE_HEIGHT, SPBM_SETCURRENTVALUE, MPFROMLONG(pBannerData->ulHeight), MPFROMLONG(0L));

         WinSetDlgItemText(hwndDlg, IDD_BANNER_TEXT_TITLE, pBannerData->szTitle);
         WinSetDlgItemText(hwndDlg, IDD_BANNER_TEXT_MESSAGE, pBannerData->szText);

         WinCheckButton(hwndDlg, IDD_BANNER_OPTIONS_CLOSEBUTTON, (pBannerData->flFlags&BF_CLOSEBUTTON)!=0);
         WinCheckButton(hwndDlg, IDD_BANNER_OPTIONS_IMAGE, (pBannerData->flFlags&BF_IMAGE)!=0);
         WinCheckButton(hwndDlg, IDD_BANNER_OPTIONS_BORDER_THICK, (pBannerData->flFlags&BF_THICKFRAME)!=0);

         FillAlarmList(hwndDlg, IDD_BANNER_ALARM_SOUND, pBannerData->fsAlarmSound);

         WinSendDlgItemMsg(hwndDlg, IDD_BANNER_OPTIONS_BORDER_TYPE, VM_SELECTITEM, MPFROM2SHORT(1, (USHORT)(pBannerData->flFlags&BF_FRAME)+1), MPFROMLONG(0L));

//       Now it's time to localize captions
         LocalizeDialog(hwndDlg);

         return (MRESULT)TRUE;
      }   /* end case WM_INITDLG: */

      case WM_DESTROY:
         break;

      case WM_CONTROL:
         break;

      case WM_COMMAND:
         if (SHORT1FROMMP(mp2)==CMDSRC_PUSHBUTTON)
         {
            switch (SHORT1FROMMP(mp1))
            {
               case DID_OK:
               {
                  PBANNERDATA pBannerData;
                  if ((pBannerData = WinQueryWindowPtr(hwndDlg, QWL_USER)))
                  {
                     APIRET rc;
                     ULONG ulAttrFound;
                     ULONG ulBackgroundColor, ulForegroundColor;
                     CHAR  szFontName[256]="";
                     HWND  hwndSample;

                     WinStoreWindowPos("Banner System Test", "Dialog Window Position", hwndDlg);

                     pBannerData->flFlags=0L;

                     // Update settings
                     WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SIZE_WIDTH, SPBM_QUERYVALUE, MPFROMP(&pBannerData->ulWidth), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                     WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SIZE_HEIGHT, SPBM_QUERYVALUE, MPFROMP(&pBannerData->ulHeight), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                     WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SETTINGS_TIMEOUT, SPBM_QUERYVALUE, MPFROMP(&pBannerData->ulTimeout), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                     WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SETTINGS_ID, SPBM_QUERYVALUE, MPFROMP(&pBannerData->ulId), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));

                     pBannerData->fsAlarmSound=(SHORT)WinSendDlgItemMsg(hwndDlg, IDD_BANNER_ALARM_SOUND, LM_QUERYSELECTION, MPFROMSHORT(0), MPFROMLONG(0L));

                     WinQueryDlgItemText(hwndDlg, IDD_BANNER_TEXT_TITLE, sizeof(pBannerData->szTitle), pBannerData->szTitle);
                     WinQueryDlgItemText(hwndDlg, IDD_BANNER_TEXT_MESSAGE, sizeof(pBannerData->szText), pBannerData->szText);

                     if (WinQueryButtonCheckstate(hwndDlg, IDD_BANNER_OPTIONS_CLOSEBUTTON))
                        pBannerData->flFlags|=BF_CLOSEBUTTON;

                     if (WinQueryButtonCheckstate(hwndDlg, IDD_BANNER_OPTIONS_IMAGE))
                        pBannerData->flFlags|=BF_IMAGE;

                     if (WinQueryButtonCheckstate(hwndDlg, IDD_BANNER_OPTIONS_BORDER_THICK))
                        pBannerData->flFlags|=BF_THICKFRAME;

                     if (WinQueryButtonCheckstate(hwndDlg, IDD_BANNER_SETTINGS_ID_INCREASE))
                        pBannerData->flFlags|=BF_IDINCREASE;

                     hwndSample = WinWindowFromID(hwndDlg, IDD_BANNER_APPEARANCE_SAMPLE);

                     if (!WinQueryPresParam(hwndSample, PP_FOREGROUNDCOLOR, PP_FOREGROUNDCOLORINDEX,
                                            &ulAttrFound, sizeof(ULONG), &ulForegroundColor, QPF_ID2COLORINDEX))
                        ulForegroundColor = 0x00000000; // Black

                     if (!WinQueryPresParam(hwndSample, PP_BACKGROUNDCOLOR, PP_BACKGROUNDCOLORINDEX,
                                            &ulAttrFound, sizeof(ULONG), &ulBackgroundColor, QPF_ID2COLORINDEX))
                        ulBackgroundColor = 0x00FFFFFF; // White

                     WinQueryPresParam(hwndSample, PP_FONTNAMESIZE, 0L,
                                       &ulAttrFound, sizeof(szFontName), szFontName, 0L);

                     pBannerData->flFlags|=SHORT2FROMMP(WinSendDlgItemMsg(hwndDlg, IDD_BANNER_OPTIONS_BORDER_TYPE, VM_QUERYSELECTEDITEM, MPFROMLONG(0L), MPFROMLONG(0L)))-1;

                     // Create banner
                     rc = bsAddBanner(
                                    WinQueryWindow(hwndDlg, QW_OWNER), pBannerData->ulWidth, pBannerData->ulHeight,
                                      pBannerData->ulId, pBannerData->flFlags&0xFFFF, pBannerData->ulTimeout, NULLHANDLE, (pBannerData->flFlags&BF_IMAGE)?ID_BANNER:0,
                                      pBannerData->szTitle, pBannerData->szText,
                                      szFontName, ulForegroundColor, ulBackgroundColor, pBannerData->fsAlarmSound-1);
                     printf("Done\n");
                     fflush(stdout);
                     if (rc!= NO_ERROR)
                        printf ("bsAddBanner() error: return code = %u\n", rc);

                     if (pBannerData->flFlags&BF_IDINCREASE)
                        WinSendDlgItemMsg(hwndDlg, IDD_BANNER_SETTINGS_ID, SPBM_SPINUP, MPFROMLONG(1L), MPFROMLONG(0L));
                  }
                  return (MRESULT)0L;
               }
            }
         }
         break;
      }   // end switch (msg)

      return (WinDefDlgProc(hwndDlg, msg, mp1, mp2) );
      /* end SettingsDlgProc() */
}

/*
 *   Window data for the About dialog (settings page)
 */
typedef struct
{
    USHORT  cb;                                            /* size of this structure    */
    HBITMAP hbmLogo;                                       /* eyeCU logo bitmap handle  */
    HBITMAP hbmLogoMaps;                                   /* PMMaps logo bitmap handle */
} ABOUTDLGDATA, *PABOUTDLGDATA;

MRESULT EXPENTRY AboutDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   PABOUTDLGDATA  pAboutDlgData;   /* Original values buffer  */
   HWND           hwndControl;
   CTLCOLOR       ctlColor;
   ICONINFO       iconinfo;
   ULONG          cbIconDataSize;
   HDC            hdcMem;
   HPS            hpsMem;
   HPS            hpsImage, hpsAlpha;
   CHAR           szBuffer[BUF_MAXLEN], szBuffer1[BUF_MAXLEN], szBuffer2[BUF_MAXLEN];

   SIZEL          sizl;

   ULONG          ulCx;
   ULONG          ulCy;
   PVOID          pPngData=NULL;

   HBITMAP2       hbm2;

   DEVOPENSTRUC   dop={0L, "DISPLAY", NULL, 0L, 0L, 0L, 0L, 0L, 0L};

   extern HAB     hab;
//   extern LONG    lVerMajor;
//   extern LONG    lVerMinor;
//   extern HBITMAP2 hbm2eyeCU;
//   extern HBITMAP2 hbm2PMMaps;

   BOOL MoveControlsAbout(HWND hwnd, ULONG ulCx, ULONG ulCy);

   switch (msg)
   {
      case WM_INITDLG:
      {
//         extern LANGE hLange;

         if (!DosAllocMem((PPVOID)&pAboutDlgData, sizeof(ABOUTDLGDATA), PAG_COMMIT|PAG_READ|PAG_WRITE|OBJ_ANY))
         {
            memset((PVOID) pAboutDlgData, 0, sizeof(*pAboutDlgData));
            pAboutDlgData->cb = sizeof(*pAboutDlgData);
            pAboutDlgData->hbmLogo=NULLHANDLE;
         }
         else
            break;
         WinSetWindowPtr(hwndDlg, QWL_USER, pAboutDlgData);

         ctlColor.clrIndex = CCI_BACKGROUND;            // Get button background color
         if (!WinQueryControlColors(hwndDlg, CCT_NOTEBOOK, 0, 1, &ctlColor))
            ctlColor.clrValue=CLR_PALEGRAY; // Default
/*
         ulCx=ulIconCx*2;
         ulCy=ulIconCy*2;

        // Let's create BITMAP ICON from BITMAP2 image and set it as an eyeCU logo
        if (hbm2eyeCU)
            if (pAboutDlgData->hbmLogo=Gpi2BitmapFromBitmap2(hbm2eyeCU, ctlColor.clrValue, FL_PROCESSALPHA))
                if (hwndControl=WinWindowFromID(hwndDlg, IDD_ABOUT_LOGO_EYECU))
                    if (WinSetWindowULong(hwndControl, QWL_STYLE, SS_BITMAP|SS_AUTOSIZE|WS_VISIBLE))
                    {
                        if (!WinSendMsg(hwndControl, SM_SETHANDLE, (MPARAM)pAboutDlgData->hbmLogo, (MPARAM)0L))
                            GpiDeleteBitmap(pAboutDlgData->hbmLogo);
                    }
                    else
                        GpiDeleteBitmap(pAboutDlgData->hbmLogo);

        if (hbm2PMMaps)
            if (pAboutDlgData->hbmLogoMaps=Gpi2BitmapFromBitmap2(hbm2PMMaps, ctlColor.clrValue, FL_PROCESSALPHA))
                if (hwndControl=WinWindowFromID(hwndDlg, IDD_ABOUT_LOGO_MAPS))
                    if (WinSetWindowULong(hwndControl, QWL_STYLE, SS_BITMAP|SS_AUTOSIZE|WS_VISIBLE))
                    {
                        if (!WinSendMsg(hwndControl, SM_SETHANDLE, (MPARAM)pAboutDlgData->hbmLogoMaps, (MPARAM)0L))
                            GpiDeleteBitmap(pAboutDlgData->hbmLogoMaps);
                    }
                    else
                        GpiDeleteBitmap(pAboutDlgData->hbmLogoMaps);
*/
         // Now it's time to localize captions
         LocalizeDialog(hwndDlg);
/*
        if (WinQueryDlgItemText(hwndDlg, IDD_ABOUT_DEVELOPER, BUF_MAXLEN, szBuffer1))
        {
            LngGetString(hLange, "<DEVELOPER>", szBuffer2, BUF_MAXLEN);
            if (sprintf(szBuffer, szBuffer1, szBuffer2))
               WinSetDlgItemText(hwndDlg, IDD_ABOUT_DEVELOPER, szBuffer);
        }

      if (WinQueryDlgItemText(hwndDlg, IDD_ABOUT_TRANSLATOR, BUF_MAXLEN, szBuffer1))
      {
            LngGetString(hLange, "<TRANSLATOR>", szBuffer2, BUF_MAXLEN);
            if (sprintf(szBuffer, szBuffer1, szBuffer2))
               WinSetDlgItemText(hwndDlg, IDD_ABOUT_TRANSLATOR, szBuffer);
      }
         // Display version
         LngGetString(hLange, "Version %u.%u", szBuffer1, BUF_MAXLEN);
         if (sprintf(szBuffer, szBuffer1, lVerMajor, lVerMinor))
            WinSetDlgItemText(hwndDlg, IDD_ABOUT_VERSION, szBuffer);
*/

         return (MRESULT) TRUE;
      }   /* end case WM_INITDLG: */

      case WM_DESTROY:
         if ((pAboutDlgData = WinQueryWindowPtr(hwndDlg, QWL_USER)))
         {
            GpiDeleteBitmap(pAboutDlgData->hbmLogo);
            DosFreeMem((PBYTE)pAboutDlgData);
         }
         break;
/*
      case WM_WINDOWPOSCHANGED:         // For some reason notebook page do not receive WM_SIZE message
         if (((PSWP)mp1)->fl&SWP_SIZE)  // So, we have to check it here
            MoveControlsAbout(hwndDlg, ((PSWP)mp1)->cx, ((PSWP)mp1)->cy);
         break;
*/
   }   /* end switch (msg) */

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2) );
}   /* end AboutDlgProc() */
