/**********************************************************************/
/*                                                                    */
/* DragText (C)Copyright 1994-2003,2007 RL Walsh  All Rights Reserved */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/*  DTNLS39.H                                                         */
/*                                                                    */
/*  !!!  DO NOT edit this file  !!!                                   */
/*                                                                    */
/*  ---  translate DT39_XX.TXT  ---                                   */
/*                                                                    */
/**********************************************************************/

#ifndef dtnls_h

//----------------------------------------------------------------------
//  Common Pushbuttons
//----------------------------------------------------------------------

#define PUSH_BASE           0x0000

#define PUSH_Delete         (PUSH_BASE + 0x00)
#define PUSH_Add            (PUSH_BASE + 0x01)
#define PUSH_Default        (PUSH_BASE + 0x02)
#define PUSH_Apply          (PUSH_BASE + 0x03)
#define PUSH_Help           (PUSH_BASE + 0x04)
#define PUSH_Undo           (PUSH_BASE + 0x05)

#define PUSH_LAST           (PUSH_BASE + 0x05)

//----------------------------------------------------------------------
//  Drgtxt39.dll
//----------------------------------------------------------------------

#define DTD_BASE            0x0010

#define DTD_Mouse           (DTD_BASE + 0x00)
#define DTD_Hotkeys         (DTD_BASE + 0x01)
#define DTD_Drag            (DTD_BASE + 0x02)
#define DTD_Drop            (DTD_BASE + 0x03)
#define DTD_FileAttribs     (DTD_BASE + 0x04)

#define DTD_LAST            (DTD_BASE + 0x04)

//----------------------------------------------------------------------
//  DTWps39.dll
//----------------------------------------------------------------------

#define DTW_BASE            0x0020

#define DTW_Locate_in       (DTW_BASE + 0x00)
#define DTW_Unknown         (DTW_BASE + 0x01)
#define DTW_no_title        (DTW_BASE + 0x02)

#define DTW_LAST            (DTW_BASE + 0x02)

//----------------------------------------------------------------------
//  Drgtxt39.exe
//----------------------------------------------------------------------

#define SPIN_BASE           0x0030

#define SPIN_MB1            (SPIN_BASE + 0x0000)
#define SPIN_MB2            (SPIN_BASE + 0x0001)
#define SPIN_MB3            (SPIN_BASE + 0x0002)
#define SPIN_yes            (SPIN_BASE + 0x0003)
#define SPIN_no             (SPIN_BASE + 0x0004)
#define SPIN_disabled       (SPIN_BASE + 0x0005)
#define SPIN_enabled        (SPIN_BASE + 0x0006)
#define SPIN_create_only    (SPIN_BASE + 0x0007)
#define SPIN_read_only      (SPIN_BASE + 0x0008)
#define SPIN_create_read    (SPIN_BASE + 0x0009)
#define SPIN_drag_only      (SPIN_BASE + 0x000A)
#define SPIN_drop_only      (SPIN_BASE + 0x000B)
#define SPIN_drag_drop      (SPIN_BASE + 0x000C)
#define SPIN_seconds        (SPIN_BASE + 0x000D)

#define SPIN_LAST           (SPIN_BASE + 0x000D)

#define DTX_BASE            0x0040

#define OPTS_Name           (DTX_BASE + 0x0000)
#define OPTS_Title          (DTX_BASE + 0x0001)
#define OPTS_DragDflts      (DTX_BASE + 0x0002)
#define OPTS_Between        (DTX_BASE + 0x0003)
#define OPTS_Within         (DTX_BASE + 0x0004)
#define OPTS_Override       (DTX_BASE + 0x0005)
#define OPTS_DropOpts       (DTX_BASE + 0x0006)
#define OPTS_Hilite         (DTX_BASE + 0x0007)
#define OPTS_EFText         (DTX_BASE + 0x0008)
#define OPTS_PressInsert    (DTX_BASE + 0x0009)
#define OPTS_copy           (DTX_BASE + 0x000A)
#define OPTS_move           (DTX_BASE + 0x000B)
#define OPTS_insert         (DTX_BASE + 0x000C)
#define OPTS_replace        (DTX_BASE + 0x000D)

#define MISC_Name           (DTX_BASE + 0x0010)
#define MISC_Title          (DTX_BASE + 0x0011)
#define MISC_OtherOpts      (DTX_BASE + 0x0012)
#define MISC_MousePtr       (DTX_BASE + 0x0013)
#define MISC_Error          (DTX_BASE + 0x0014)
#define MISC_ErrorBeep      (DTX_BASE + 0x0015)
#define MISC_SizePos        (DTX_BASE + 0x0016)
#define MISC_SaveExit       (DTX_BASE + 0x0017)
#define MISC_SaveNow        (DTX_BASE + 0x0018)
#define MISC_DfltSize       (DTX_BASE + 0x0019)
#define MISC_Restore        (DTX_BASE + 0x001A)
#define MISC_standard       (DTX_BASE + 0x001B)
#define MISC_large          (DTX_BASE + 0x001C)
#define MISC_beep           (DTX_BASE + 0x001D)
#define MISC_none           (DTX_BASE + 0x001E)

#define PRES_Name           (DTX_BASE + 0x0020)
#define PRES_Title          (DTX_BASE + 0x0021)
#define PRES_SetColors      (DTX_BASE + 0x0022)
#define PRES_Heading        (DTX_BASE + 0x0023)
#define PRES_PageText       (DTX_BASE + 0x0024)
#define PRES_EditWnds       (DTX_BASE + 0x0025)
#define PRES_Checkbox       (DTX_BASE + 0x0026)
#define PRES_Buttons        (DTX_BASE + 0x0027)
#define PRES_DropColor      (DTX_BASE + 0x0028)
#define PRES_CtrlDrop       (DTX_BASE + 0x0029)
#define PRES_DfltScheme     (DTX_BASE + 0x002A)
#define PRES_Color          (DTX_BASE + 0x002B)
#define PRES_Gray           (DTX_BASE + 0x002C)
#define PRES_Contents       (DTX_BASE + 0x002D)
#define PRES_Display        (DTX_BASE + 0x002E)
#define PRES_Icons          (DTX_BASE + 0x002F)
#define PRES_Lines          (DTX_BASE + 0x01CE) // overflow

#define ZORD_Name           (DTX_BASE + 0x0030)
#define ZORD_Title          (DTX_BASE + 0x0031)
#define ZORD_Enable         (DTX_BASE + 0x0032)
#define ZORD_ODrag          (DTX_BASE + 0x0033)
#define ZORD_OpenFldrs      (DTX_BASE + 0x0034)
#define ZORD_OtherPgms      (DTX_BASE + 0x0035)
#define ZORD_AddODrag       (DTX_BASE + 0x0036)
#define ZORD_RequireReg     (DTX_BASE + 0x0037)
#define ZORD_DT_only        (DTX_BASE + 0x0038)
#define ZORD_DT_WPS_Others  (DTX_BASE + 0x0039)

#define ZOPT_Name           (DTX_BASE + 0x0040)
#define ZOPT_Title          (DTX_BASE + 0x0041)
#define ZOPT_Before         (DTX_BASE + 0x0042)
#define ZOPT_BkgndDrag      (DTX_BASE + 0x0043)
#define ZOPT_Prevents       (DTX_BASE + 0x0044)
#define ZOPT_During         (DTX_BASE + 0x0045)
#define ZOPT_AutoRaise      (DTX_BASE + 0x0046)
#define ZOPT_Redraw         (DTX_BASE + 0x0047)
#define ZOPT_Increase       (DTX_BASE + 0x0048)
#define ZOPT_After          (DTX_BASE + 0x0049)
#define ZOPT_Restore        (DTX_BASE + 0x004A)
#define ZOPT_Close          (DTX_BASE + 0x004B)
#define ZOPT_Folder         (DTX_BASE + 0x004C)
#define ZOPT_ms             (DTX_BASE + 0x004D)

#define ZKEY_Name           (DTX_BASE + 0x0050)
#define ZKEY_Title          (DTX_BASE + 0x0051)
#define ZKEY_Feature        (DTX_BASE + 0x0052)
#define ZKEY_Key            (DTX_BASE + 0x0053)
#define ZKEY_Button         (DTX_BASE + 0x0054)
#define ZKEY_OverDrag       (DTX_BASE + 0x0055)
#define ZKEY_ClickOn        (DTX_BASE + 0x0056)
#define ZKEY_Raise          (DTX_BASE + 0x0057)
#define ZKEY_Lower          (DTX_BASE + 0x0058)
#define ZKEY_Rotate         (DTX_BASE + 0x0059)
#define ZKEY_Auto           (DTX_BASE + 0x005A)
#define ZKEY_ScrollUp       (DTX_BASE + 0x005B)
#define ZKEY_ScrollDn       (DTX_BASE + 0x005C)
#define ZKEY_MinRestore     (DTX_BASE + 0x005D)
#define ZKEY_Redisplay      (DTX_BASE + 0x005E)
#define ZKEY_OpenPar        (DTX_BASE + 0x005F)
#define ZKEY_DragOver       (DTX_BASE + 0x0060)
#define ZKEY_Set            (DTX_BASE + 0x0061)
#define ZKEY_PressKey       (DTX_BASE + 0x0062)
#define ZKEY_Clear          (DTX_BASE + 0x0063)
#define ZKEY_PressDel       (DTX_BASE + 0x0064)
#define ZKEY_Cancel         (DTX_BASE + 0x0065)
#define ZKEY_PressEsc       (DTX_BASE + 0x0066)
#define ZKEY_RequireReg     (DTX_BASE + 0x0067)
#define ZKEY_Enter          (DTX_BASE + 0x0068)
#define ZKEY_Space          (DTX_BASE + 0x0069)
#define ZKEY_BkSpace        (DTX_BASE + 0x006A)
#define ZKEY_Left           (DTX_BASE + 0x006B)
#define ZKEY_Up             (DTX_BASE + 0x006C)
#define ZKEY_Right          (DTX_BASE + 0x006D)
#define ZKEY_Down           (DTX_BASE + 0x006E)
#define ZKEY_PageUp         (DTX_BASE + 0x006F)
#define ZKEY_PageDown       (DTX_BASE + 0x0070)
#define ZKEY_Home           (DTX_BASE + 0x0071)
#define ZKEY_End            (DTX_BASE + 0x0072)
#define ZKEY_Win_key        (DTX_BASE + 0x0073)
#define ZKEY_App_key        (DTX_BASE + 0x0074)
#define ZKEY_Pause          (DTX_BASE + 0x0075)
#define ZKEY_PrintScrn      (DTX_BASE + 0x0076)

#define FCRE_Name           (DTX_BASE + 0x0080)
#define FCRE_Title          (DTX_BASE + 0x0081)
#define FCRE_Enable         (DTX_BASE + 0x0082)
#define FCRE_Files          (DTX_BASE + 0x0083)
#define FCRE_Urls           (DTX_BASE + 0x0084)
#define FCRE_FileTitles     (DTX_BASE + 0x0085)
#define FCRE_Lines          (DTX_BASE + 0x0086)
#define FCRE_Chars          (DTX_BASE + 0x0087)
#define FCRE_NbrChars       (DTX_BASE + 0x0088)
#define FCRE_Replace        (DTX_BASE + 0x0089)
#define FCRE_CodePage       (DTX_BASE + 0x008A)
#define FCRE_create         (DTX_BASE + 0x008B)
#define FCRE_standard       (DTX_BASE + 0x008C)
#define FCRE_ASCII          (DTX_BASE + 0x008D)
#define FCRE_generic        (DTX_BASE + 0x008E)
#define FCRE_space          (DTX_BASE + 0x008F)

#define FDTF_Name           (DTX_BASE + 0x0090)
#define FDTF_Title          (DTX_BASE + 0x0091)
#define FDTF_Drag           (DTX_BASE + 0x0092)
#define FDTF_Creating       (DTX_BASE + 0x0093)
#define FDTF_Drop           (DTX_BASE + 0x0094)
#define FDTF_DropDTFile     (DTX_BASE + 0x0095)
#define FDTF_Dropping       (DTX_BASE + 0x0096)
#define FDTF_copy_text      (DTX_BASE + 0x0097)
#define FDTF_move_text      (DTX_BASE + 0x0098)
#define FDTF_copy_file      (DTX_BASE + 0x0099)
#define FDTF_delete_file    (DTX_BASE + 0x009A)

#define FDROP_Name          (DTX_BASE + 0x00A0)
#define FDROP_Title         (DTX_BASE + 0x00A1)
#define FDROP_DropDflt      (DTX_BASE + 0x00A2)
#define FDROP_Drop          (DTX_BASE + 0x00A3)
#define FDROP_Mle           (DTX_BASE + 0x00A4)
#define FDROP_Vio           (DTX_BASE + 0x00A5)
#define FDROP_DTClip        (DTX_BASE + 0x00A6)
#define FDROP_DTFile        (DTX_BASE + 0x00A7)
#define FDROP_Usage         (DTX_BASE + 0x00A8)
#define FDROP_Alt           (DTX_BASE + 0x00A9)
#define FDROP_Switch        (DTX_BASE + 0x00AA)
#define FDROP_Shift         (DTX_BASE + 0x00AB)
#define FDROP_Filename      (DTX_BASE + 0x00AC)
#define FDROP_Ctrl          (DTX_BASE + 0x00AD)
#define FDROP_Directory     (DTX_BASE + 0x00AE)

#define URL_Name            (DTX_BASE + 0x00B0)
#define URL_Title           (DTX_BASE + 0x00B1)
#define URL_UrlIds          (DTX_BASE + 0x00B2)
#define URL_Reformat        (DTX_BASE + 0x00B3)
#define URL_TitleOpts       (DTX_BASE + 0x00B4)
#define URL_Remove          (DTX_BASE + 0x00B5)
#define URL_LineBreak       (DTX_BASE + 0x00B6)
#define URL_HostName        (DTX_BASE + 0x00B7)

#define DIR_Name            (DTX_BASE + 0x00B9)
#define DIR_Title           (DTX_BASE + 0x00BA)
#define DIR_Include         (DTX_BASE + 0x00BB)
#define DIR_Flags           (DTX_BASE + 0x00BC)
#define DIR_Heading         (DTX_BASE + 0x00BD)
#define DIR_Listing         (DTX_BASE + 0x00BE)
#define DIR_FileAttribs     (DTX_BASE + 0x00BF)

#define VIO_Name            (DTX_BASE + 0x00C0)
#define VIO_Title           (DTX_BASE + 0x00C1)
#define VIO_Enable          (DTX_BASE + 0x00C2)
#define VIO_Vio             (DTX_BASE + 0x00C3)
#define VIO_Defaults        (DTX_BASE + 0x00C4)
#define VIO_DAndD           (DTX_BASE + 0x00C5)
#define VIO_Mouse           (DTX_BASE + 0x00C6)
#define VIO_Hotkeys         (DTX_BASE + 0x00C7)
#define VIO_Change          (DTX_BASE + 0x00C8)

#define MOU_Name            (DTX_BASE + 0x00C9)
#define MOU_Title           (DTX_BASE + 0x00CA)
#define MOU_Mouse           (DTX_BASE + 0x00CB)
#define MOU_Button          (DTX_BASE + 0x00CC)
#define MOU_Keyboard        (DTX_BASE + 0x00CD)
#define MOU_Remove          (DTX_BASE + 0x00CE)
#define MOU_Usage           (DTX_BASE + 0x00CF)
#define MOU_Mark            (DTX_BASE + 0x00D0)
#define MOU_MarkText        (DTX_BASE + 0x00D1)
#define MOU_Copy            (DTX_BASE + 0x00D2)
#define MOU_PressMb2        (DTX_BASE + 0x00D3)
#define MOU_Paste           (DTX_BASE + 0x00D4)
#define MOU_PasteText       (DTX_BASE + 0x00D5)
#define MOU_mouse_button_1  (DTX_BASE + 0x00D6)
#define MOU_mouse_button_3  (DTX_BASE + 0x00D7)
#define MOU_ignore_kybd     (DTX_BASE + 0x00D8)
#define MOU_no_keys         (DTX_BASE + 0x00D9)
#define MOU_Shift           (DTX_BASE + 0x00DA)
#define MOU_Ctrl            (DTX_BASE + 0x00DB)
#define MOU_Alt             (DTX_BASE + 0x00DC)
#define MOU_Shift_Ctrl      (DTX_BASE + 0x00DD)
#define MOU_Shift_Alt       (DTX_BASE + 0x00DE)
#define MOU_Ctrl_Alt        (DTX_BASE + 0x00DF)
#define MOU_Shift_Ctrl_Alt  (DTX_BASE + 0x01CF) // overflow

#define WPS_Name            (DTX_BASE + 0x00E0)
#define WPS_Title           (DTX_BASE + 0x00E1)
#define WPS_Clipboard       (DTX_BASE + 0x00E2)
#define WPS_Append          (DTX_BASE + 0x00E3)
#define WPS_Basic           (DTX_BASE + 0x00E4)
#define WPS_Install         (DTX_BASE + 0x00E5)
#define WPS_Remove          (DTX_BASE + 0x00E6)

#define WLNK_Name           (DTX_BASE + 0x00E7)
#define WLNK_Title          (DTX_BASE + 0x00E8)
#define WLNK_Enable         (DTX_BASE + 0x00E9)
#define WLNK_SystemMenu     (DTX_BASE + 0x00EA)
#define WLNK_DragLink       (DTX_BASE + 0x00EB)
#define WLNK_ShowMenu       (DTX_BASE + 0x00EC)
#define WLNK_Usage          (DTX_BASE + 0x00ED)
#define WLNK_PointAt        (DTX_BASE + 0x00EE)
#define WLNK_WhenViewing    (DTX_BASE + 0x00EF)

#define TLNK_Name           (DTX_BASE + 0x00F0)
#define TLNK_Title          (DTX_BASE + 0x00F1)
#define TLNK_Enable         (DTX_BASE + 0x00F2)
#define TLNK_LinkTo         (DTX_BASE + 0x00F3)
#define TLNK_DragLink       (DTX_BASE + 0x00F4)
#define TLNK_ShowMenu       (DTX_BASE + 0x00F5)
#define TLNK_Hotkeys        (DTX_BASE + 0x00F6)
#define TLNK_SearchPaths    (DTX_BASE + 0x00F7)
#define TLNK_DTSearches     (DTX_BASE + 0x00F8)
#define TLNK_Libpath        (DTX_BASE + 0x00F9)

#define D2O_Name            (DTX_BASE + 0x0100)
#define D2O_Title           (DTX_BASE + 0x0101)
#define D2O_Enable          (DTX_BASE + 0x0102)
#define D2O_DropObject      (DTX_BASE + 0x0103)
#define D2O_DropToOpen      (DTX_BASE + 0x0104)
#define D2O_DfltDrop        (DTX_BASE + 0x0105)
#define D2O_Locate          (DTX_BASE + 0x0106)
#define D2O_Open            (DTX_BASE + 0x0107)
#define D2O_Usage           (DTX_BASE + 0x0108)

#define PKUP_Name           (DTX_BASE + 0x0110)
#define PKUP_Title          (DTX_BASE + 0x0111)
#define PKUP_Enable         (DTX_BASE + 0x0112)
#define PKUP_DragACopy      (DTX_BASE + 0x0113)
#define PKUP_Pickup         (DTX_BASE + 0x0114)
#define PKUP_Usage          (DTX_BASE + 0x0115)
#define PKUP_PickupUse      (DTX_BASE + 0x0116)
#define PKUP_Selected       (DTX_BASE + 0x0117)
#define PKUP_AllText        (DTX_BASE + 0x0118)
#define PKUP_Drop           (DTX_BASE + 0x0119)
#define PKUP_CtrlMb2        (DTX_BASE + 0x011A)
#define PKUP_Cancel         (DTX_BASE + 0x011B)
#define PKUP_AltMb2         (DTX_BASE + 0x011C)
#define PKUP_Move           (DTX_BASE + 0x011D)

#define SET_Name            (DTX_BASE + 0x0120)
#define SET_Title           (DTX_BASE + 0x0121)
#define SET_Startup         (DTX_BASE + 0x0122)
#define SET_How             (DTX_BASE + 0x0123)
#define SET_Current         (DTX_BASE + 0x0124)
#define SET_New             (DTX_BASE + 0x0125)
#define SET_Create          (DTX_BASE + 0x0126)
#define SET_MoveDTClip      (DTX_BASE + 0x0127)
#define SET_InstRemove      (DTX_BASE + 0x0128)
#define SET_RunDTSetup      (DTX_BASE + 0x0129)
#define SET_loaded_by_DT    (DTX_BASE + 0x012A)
#define SET_autoloaded      (DTX_BASE + 0x012B)
#define SET_manually        (DTX_BASE + 0x012C)
#define SET_autoload        (DTX_BASE + 0x012D)
#define SET_WPS_Startup     (DTX_BASE + 0x012E)
#define SET_Startup_Obj     (DTX_BASE + 0x012F)

#define PATH_Name           (DTX_BASE + 0x0130)
#define PATH_Title          (DTX_BASE + 0x0131)
#define PATH_TempFiles      (DTX_BASE + 0x0132)
#define PATH_LetDTCreate    (DTX_BASE + 0x0133)
#define PATH_Create         (DTX_BASE + 0x0134)
#define PATH_Path           (DTX_BASE + 0x0135)
#define PATH_ChangeIf       (DTX_BASE + 0x0136)
#define PATH_CopyIni        (DTX_BASE + 0x0137)
#define PATH_never          (DTX_BASE + 0x0138)
#define PATH_always         (DTX_BASE + 0x0139)
#define PATH_Urls_only      (DTX_BASE + 0x013A)

#define DIS_Name            (DTX_BASE + 0x0140)
#define DIS_Title           (DTX_BASE + 0x0141)
#define DIS_Program         (DTX_BASE + 0x0142)
#define DIS_Disable         (DTX_BASE + 0x0143)
#define DIS_Drag            (DTX_BASE + 0x0144)
#define DIS_Drop            (DTX_BASE + 0x0145)
#define DIS_AllFeatures     (DTX_BASE + 0x0146)
#define DIS_CausesCrash     (DTX_BASE + 0x0147)
#define DIS_BkgndDrag       (DTX_BASE + 0x0148)
#define DIS_PopupMenu       (DTX_BASE + 0x0149)
#define DIS_Multi           (DTX_BASE + 0x014A)
#define DIS_MostLikely      (DTX_BASE + 0x014B)
#define DIS_Other           (DTX_BASE + 0x014C)
#define DIS_Entry           (DTX_BASE + 0x014D)
#define DIS_List            (DTX_BASE + 0x014E)
#define DIS_Combo           (DTX_BASE + 0x014F)
#define DIS_Spin            (DTX_BASE + 0x0150)
#define DIS_Static          (DTX_BASE + 0x0151)
#define DIS_SysMenu         (DTX_BASE + 0x0152)
#define DIS_Titlebar        (DTX_BASE + 0x0153)
#define DIS_Files           (DTX_BASE + 0x0154)
#define DIS_cant_add        (DTX_BASE + 0x0155)
#define DIS_will_delete     (DTX_BASE + 0x0156)

#define REEN_Name           (DTX_BASE + 0x015A)
#define REEN_Title          (DTX_BASE + 0x015B)
#define REEN_Reenable       (DTX_BASE + 0x015C)
#define REEN_RestoreDT      (DTX_BASE + 0x015D)
#define REEN_cant_add       (DTX_BASE + 0x015E)
#define REEN_will_delete    (DTX_BASE + 0x015F)

#define FIX_Name            (DTX_BASE + 0x0160)
#define FIX_Title           (DTX_BASE + 0x0161)
#define FIX_Startup         (DTX_BASE + 0x0162)
#define FIX_Delay           (DTX_BASE + 0x0163)
#define FIX_Icons           (DTX_BASE + 0x0164)
#define FIX_ChangeIcons     (DTX_BASE + 0x0165)
#define FIX_Cache           (DTX_BASE + 0x0166)
#define FIX_Misc            (DTX_BASE + 0x0167)
#define FIX_VioFile         (DTX_BASE + 0x0168)
#define FIX_AllText         (DTX_BASE + 0x0169)
#define FIX_auto_no         (DTX_BASE + 0x016A)
#define FIX_auto_yes        (DTX_BASE + 0x016B)
#define FIX_auto_detect     (DTX_BASE + 0x016C)

#define TEST_Name           (DTX_BASE + 0x0170)
#define TEST_Title          (DTX_BASE + 0x0171)
#define TEST_Entry          (DTX_BASE + 0x0172)
#define TEST_Spin           (DTX_BASE + 0x0173)
#define TEST_Multi          (DTX_BASE + 0x0174)
#define TEST_Combo          (DTX_BASE + 0x0175)
#define TEST_List           (DTX_BASE + 0x0176)
#define TEST_Static         (DTX_BASE + 0x0177)
#define TEST_Vio            (DTX_BASE + 0x0178)
#define TEST_EntryText      (DTX_BASE + 0x0179)
#define TEST_MultiText      (DTX_BASE + 0x017A)
#define TEST_StaticText1    (DTX_BASE + 0x017B)
#define TEST_StaticText2    (DTX_BASE + 0x017C)
#define TEST_SpinText1      (DTX_BASE + 0x017D)
#define TEST_SpinText2      (DTX_BASE + 0x017E)
#define TEST_ComboText1     (DTX_BASE + 0x017F)
#define TEST_ComboText2     (DTX_BASE + 0x0180)
#define TEST_ComboText3     (DTX_BASE + 0x0181)
#define TEST_ComboText4     (DTX_BASE + 0x0182)
#define TEST_ListText1      (DTX_BASE + 0x0183)
#define TEST_ListText2      (DTX_BASE + 0x0184)
#define TEST_ListText3      (DTX_BASE + 0x0185)
#define TEST_ListText4      (DTX_BASE + 0x0186)
#define TEST_ListText5      (DTX_BASE + 0x0187)

#define ICON_Name           (DTX_BASE + 0x0190)
#define ICON_Title          (DTX_BASE + 0x0191)
#define ICON_Text           (DTX_BASE + 0x0192)
#define ICON_Listing        (DTX_BASE + 0x0193)
#define ICON_Path           (DTX_BASE + 0x0194)
#define ICON_Contents       (DTX_BASE + 0x0195)
#define ICON_Create         (DTX_BASE + 0x0196)
#define ICON_Locate         (DTX_BASE + 0x0197)
#define ICON_Open           (DTX_BASE + 0x0198)
#define ICON_InsertSel      (DTX_BASE + 0x0199)
#define ICON_Replace        (DTX_BASE + 0x019A)
#define ICON_Illegal        (DTX_BASE + 0x019B)

#define DLL_Name            (DTX_BASE + 0x01A0)
#define DLL_Title           (DTX_BASE + 0x01A1)
#define DLL_Usage           (DTX_BASE + 0x01A2)
#define DLL_PId             (DTX_BASE + 0x01A3)
#define DLL_Init            (DTX_BASE + 0x01A4)
#define DLL_Using           (DTX_BASE + 0x01A5)
#define DLL_Errors          (DTX_BASE + 0x01A6)
#define DLL_ErrCount        (DTX_BASE + 0x01A7)
#define DLL_LastErr         (DTX_BASE + 0x01A8)
#define DLL_OnlineHelp      (DTX_BASE + 0x01A9) 
#define DLL_Refresh         (DTX_BASE + 0x01AA)

#define PROD_Name           (DTX_BASE + 0x01B0)
#define PROD_Slogan         (DTX_BASE + 0x01B1)
#define PROD_Copyright      (DTX_BASE + 0x01B2)
#define PROD_RegInfo        (DTX_BASE + 0x01B3)
#define PROD_RegName        (DTX_BASE + 0x01B4)
#define PROD_RegNumber      (DTX_BASE + 0x01B5)
#define PROD_MoreInfo       (DTX_BASE + 0x01B6)
#define PROD_Version        (DTX_BASE + 0x01B7)
#define PROD_Registered     (DTX_BASE + 0x01B8)
#define PROD_AreDisabled    (DTX_BASE + 0x01B9)
#define PROD_FreeTrial      (DTX_BASE + 0x01BA)
#define PROD_Day            (DTX_BASE + 0x01BB)
#define PROD_Days           (DTX_BASE + 0x01BC)
#define PROD_TranslatedBy   (DTX_BASE + 0x01BD)
#define PROD_will_expire    (DTX_BASE + 0x01BE)
#define PROD_has_expired    (DTX_BASE + 0x01BF)

#define INIT_ClickTo        (DTX_BASE + 0x01C0)

// overflow
//#define PRES_Lines          (DTX_BASE + 0x01CE)
//#define MOU_Shift_Ctrl_Alt  (DTX_BASE + 0x01CF)

#define MSG_RemoveDTFile    (DTX_BASE + 0x01D0)
#define MSG_RemoveDTClip    (DTX_BASE + 0x01D1)
#define MSG_RemoveDTPgm     (DTX_BASE + 0x01D2)
#define MSG_AreYouSure      (DTX_BASE + 0x01D3)
#define MSG_ReinstDTFile1   (DTX_BASE + 0x01D4)
#define MSG_ReinstDTFile2   (DTX_BASE + 0x01D5)
#define MSG_ClassNotReg     (DTX_BASE + 0x01D6)
#define MSG_LocateFailed    (DTX_BASE + 0x01D7)
#define MSG_DeregFailed     (DTX_BASE + 0x01D8)
#define MSG_DeregOK         (DTX_BASE + 0x01D9)
#define MSG_RegFailed       (DTX_BASE + 0x01DA)
#define MSG_RegOK           (DTX_BASE + 0x01DB)
#define MSG_ReplaceFailed   (DTX_BASE + 0x01DC)
#define MSG_ClipObjFailed   (DTX_BASE + 0x01DD)
#define MSG_ClipObjOK       (DTX_BASE + 0x01DE)
#define MSG_ClipObjNote     (DTX_BASE + 0x01DF)
#define MSG_DTObjOK         (DTX_BASE + 0x01E0)
#define MSG_DTObjFailed     (DTX_BASE + 0x01E1)
#define MSG_DTDisabled      (DTX_BASE + 0x01E2)
#define MSG_BetaExpired     (DTX_BASE + 0x01E3)
#define MSG_OpenDTNotebook  (DTX_BASE + 0x01E4)
#define MSG_CopyIniFailed   (DTX_BASE + 0x01E5)
#define MSG_SavePathFailed  (DTX_BASE + 0x01E6)
#define MSG_OpCancelled     (DTX_BASE + 0x01E7)
#define MSG_OpenIniFailed   (DTX_BASE + 0x01E8)
#define MSG_WriteIniFailed  (DTX_BASE + 0x01E9)
#define MSG_NotSaved        (DTX_BASE + 0x01EA)

#define DTX_LAST            (DTX_BASE + 0x01EA)

//----------------------------------------------------------------------
//  WPS Object Menu Items
//----------------------------------------------------------------------

#define OBJM_BASE           0x0230

#define OBJM_New_wnd        (OBJM_BASE + 0x00)
#define OBJM_Existing_wnd   (OBJM_BASE + 0x01)
#define OBJM_Close_All      (OBJM_BASE + 0x02)
#define OBJM_Kill_All       (OBJM_BASE + 0x03)
#define OBJM_Objects        (OBJM_BASE + 0x04)
#define OBJM_Pgm_Dir        (OBJM_BASE + 0x05)
#define OBJM_Work_Dir       (OBJM_BASE + 0x06)

#define OBJM_LAST           (OBJM_BASE + 0x06)

//----------------------------------------------------------------------
//  DTClip39.dll
//----------------------------------------------------------------------

#define DTC_BASE            0x0240

#define DTCM_Append         (DTC_BASE + 0x00)
#define DTCM_Clip_text      (DTC_BASE + 0x01)
#define DTCM_Title_drops    (DTC_BASE + 0x02)
#define DTCM_New_text       (DTC_BASE + 0x03)
#define DTCM_replaces       (DTC_BASE + 0x04)
#define DTCM_before         (DTC_BASE + 0x05)
#define DTCM_at_cursor      (DTC_BASE + 0x06)
#define DTCM_after          (DTC_BASE + 0x07)
#define DTCM_Separator      (DTC_BASE + 0x08)
#define DTCM_text_sep       (DTC_BASE + 0x09)
#define DTCM_blank_line     (DTC_BASE + 0x0A)
#define DTCM_line_break     (DTC_BASE + 0x0B)
#define DTCM_no_sep         (DTC_BASE + 0x0C)
#define DTCM_Edit           (DTC_BASE + 0x0D)
#define DTCM_Cut            (DTC_BASE + 0x0E)
#define DTCM_Copy           (DTC_BASE + 0x0F)
#define DTCM_Paste          (DTC_BASE + 0x10)
#define DTCM_Paste_apnd     (DTC_BASE + 0x11)
#define DTCM_Delete         (DTC_BASE + 0x12)
#define DTCM_Sel_all        (DTC_BASE + 0x13)
#define DTCM_Desel_all      (DTC_BASE + 0x14)
#define DTCM_Find           (DTC_BASE + 0x15)
#define DTCM_Options        (DTC_BASE + 0x16)
#define DTCM_Word_wrap      (DTC_BASE + 0x17)
#define DTCM_Apnd_drop      (DTC_BASE + 0x18)
#define DTCM_Topmost        (DTC_BASE + 0x19)
#define DTCM_Float          (DTC_BASE + 0x1A)
#define DTCM_Rise           (DTC_BASE + 0x1B)
#define DTCM_Normal         (DTC_BASE + 0x1C)
#define DTCM_Help           (DTC_BASE + 0x1D)

#define DTCV_Clip           (DTC_BASE + 0x20)
#define DTCV_Snip           (DTC_BASE + 0x21)
#define DTCV_Drops          (DTC_BASE + 0x22)
#define DTCV_Paste          (DTC_BASE + 0x23)
#define DTCV_Clear          (DTC_BASE + 0x24)
#define DTCV_No_sep         (DTC_BASE + 0x25)
#define DTCV_Line_break     (DTC_BASE + 0x26)
#define DTCV_Blank_line     (DTC_BASE + 0x27)
#define DTCV_Text_sep       (DTC_BASE + 0x28)
#define DTCV_Before         (DTC_BASE + 0x29)
#define DTCV_Replace        (DTC_BASE + 0x2A)
#define DTCV_After          (DTC_BASE + 0x2B)
#define DTCV_At_cursor      (DTC_BASE + 0x2C)

#define DTCF_Title          (DTC_BASE + 0x30)
#define DTCF_Match_case     (DTC_BASE + 0x31)
#define DTCF_Search_all     (DTC_BASE + 0x32)
#define DTCF_Insert_any     (DTC_BASE + 0x33)
#define DTCF_Find           (DTC_BASE + 0x34)
#define DTCF_Change         (DTC_BASE + 0x35)
#define DTCF_Chg_find       (DTC_BASE + 0x36)
#define DTCF_Chg_all        (DTC_BASE + 0x37)

#define DTC1_Title          (DTC_BASE + 0x40)
#define DTC1_Viewers        (DTC_BASE + 0x41)
#define DTC1_Title_drops    (DTC_BASE + 0x42)
#define DTC1_open_viewer    (DTC_BASE + 0x43)
#define DTC1_Clipboard      (DTC_BASE + 0x44)
#define DTC1_cooperate      (DTC_BASE + 0x45)
#define DTC1_Options        (DTC_BASE + 0x46)
#define DTC1_visibility     (DTC_BASE + 0x47)
#define DTC1_word_wrap      (DTC_BASE + 0x48)
#define DTC1_paste_open     (DTC_BASE + 0x49)
#define DTC1_normal         (DTC_BASE + 0x4A)
#define DTC1_rise           (DTC_BASE + 0x4B)
#define DTC1_float          (DTC_BASE + 0x4C)
#define DTC1_topmost        (DTC_BASE + 0x4D)
#define DTC1_disabled       (DTC_BASE + 0x4E)
#define DTC1_enabled        (DTC_BASE + 0x4F)

#define DTC2_Title          (DTC_BASE + 0x50)
#define DTC2_Apnd_dflts     (DTC_BASE + 0x51)
#define DTC2_View_text      (DTC_BASE + 0x52)
#define DTC2_Drop_text      (DTC_BASE + 0x53)
#define DTC2_Separator      (DTC_BASE + 0x54)
#define DTC2_replace        (DTC_BASE + 0x55)
#define DTC2_after          (DTC_BASE + 0x56)
#define DTC2_at_cursor      (DTC_BASE + 0x57)
#define DTC2_before         (DTC_BASE + 0x58)
#define DTC2_normally       (DTC_BASE + 0x59)
#define DTC2_like_viewer    (DTC_BASE + 0x5A)
#define DTC2_no_sep         (DTC_BASE + 0x5B)
#define DTC2_line_break     (DTC_BASE + 0x5C)
#define DTC2_blank_line     (DTC_BASE + 0x5D)
#define DTC2_text_sep       (DTC_BASE + 0x5E)

#define DTC_LAST            (DTC_BASE + 0x5E)

//----------------------------------------------------------------------
//  DTFile39.dll
//----------------------------------------------------------------------

#define DTF_BASE            0x02A0

#define DTF_Dlg_Title       (DTF_BASE + 0x00)
#define DTF_Page_1of2       (DTF_BASE + 0x01)
#define DTF_Page_2of2       (DTF_BASE + 0x02)
#define DTF_Pg1_Heading     (DTF_BASE + 0x03)
#define DTF_Pg2_Heading     (DTF_BASE + 0x04)
#define DTF_Existing        (DTF_BASE + 0x05)
#define DTF_Separator       (DTF_BASE + 0x06)
#define DTF_Sep_new_line    (DTF_BASE + 0x07)
#define DTF_New_text        (DTF_BASE + 0x08)
#define DTF_New_new_line    (DTF_BASE + 0x09)
#define DTF_do_not_edit     (DTF_BASE + 0x0A)
#define DTF_trail_blank     (DTF_BASE + 0x0B)
#define DTF_trail_white     (DTF_BASE + 0x0C)
#define DTF_lead_blank      (DTF_BASE + 0x0D)
#define DTF_lead_white      (DTF_BASE + 0x0E)
#define DTF_TemplateTitle   (DTF_BASE + 0x0F)

#define DTF_LAST            (DTF_BASE + 0x0F)

//----------------------------------------------------------------------
//  DTPgm39.dll
//----------------------------------------------------------------------

#define DTP_BASE            0x02B0

#define DTPS_Title          (DTP_BASE + 0x00)
#define DTPS_Page_1of2      (DTP_BASE + 0x01)
#define DTPS_Open           (DTP_BASE + 0x02)
#define DTPS_Date           (DTP_BASE + 0x03)
#define DTPS_Time           (DTP_BASE + 0x04)
#define DTPS_Repeat         (DTP_BASE + 0x05)
#define DTPS_days_h_m_s     (DTP_BASE + 0x06)
#define DTPS_Skip_open      (DTP_BASE + 0x07)
#define DTPS_Skip_late      (DTP_BASE + 0x08)
#define DTPS_Now            (DTP_BASE + 0x09)
#define DTPS_Next           (DTP_BASE + 0x0A)
#define DTPS_after          (DTP_BASE + 0x0B)
#define DTPS_on_the         (DTP_BASE + 0x0C)
#define DTPS_every          (DTP_BASE + 0x0D)
#define DTPS_first          (DTP_BASE + 0x0E)
#define DTPS_last           (DTP_BASE + 0x0F)
#define DTPS_day            (DTP_BASE + 0x10)
#define DTPS_Monday         (DTP_BASE + 0x11)
#define DTPS_Tuesday        (DTP_BASE + 0x12)
#define DTPS_Wednesday      (DTP_BASE + 0x13)
#define DTPS_Thursday       (DTP_BASE + 0x14)
#define DTPS_Friday         (DTP_BASE + 0x15)
#define DTPS_Saturday       (DTP_BASE + 0x16)
#define DTPS_Sunday         (DTP_BASE + 0x17)
#define DTPS_weekday        (DTP_BASE + 0x18)
#define DTPS_weekend_day    (DTP_BASE + 0x19)
#define DTPS_week           (DTP_BASE + 0x1A)
#define DTPS_M              (DTP_BASE + 0x1B)
#define DTPS_Tu             (DTP_BASE + 0x1C)
#define DTPS_W              (DTP_BASE + 0x1D)
#define DTPS_Th             (DTP_BASE + 0x1E)
#define DTPS_F              (DTP_BASE + 0x1F)
#define DTPS_Sa             (DTP_BASE + 0x20)
#define DTPS_Su             (DTP_BASE + 0x21)
#define DTPS_Ordinals       (DTP_BASE + 0x22)
#define DTPS_OfTheMonth     (DTP_BASE + 0x23)
#define DTPS_RepeatAfter    (DTP_BASE + 0x24)
#define DTPS_RepeatOnThe    (DTP_BASE + 0x25)
#define DTPS_RepeatEvery    (DTP_BASE + 0x26)
#define DTPS_Repeat1stLast  (DTP_BASE + 0x27)
#define DTPS_RepeatIsOff    (DTP_BASE + 0x28)
#define DTPS_CantIdentify   (DTP_BASE + 0x29)
#define DTPS_ExtraRec       (DTP_BASE + 0x2A)
#define DTPS_MissingRec     (DTP_BASE + 0x2B)
#define DTPS_Template       (DTP_BASE + 0x2C)
#define DTPS_Mismatch       (DTP_BASE + 0x2D)
#define DTPS_CantSched      (DTP_BASE + 0x2E)
#define DTPS_InvalidDate    (DTP_BASE + 0x2F)
#define DTPS_InvalidRepeat  (DTP_BASE + 0x30)
#define DTPS_FutureNeeded   (DTP_BASE + 0x31)
#define DTPS_Add20Secs      (DTP_BASE + 0x32)
#define DTPS_DateWithin4    (DTP_BASE + 0x33)

#define DTPS2_Page_2of2     (DTP_BASE + 0x40)
#define DTPS2_Heading       (DTP_BASE + 0x41)
#define DTPS2_Edit          (DTP_BASE + 0x42)
#define DTPS2_ObjTitle      (DTP_BASE + 0x43)
#define DTPS2_Date          (DTP_BASE + 0x44)
#define DTPS2_Time          (DTP_BASE + 0x45)
#define DTPS2_retrieve_err  (DTP_BASE + 0x46)
#define DTPS2_waiting       (DTP_BASE + 0x47)
#define DTPS2_no_objects    (DTP_BASE + 0x48)
#define DTPS2_display_err   (DTP_BASE + 0x49)
#define DTPS2_invalid_obj   (DTP_BASE + 0x4A)

#define DTPO_Title          (DTP_BASE + 0x50)
#define DTPO_Object_ID      (DTP_BASE + 0x51)
#define DTPO_Set            (DTP_BASE + 0x52)
#define DTPO_Info1          (DTP_BASE + 0x53)
#define DTPO_Info2          (DTP_BASE + 0x54)
#define DTPO_DnD_History    (DTP_BASE + 0x55)
#define DTPO_Maintain       (DTP_BASE + 0x56)
#define DTPO_Clear          (DTP_BASE + 0x57)
#define DTPO_Multi_File     (DTP_BASE + 0x58)
#define DTPO_change_dir     (DTP_BASE + 0x59)
#define DTPO_ID_assigned    (DTP_BASE + 0x5A)
#define DTPO_Are_you_sure   (DTP_BASE + 0x5B)

#define DTPE_Title          (DTP_BASE + 0x60)
#define DTPE_Heading        (DTP_BASE + 0x61)
#define DTPE_Info1          (DTP_BASE + 0x62)
#define DTPE_Info2          (DTP_BASE + 0x63)
#define DTPE_Invalid        (DTP_BASE + 0x64)

#define DTPJ_Title          (DTP_BASE + 0x65)
#define DTPJ_Heading        (DTP_BASE + 0x66)
#define DTPJ_Info           (DTP_BASE + 0x67)

#define DTPP_freeware       (DTP_BASE + 0x68)
#define DTPP_Copyright      (DTP_BASE + 0x69)
#define DTPP_email          (DTP_BASE + 0x6A)
#define DTPP_TranslatedBy   (DTP_BASE + 0x6B)

#define DTP_LAST            (DTP_BASE + 0x6B)

//----------------------------------------------------------------------
//  DTSetup.exe
//----------------------------------------------------------------------

#define DTS_BASE            0x0320

// Setup (main) dialog
#define DTSS_Title          (DTS_BASE + 0x00)
#define DTSS_Paths          (DTS_BASE + 0x01)
#define DTSS_Source         (DTS_BASE + 0x02)
#define DTSS_Dest           (DTS_BASE + 0x03)
#define DTSS_Startup        (DTS_BASE + 0x04)
#define DTSS_LoadInfo       (DTS_BASE + 0x05)
#define DTSS_autoload       (DTS_BASE + 0x06)
#define DTSS_start_fldr     (DTS_BASE + 0x07)
#define DTSS_manually       (DTS_BASE + 0x08)
#define DTSS_WPS_Classes    (DTS_BASE + 0x09)
#define DTSS_ClassInfo      (DTS_BASE + 0x0A)
#define DTSS_DTFileInfo     (DTS_BASE + 0x0B)
#define DTSS_DTClipInfo     (DTS_BASE + 0x0C)
#define DTSS_DTPgmInfo      (DTS_BASE + 0x0D)
#define DTSS_Inst_btn       (DTS_BASE + 0x0E)
#define DTSS_Uninst_btn     (DTS_BASE + 0x0F)
#define DTSS_Cancel_btn     (DTS_BASE + 0x10)

// Setup popup messages
#define DTSSM_Expired       (DTS_BASE + 0x11)

// Install progress dialog
#define DTSI_Title          (DTS_BASE + 0x12)
#define DTSI_Status         (DTS_BASE + 0x13)
#define DTSI_Close_btn      (DTS_BASE + 0x14)
#define DTSI_Validating     (DTS_BASE + 0x15)
#define DTSI_Proc_Files     (DTS_BASE + 0x16)
#define DTSI_Set_Startup    (DTS_BASE + 0x17)
#define DTSI_Proc_Objects   (DTS_BASE + 0x18)
#define DTSI_Update_Ini     (DTS_BASE + 0x19)
#define DTSI_InstOK         (DTS_BASE + 0x1A)
#define DTSI_Inst_Nonfatal  (DTS_BASE + 0x1B)
#define DTSI_Startup_Obj    (DTS_BASE + 0x1C)
#define DTSI_Warning        (DTS_BASE + 0x20)
#define DTSI_MB2            (DTS_BASE + 0x21)
#define DTSI_Running        (DTS_BASE + 0x22)
#define DTSI_Delete_object  (DTS_BASE + 0x23)
#define DTSI_BasicInfo1     (DTS_BASE + 0x24)
#define DTSI_BasicInfo2     (DTS_BASE + 0x25)
#define DTSI_BasicInfo3     (DTS_BASE + 0x26)
#define DTSI_Trial1         (DTS_BASE + 0x27)
#define DTSI_Trial2         (DTS_BASE + 0x28)
#define DTSI_Trial3         (DTS_BASE + 0x29)
#define DTSI_Beta1          (DTS_BASE + 0x2A)
#define DTSI_Beta2          (DTS_BASE + 0x2B)

// Install popup messages
#define DTSIM_InstMinor     (DTS_BASE + 0x30)
#define DTSIM_PressClose    (DTS_BASE + 0x31)
#define DTSIM_Internal      (DTS_BASE + 0x32)
#define DTSIM_OK_continue   (DTS_BASE + 0x33)
#define DTSIM_Fatal         (DTS_BASE + 0x34)
#define DTSIM_OK_close      (DTS_BASE + 0x35)
#define DTSIM_IsWPS         (DTS_BASE + 0x36)
#define DTSIM_WPS_Yes_No    (DTS_BASE + 0x37)
#define DTSIM_UTLSrcPath    (DTS_BASE + 0x38)
#define DTSIM_UTLDstPath    (DTS_BASE + 0x39)
#define DTSIM_SpaceInPath   (DTS_BASE + 0x3A)
#define DTSIM_UTLReqSrc     (DTS_BASE + 0x3B)
#define DTSIM_BadReqSrc     (DTS_BASE + 0x3C)
#define DTSIM_PleaseFix     (DTS_BASE + 0x3D)
#define DTSIM_UTLOptSrc     (DTS_BASE + 0x3E)
#define DTSIM_BadOptSrc     (DTS_BASE + 0x3F)
#define DTSIM_Continue      (DTS_BASE + 0x40)
#define DTSIM_NotDeld       (DTS_BASE + 0x41)
#define DTSIM_ClassNotReg   (DTS_BASE + 0x42)
#define DTSIM_NoDTClipObj   (DTS_BASE + 0x43)
#define DTSIM_NoInstall     (DTS_BASE + 0x44)
#define DTSIM_StartObj      (DTS_BASE + 0x45)
#define DTSIM_DeskObj       (DTS_BASE + 0x46)
#define DTSIM_UseDTNotebook (DTS_BASE + 0x47)


// Uninstall dialog
#define DTSU_Title          (DTS_BASE + 0x50)
#define DTSU_Remove         (DTS_BASE + 0x51)
#define DTSU_Start_opts     (DTS_BASE + 0x52)
#define DTSU_Desktop        (DTS_BASE + 0x53)
#define DTSU_os2_ini        (DTS_BASE + 0x54)
#define DTSU_Files          (DTS_BASE + 0x55)
#define DTSU_Only_items     (DTS_BASE + 0x56)
#define DTSU_Reboot         (DTS_BASE + 0x57)
#define DTSU_WPS_class      (DTS_BASE + 0x58)

// Uninstall popup messages
#define DTSUM_AreYouSure    (DTS_BASE + 0x60)
#define DTSUM_UninstOK      (DTS_BASE + 0x61)
#define DTSUM_Must_Reboot   (DTS_BASE + 0x62)
#define DTSUM_UninstErr     (DTS_BASE + 0x63)
#define DTSUM_CouldntDel    (DTS_BASE + 0x64)
#define DTSUM_ReinstDTPgm1  (DTS_BASE + 0x65)
#define DTSUM_ReinstDTPgm2  (DTS_BASE + 0x66)
#define DTSUM_CantDereg     (DTS_BASE + 0x68)

#define DTS_LAST            (DTS_BASE + 0x68)

//----------------------------------------------------------------------

#endif  // dtnls_h

//----------------------------------------------------------------------

