/***************************************************************************/
/* F r e e C o d e                                                         */
/*                                                                         */
/* THIS CODE IS FREEWARE AND AS SUCH YOU ARE PERMITTED TO DO WHAT YOU WISH */
/* WITH IT. THESE PROGRAMS ARE PROVIDED AS IS WITHOUT ANY WARRANTY,        */
/* EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO FITNESS FOR ANY      */
/* PARTICULAR PURPOSE.                                                     */
/*                                                                         */
/* However, we would appriciate if you shared any enhancements to us       */
/* Please send them to www.jmast.se/free/ and we will include them in      */
/* future distributions.                                                   */
/*                                                                         */
/***************************************************************************/
/****************************************************************************

     Modul:      JC.CPP, WarpCenter replacement

     Version:    0.360

     Tid:        000726, 001111, 49h

-------------------------------------------------------------------------
   000726: Started with faktura.cpp as "template". (MA, 1h)
-------------------------------------------------------------------------
   000807: Lots, lots and lots. (MA, 30h)
-------------------------------------------------------------------------
   000807: More... (MA, 8h)
-------------------------------------------------------------------------
   000812: Added place for appbar and moved menubars (MA, 5h)
-------------------------------------------------------------------------
   000823: Without WC JMAcenter would not show up !! (MA, 1h)
-------------------------------------------------------------------------
   000924: Better task update control  !! (MA, 1h)
-------------------------------------------------------------------------
   001027: Added support for hook DLL (MA, 1h)
-------------------------------------------------------------------------
   001111: Changed menu to normal menu, reversed task order and added
           ignore file (temporary as textfile).
-------------------------------------------------------------------------
****************************************************************************/
#define PROG_VERSION   "0.360 - November 11, 2000"

#define INCL_WINWORKPLACE
#define INCL_DOS
#define INCL_WIN
#define INCL_GPI

#define OPEN_DEFAULT    0
#define OPEN_SETTINGS   2
//#define OPEN_TREE       2
//#define OPEN_CONTENTS   3
//#define OPEN_DETAILS    4


#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <stlibpmc.h>
#include <stlibstc.h>

#include "jc.h"
#include "dialog.h"




/* Puts all shared variables into
   the APPLICATION strucure. */

APPLICATION     app;
char            szDebug[512];
char            szDebug2[512];

/*-----------------------------------------------------------------------------
   main: Entrypoint into this program.                               930928
-----------------------------------------------------------------------------*/
int main  (int argc, char *argv[])
     {
     static CHAR szClassName [] = "JmaCenter 0.001, FreeCode";
     HMQ         hmq;
     QMSG        qmsg;

     char        szMessage[255];

     ULONG       flFrameFlags;
     ULONG       yIcon, ySize, iTBHeight;
     RECTL       rcl, rclWC;



     memset(&app, 0, sizeof(APPLICATION));

ReadSettings(NULL);

     app.hab = WinInitialize(0);
     hmq = WinCreateMsgQueue(app.hab, 0);

     WinRegisterClass(app.hab, szClassName, ClientWndProc, CS_SIZEREDRAW, 0);

     flFrameFlags = FCF_TASKLIST | FCF_BORDER | FCF_ICON;

     app.hwndFrame = WinCreateStdWindow (HWND_DESKTOP, 0, &flFrameFlags, szClassName,
                                         "JMACenter", WS_VISIBLE, NULLHANDLE, ID_RESOURCE, (PHWND) &app.hwndClient) ;

     app.hwndWC = WinQueryWarpCenterHwnd(app.hwndClient);
     app.hwndDesktop = WinQueryDesktopWindow(app.hab, NULLHANDLE);

     app.hbmLogo = WinLoadBitmap(NULLHANDLE, ID_BITMAP_JCLOGO, 0, 0);
     app.hbmSwitch = WinLoadBitmap(NULLHANDLE, ID_BITMAP_SWITCH, 0, 0);

     IconSize (NULL, &yIcon);
     iTBHeight = (yIcon / 2) + (TB_BORDERSPACE * 6);
     app.hwndTaskBar = TaskBarCreate(app.hwndClient, &app.tb, iTBHeight);

     WinQueryWindowRect(HWND_DESKTOP, &rcl);
     rcl.yBottom = rcl.yTop - iTBHeight;

     WinCalcFrameRect(app.hwndFrame, &rcl, FALSE);

     ySize = rcl.yTop - rcl.yBottom;
     WinQueryWindowRect(HWND_DESKTOP, &rcl);

     if (app.hwndWC != NULLHANDLE)
        {
        WinQueryWindowRect(app.hwndWC, &rclWC);
        }
     else
        {
        rclWC.yTop = 0;
        }

     WinSetWindowPos(app.hwndFrame, HWND_TOP, rcl.xLeft, rclWC.yTop, (rcl.xRight - rcl.xLeft), ySize,
                     SWP_SHOW | SWP_MOVE | SWP_SIZE | SWP_ZORDER);

     STButtonCreate(app.hwndClient, &app.btn, 1, STBTN_BITMAP, TRUE);
     STButtonSetFrameStyle(&app.btn, STBTN_FRAME3D);
     STButtonSetBitmap(&app.btn, app.hbmLogo, STBTN_STRECH);
     STButtonSetHover(&app.btn, "Open menu", HOVER_ABOVE);
     STButtonSetColor(&app.btn, CLR_BLACK, CLR_PALEGRAY);
     STButtonSetState(&app.btn, STBTN_ENABLED);
     STButtonShow(&app.btn, TRUE);

     STButtonCreate(app.hwndClient, &app.btnSwitch1, 2, STBTN_BITMAP, FALSE);
     STButtonSetFrameStyle(&app.btnSwitch1, STBTN_FRAMENONE);
     STButtonSetBitmap(&app.btnSwitch1, app.hbmSwitch, STBTN_CENTER);
     STButtonSetColor(&app.btnSwitch1, CLR_BLACK, CLR_PALEGRAY);
     STButtonSetState(&app.btnSwitch1, STBTN_ENABLED);
     STButtonShow(&app.btnSwitch1, TRUE);

     STButtonCreate(app.hwndClient, &app.btnSwitch2, 3, STBTN_BITMAP, FALSE);
     STButtonSetFrameStyle(&app.btnSwitch2, STBTN_FRAMENONE);
     STButtonSetBitmap(&app.btnSwitch2, app.hbmSwitch, STBTN_CENTER);
     STButtonSetColor(&app.btnSwitch2, CLR_BLACK, CLR_PALEGRAY);
     STButtonSetState(&app.btnSwitch2, STBTN_ENABLED);
     STButtonShow(&app.btnSwitch2, TRUE);

     STButtonCreate(app.hwndClient, &app.btnDT, 5, STBTN_DATETIME, TRUE);
     STButtonSetFrameStyle(&app.btnDT, STBTN_FRAME3D);
     STButtonSetHover(&app.btnDT, NULL, HOVER_ABOVE);
     STButtonSetColor(&app.btnDT, CLR_BLACK, CLR_PALEGRAY);
     STButtonSetPopupMenu(&app.btnDT, TRUE, NULLHANDLE, ID_MENUCLOCK);
     STButtonSetState(&app.btnDT, STBTN_HIGHLITED);
     STButtonShow(&app.btnDT, TRUE);

     ReadSwitchList();

     SizeControls(app.hwndClient);

     JCSetDLL(app.hwndClient);

     JCSetMaxFrame(FALSE, ySize);

     while (WinGetMsg (app.hab, &qmsg, (ULONG) NULL, 0L, 0L))
           WinDispatchMsg (app.hab, &qmsg) ;

     JCSetDLL(NULLHANDLE);

     STButtonDestroy(&app.btnDT);
     STButtonDestroy(&app.btn);

     TaskBarDestroy(&app.tb);
     GpiDeleteBitmap(app.hbmLogo);

     WinDestroyWindow (app.hwndFrame) ;

     WinDestroyMsgQueue (hmq) ;
     WinTerminate (app.hab) ;
     return (0);
     }


/*-----------------------------------------------------------------------------
   ClientWndProc: Handles messages for the (covered) client window.
-----------------------------------------------------------------------------*/
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     static HWND        hwndBtn;
     static ULONG       yLed, xLed;
     static BOOL        bIsProcessing = FALSE;
     HWND               hwndFileDlg, hwndMenu;
     HPS                hps;
     char               buffer[80];
     RECTL              rcl, rclLogo;
     char               szSql[1024];
     char               szMessage[255];

     unsigned short     rc;
     char               szBuffer[256];
     time_t             ltime;
     struct tm          *curtime;

     HOBJECT            hObject;

     PVOID 		pvMemJC = NULL;

     POINTL             ptl;
     ULONG              flOptions;




     switch (msg)
          {
          case WM_CREATE:
               WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, IDT_TUPDATE, TB_TIMEOUT);
               strcpy(szBuffer, TB_FONT_APPLICATION);
               WinSetPresParam(hwnd, PP_FONTNAMESIZE, (ULONG)strlen(szBuffer) + 1, (PVOID)&szBuffer);
               WinSetVisibleRegionNotify(hwnd, TRUE);
               break;

          case WM_SIZE:
               SizeControls(hwnd);
               break;

          case WM_TASKBARSELECT:
               WinShowWindow((HWND) mp2, TRUE);
               WinSwitchToProgram((HSWITCH) mp1);
               break;

          case WM_STBUTTONCLICK:
               switch ((int)mp1)
                      {
                      case 1:        
                           WinQueryWindowRect(app.hwndFrame, &rcl);
                           ptl.y = rcl.yTop;
                           ptl.x = rcl.xLeft;
                           WinMapWindowPoints(HWND_DESKTOP, app.hwndFrame, &ptl, 0);
                           flOptions = PU_KEYBOARD | PU_MOUSEBUTTON1 | PU_HCONSTRAIN | PU_VCONSTRAIN;
                           WinPopupMenu(app.hwndFrame, hwnd, WinLoadMenu(hwnd, NULLHANDLE, ID_MENUMENU), ptl.x, ptl.y, 0, (USHORT) flOptions);
                           break;
                      }
               break;

          case WM_TIMER:
               ReadSwitchList();
               break;

          case WM_PAINT:
               hps = WinBeginPaint (hwnd, 0L, 0L);
               WinQueryWindowRect(hwnd, &rcl);
               WinFillRect(hps, &rcl, TB_COLOR_BACKGROUND);
               WinEndPaint (hps);
               break;

               case WM_COMMAND:
                    switch (SHORT1FROMMP(mp1))
                           {
                           case IDM_MNU_DESKTOP:
                                hObject = WinQueryObject("<WP_DESKTOP>");
                                WinOpenObject(hObject, OPEN_DEFAULT, TRUE);
                                break;

                           case IDM_MNU_CONNECTIONS:
                                hObject = WinQueryObject("<WP_CONNECTIONSFOLDER>");
                                WinOpenObject(hObject, OPEN_DEFAULT, TRUE);
                                break;

                           case IDM_MNU_SETUP:
                                hObject = WinQueryObject("<WP_CONFIG>");
                                WinOpenObject(hObject, OPEN_DEFAULT, TRUE);
                                break;

                           case IDM_MNU_PRINTER:
                                hObject = WinQueryObject("<WP_PRINTERSFOLDER>");
                                WinOpenObject(hObject, OPEN_DEFAULT, TRUE);
                                break;

                           case IDM_MNU_SHUTDOWN:                              
                                hObject = WinQueryObject("<XWP_XSHUTDOWN>");
                                WinOpenObject(hObject, OPEN_DEFAULT, TRUE);
                                break;

                           case IDM_SETCLOCK:
                                hObject = WinQueryObject("<WP_CLOCK>");
                                WinOpenObject(hObject, OPEN_SETTINGS, TRUE);
                                break;

                           case IDM_CLOSE:
                                WinSendMsg(app.hwndClient, WM_CLOSE, NULL, NULL);
                                break;

                           case IDM_ABOUT:
                                WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP) AboutDlgProc, NULL, DLG_ABOUT, 0);
                                break;

                           default:
                                return WinDefWindowProc(hwnd, msg, mp1, mp2);
                           }
                    break;

          case WM_CLOSE:
               WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, IDT_TUPDATE);
               WinPostMsg(hwnd, WM_QUIT, NULL, NULL);
               break;

          case WM_DESTROY:
               WinSetVisibleRegionNotify(hwnd, FALSE);
               break;

          default:
               return WinDefWindowProc (hwnd, msg, mp1, mp2);
          }
     return FALSE;
     }


/*-----------------------------------------------------------------------------
   SizeControls: Redraw controls when windowsize changes.
-----------------------------------------------------------------------------*/
void SizeControls(HWND hwnd)
     {
     RECTL              rcl, rclUse;
     int                x1, x2;
     ULONG              ulFontWidth, ulFontHeight;


     WinQueryWindowRect(hwnd, &rcl);
     x1 = DrawBarMenu(NULLHANDLE, TRUE, rcl);
     x2 = DrawBarClock(NULLHANDLE, TRUE, rcl);

     rclUse.xLeft = x1;
     rclUse.xRight = (x2 / 3) * 2;
     rclUse.yBottom = rcl.yBottom;
     rclUse.yTop = rcl.yTop;
     DrawBarApps(NULLHANDLE, TRUE, rclUse);

     rclUse.xLeft = (x2 / 3) * 1;
     rclUse.xRight = rclUse.xLeft + ((x2 / 3) * 2);
     rclUse.yBottom = rcl.yBottom;
     rclUse.yTop = rcl.yTop;
     DrawBarTask(NULLHANDLE, TRUE, rclUse);

     }


/*-----------------------------------------------------------------------------
   DrawBarMenu: Draw or calc size of Menu"button".
-----------------------------------------------------------------------------*/
int DrawBarMenu(HPS hps, BOOL bDraw, RECTL rclClient)
    {
    RECTL               rcl, rclNew;
    ULONG               xIcon;


    IconSize (&xIcon, NULL);

    rcl.xLeft = TB_BORDERSPACE;
    rcl.yBottom = TB_BORDERSPACE;
    rcl.xRight = xIcon + TB_BORDERSPACE;
    rcl.yTop = rclClient.yTop - TB_BORDERSPACE;

    if (bDraw == TRUE)
       STButtonReSize(&app.btn, rcl);


    return(rcl.xRight);
    }


/*-----------------------------------------------------------------------------
   DrawBarApps: Draw or calc size of Appbar.
-----------------------------------------------------------------------------*/
int DrawBarApps(HPS hps, BOOL bDraw, RECTL rclClient)
    {
    RECTL       rcl;
    ULONG       xIcon;


    IconSize (&xIcon, NULL);
    rcl.xLeft = rclClient.xLeft + (TB_BORDERSPACE * 2);
    rcl.yBottom = TB_BORDERSPACE;
    rcl.xRight = rcl.xLeft + (xIcon / 2) + TB_BORDERSPACE;
    rcl.yTop = rclClient.yTop - TB_BORDERSPACE;

    if (bDraw == TRUE)
       STButtonReSize(&app.btnSwitch1, rcl);

    return (0);
    }


/*-----------------------------------------------------------------------------
   DrawBarTask: Draw or calc size of Taskbar.
-----------------------------------------------------------------------------*/
int DrawBarTask(HPS hps, BOOL bDraw, RECTL rclClient)
    {
    RECTL       rcl;
    ULONG       xIcon;


    IconSize (&xIcon, NULL);
    rcl.xLeft = rclClient.xLeft + (TB_BORDERSPACE * 2);
    rcl.yBottom = TB_BORDERSPACE;
    rcl.xRight = rcl.xLeft + (xIcon / 2) + TB_BORDERSPACE;
    rcl.yTop = rclClient.yTop - TB_BORDERSPACE;

    if (bDraw == TRUE)
       STButtonReSize(&app.btnSwitch2, rcl);

    TaskBarRedraw(&app.tb, rcl.xRight, rclClient.xRight - TB_BORDERSPACE);
    return (0);
    }


/*-----------------------------------------------------------------------------
   DrawBarClock: Draw or calc size of clock/systray.
-----------------------------------------------------------------------------*/
int DrawBarClock(HPS hps, BOOL bDraw, RECTL rclClient)
    {
    RECTL       rcl, rclNew;
    ULONG       ulFontWidth, ulFontHeight;


    QueryFontSize(app.hwndClient, &ulFontWidth, &ulFontHeight);

    rcl.xLeft = rclClient.xRight - ((6 * ulFontWidth) + (TB_BORDERSPACE * 4));
    rcl.yBottom = TB_BORDERSPACE;
    rcl.xRight = rclClient.xRight;
    rcl.yTop = rclClient.yTop - TB_BORDERSPACE;

    if (bDraw == TRUE)
       STButtonReSize(&app.btnDT, rcl);

    return(rcl.xLeft);
    }


/*-----------------------------------------------------------------------------
   ReadSwitchList: Reads switchlist and updates TaskBar
-----------------------------------------------------------------------------*/
void ReadSwitchList(void)
     {
     static int     iLastNumItems = 0;
     int            iNumItems, iCounter, iInner, iItems;
     BOOL           bFound = FALSE;
     BOOL           bShow;
     PVOID          pBuffer;
     PSWBLOCK       pSB;


     iNumItems = WinQuerySwitchList(app.hab, NULL, 0);

     pBuffer = malloc((iNumItems * sizeof(SWENTRY)) + sizeof(HSWITCH));
     WinQuerySwitchList(app.hab, (SWBLOCK*)pBuffer, (iNumItems * sizeof(SWENTRY)) + sizeof(HSWITCH));

     pSB = (PSWBLOCK)(pBuffer);

     if (iLastNumItems == iNumItems)
        {
        for (iCounter = 0; iCounter < app.tb.usItemCount; iCounter++)
            {
            bFound = FALSE;
            for (iInner = 0; iInner < app.tb.usItemCount; iInner++)
                {
                if (pSB->aswentry[iInner].swctl.idSession == app.tb.pTaskItems[iCounter].pidItem)
                   bFound = TRUE;
                }
            if (bFound == FALSE)
               {
               iLastNumItems = iNumItems;
               free(pBuffer);
               return;
               }
            }
        }

     iLastNumItems = iNumItems;

     if (app.tb.pTaskItems != NULL)
        TaskBarItemRemoveAll(&app.tb);

     iItems = 0;
     for (iCounter = iNumItems - 1; iCounter >= 0; iCounter-- )
         {
         if (pSB->aswentry[iCounter].swctl.fbJump == SWL_JUMPABLE && pSB->aswentry[iCounter].swctl.uchVisibility == SWL_VISIBLE)
            {
            bShow = TRUE;

            // Dont show ourselves
            if (pSB->aswentry[iCounter].swctl.hwnd == app.hwndFrame)
               bShow = FALSE;

            // Dont show WarpCenter
            if (pSB->aswentry[iCounter].swctl.hwnd == app.hwndWC)
               bShow = FALSE;


// Check for removed apps, using part of windows title, or rather
// compare the amount of chars in the ignore with existing

            // Dont show if excluded
            if (IsWindowExcluded(pSB->aswentry[iCounter].swctl.szSwtitle))
               bShow = FALSE;


            if (bShow == TRUE)
               {
               TaskBarItemAdd(&app.tb, pSB->aswentry[iCounter].swctl.hwnd,
                                       pSB->aswentry[iCounter].swctl.idSession,
                                       pSB->aswentry[iCounter].hswitch,
                                       pSB->aswentry[iCounter].swctl.bProgType,
                                       pSB->aswentry[iCounter].swctl.szSwtitle);
               }

            }
         }
     free(pBuffer);

     SizeControls(app.hwndClient);
     }


/*-----------------------------------------------------------------------------
   IsWindowExcluded: Checks to see if hwnd is to be excluded from tb.
-----------------------------------------------------------------------------*/
BOOL IsWindowExcluded(char *szWndTitle)
     {
     int        iCounter;


     for (iCounter = 0; iCounter < app.aset.iNumIgnoreTitle; iCounter++) 
         {
         if ( strncmp(app.aset.szIgnoreTitle[iCounter], szWndTitle, strlen(app.aset.szIgnoreTitle[iCounter])) == 0)
            return (TRUE);
         }
     return (FALSE);
     }


/*-----------------------------------------------------------------------------
   ReadSettings: Should read JC.INI, now uses ascii text file.
-----------------------------------------------------------------------------*/
void ReadSettings(char *szIniFile)
     {
     char       szUseIniFile[_MAX_PATH];
     char       szBuffer[256];
     FILE	*stream;
     int        iAntal;


     if (szIniFile == NULL)
        strcpy(szUseIniFile, "JC.INI");
     else
        strcpy(szUseIniFile, szIniFile);

     if ( !(stream = fopen(szUseIniFile, "r")) )
        return;

     app.aset.iNumIgnoreTitle = 0;
     while (!feof(stream))
           {
           fgets(szBuffer, 255, stream);
           szBuffer[strlen(szBuffer) - 1] = '\0';
           if (strlen(szBuffer) > 0)
              {
              strcpy(app.aset.szIgnoreTitle[app.aset.iNumIgnoreTitle], szBuffer);
              app.aset.iNumIgnoreTitle++;
              }
           }
      
     fclose(stream);
     }


/*------------------------------------------------------------------------------
   AboutDlgProc: Handles messages for the DLG_ABOUT dialog.
-----------------------------------------------------------------------------*/
MRESULT EXPENTRY AboutDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     static STCONTROL   stctrl;
     HWND               hwndAnimate;
     RECTL              rclClient;
     char               szBuffer[256];
     char               szBuffer2[32];
     int                usVersion;


     switch (msg)
            {
            case WM_INITDLG:
                 hwndAnimate = WinWindowFromID(hwnd, DID_ABOUTLINE1);
                 WinQueryWindowRect(hwndAnimate, &rclClient);
                 CreateControl(hwndAnimate, &stctrl, IDSTCTRL_ANIMATE, 1, 111, 0, TRUE, 8);
                 ControlSetItem(&stctrl, 0, 1, IDSTCTRL_SUB_TEXT, NULL, NULLHANDLE, "JmaCenter 0.1                ", CLR_RED, CLR_PALEGRAY, "");
                 ControlSetItem(&stctrl, 1, 1, IDSTCTRL_SUB_TEXT, NULL, NULLHANDLE, "    JmaCenter 0.1            ", CLR_RED, CLR_PALEGRAY, "");
                 ControlSetItem(&stctrl, 2, 1, IDSTCTRL_SUB_TEXT, NULL, NULLHANDLE, "        JmaCenter 0.1        ", CLR_RED, CLR_PALEGRAY, "");
                 ControlSetItem(&stctrl, 3, 1, IDSTCTRL_SUB_TEXT, NULL, NULLHANDLE, "            JmaCenter 0.1    ", CLR_RED, CLR_PALEGRAY, "");
                 ControlSetItem(&stctrl, 4, 1, IDSTCTRL_SUB_TEXT, NULL, NULLHANDLE, "                JmaCenter 0.1", CLR_RED, CLR_PALEGRAY, "");
                 ControlSetItem(&stctrl, 5, 1, IDSTCTRL_SUB_TEXT, NULL, NULLHANDLE, "            JmaCenter 0.1    ", CLR_RED, CLR_PALEGRAY, "");
                 ControlSetItem(&stctrl, 6, 1, IDSTCTRL_SUB_TEXT, NULL, NULLHANDLE, "        JmaCenter 0.1        ", CLR_RED, CLR_PALEGRAY, "");
                 ControlSetItem(&stctrl, 7, 1, IDSTCTRL_SUB_TEXT, NULL, NULLHANDLE, "    JmaCenter 0.1            ", CLR_RED, CLR_PALEGRAY, "");
                 ControlSetFont(&stctrl, "18.Helv");
                 AnimateSetTimerTicks(&stctrl, 200);
                 AnimateSetTimerId(&stctrl, 100);
                 AnimateStart(&stctrl);
                 ControlResize(&stctrl, rclClient.yBottom, rclClient.xLeft, rclClient.yTop - rclClient.yBottom, rclClient.xRight - rclClient.xLeft);

                 WinSetDlgItemText(hwnd, DID_ABOUTLINE2, "JmaCenter 0.001");
                 WinSetDlgItemText(hwnd, DID_ABOUTLINE3, PROG_VERSION);

                 WinCenterWindow(hwnd);
                 return (0);

            case WM_COMMAND:
                 switch (SHORT1FROMMP(mp1))
                        {
                        case DID_OK:
                             AnimateStop(&stctrl);
                             DestroyControl(&stctrl);
                             WinDismissDlg(hwnd, TRUE);
                             break;
                        }
                 break;

            default:
                 return (WinDefDlgProc (hwnd, msg, mp1, mp2));
            }
     return (FALSE);
     }


/*-----------------------------------------------------------------------------
   LogMsg: Logs error messages to file.
-----------------------------------------------------------------------------*/
void LogMsg(char *szMessage)
     {
     FILE               *streamLog;
     char               szText[1024];
     time_t             ltime;
     struct tm          *curtime;
     ERRORID            erridLast;
     char               szSevere[50];
     int                iSeverity = 0, iErrorNo = 0;


     sprintf(szText, "%s\\DEBUG.TXT", GetExeDir());
     streamLog = fopen(szText, "a");

     time(&ltime);
     curtime = localtime(&ltime);

     sprintf(szText, "%.4d-%.2d-%.2d %.2d:%.2d:%.2d", 1900 + curtime->tm_year, curtime->tm_mon + 1, curtime->tm_mday, curtime->tm_hour, curtime->tm_min, curtime->tm_sec);
     fprintf(streamLog, "%s\n", szText);

     erridLast = WinGetLastError(app.hab);
     iSeverity = ERRORIDSEV(erridLast);
     iErrorNo = ERRORIDERROR(erridLast);

      switch (iSeverity)
             {
             case SEVERITY_NOERROR:
                  sprintf(szSevere, "SEVERITY_NOERROR");
                  break;

             case SEVERITY_WARNING:
                  sprintf(szSevere, "SEVERITY_WARNING");
                  break;

             case SEVERITY_ERROR:
                  sprintf(szSevere, "SEVERITY_ERROR");
                  break;

             case SEVERITY_SEVERE:
                  sprintf(szSevere, "SEVERITY_SEVERE");
                  break;

             case SEVERITY_UNRECOVERABLE:
                  sprintf(szSevere, "SEVERITY_UNRECOVERABLE");
                  break;
             }

     sprintf(szText, "%s err = %x\n",  szSevere, iErrorNo);
     fprintf(streamLog, "%s\n", szText);
     fprintf(streamLog, "%s\n", szMessage);
     fprintf(streamLog, "\n");

     fclose(streamLog);
     }


/*************************************************************************************
  TaskBarCreate: Creates Taskbar main window.
*************************************************************************************/
HWND TaskBarCreate(HWND hwndOwner, PSTTASKBAR pTaskBar, int iHeight)
     {
     static BOOL        bIsClassRegistered = 0;
     PSZ                pszClass = "TaskBarClass";
     int                iCounter;
     ULONG              flFlags;


     if (!bIsClassRegistered)
        {
        WinRegisterClass(WinQueryAnchorBlock(hwndOwner), pszClass, (PFNWP)TaskBarWndProc, CS_SIZEREDRAW | CS_SYNCPAINT, 4);
        bIsClassRegistered = TRUE;
        }

     flFlags = FCF_BORDER | FCF_NOBYTEALIGN | WS_SYNCPAINT;

     pTaskBar->hwndTaskBar = WinCreateWindow(hwndOwner, pszClass, (PSZ)NULL, flFlags, 0, 0, 0, 0, hwndOwner, HWND_TOP, 0, NULL, NULL);

     WinSetWindowPtr(pTaskBar->hwndTaskBar, 0, pTaskBar);

     pTaskBar->hwndOwner = hwndOwner;
     pTaskBar->usItemCount = 0;
     pTaskBar->bShow = TRUE;
     pTaskBar->iHeight = iHeight;
     pTaskBar->hwndBtnCurrent = NULLHANDLE;

     CreateHoverBox(HWND_DESKTOP, &pTaskBar->hb);
     SetHoverBoxFont(&pTaskBar->hb, TB_FONT_HOVER);
     SetHoverBoxColor(&pTaskBar->hb, TB_COLOR_HOVERFOREGROUND, TB_COLOR_HOVERBACKGROUND);
     SetHoverBoxAlignment(&pTaskBar->hb, HOVER_CENTER);
     SetHoverBoxMotion(&pTaskBar->hb, FALSE);
     SetHoverBoxPosition(&pTaskBar->hb, HOVER_ABOVE);

     WinStartTimer(WinQueryAnchorBlock(pTaskBar->hwndOwner), pTaskBar->hwndTaskBar, IDT_TBTIMER, TB_TIMEOUT);

     return(pTaskBar->hwndTaskBar);
     }


/*************************************************************************************
  TaskBarDestroy: Kills Taskbar
*************************************************************************************/
BOOL TaskBarDestroy(PSTTASKBAR pTaskBar)
     {
     DestroyHoverBox(&pTaskBar->hb);
     WinStopTimer(WinQueryAnchorBlock(pTaskBar->hwndOwner), pTaskBar->hwndTaskBar, IDT_TBTIMER);
     return(WinDestroyWindow(pTaskBar->hwndTaskBar));
     }


/*************************************************************************************
  TaskBarItemAdd: Adds item to task bar.
*************************************************************************************/
int TaskBarItemAdd(PSTTASKBAR pTaskBar, HWND hwndItem, PID pid, HSWITCH hswitch, ULONG ulProgType, char *szSwitchTitle)
    {
    int         iItem;


    if (pTaskBar->pTaskItems == NULL)
       pTaskBar->pTaskItems = (PSTTASKBARITEM) malloc(sizeof(STTASKBARITEM));
    else
       pTaskBar->pTaskItems = (PSTTASKBARITEM) realloc(pTaskBar->pTaskItems, (pTaskBar->usItemCount + 1) * sizeof(STTASKBARITEM));

    pTaskBar->usItemCount++;

    iItem = pTaskBar->usItemCount - 1;

    pTaskBar->pTaskItems[iItem].iItemId = pTaskBar->usItemCount;
    pTaskBar->pTaskItems[iItem].pstOwner = pTaskBar;
    pTaskBar->pTaskItems[iItem].pidItem = pid;
    pTaskBar->pTaskItems[iItem].hswitch = hswitch;

    pTaskBar->pTaskItems[iItem].hwndButton =
              WinCreateWindow(pTaskBar->hwndTaskBar, WC_BUTTON, (PSZ) NULL,
                              WS_VISIBLE | BS_PUSHBUTTON | BS_USERBUTTON | BS_NOPOINTERFOCUS,
                              0, 0, 0, 0,
                              pTaskBar->hwndTaskBar, HWND_BOTTOM,
                              pTaskBar->pTaskItems[iItem].hswitch, 0, 0);

    WinSetWindowPtr(pTaskBar->pTaskItems[iItem].hwndButton, 0, (PVOID) pTaskBar);
    DefaultTaskProc = WinSubclassWindow(pTaskBar->pTaskItems[iItem].hwndButton, (PFNWP) TaskBarSubClassTaskWndProc);

    pTaskBar->pTaskItems[iItem].hwndItem = hwndItem;

    pTaskBar->pTaskItems[iItem].ulProgType = ulProgType;

    if (strlen(szSwitchTitle) < 1)
       strcpy(pTaskBar->pTaskItems[iItem].szSwitchTitle, "");
    else
       strcpy(pTaskBar->pTaskItems[iItem].szSwitchTitle, szSwitchTitle);

    return(TRUE);
    }


/*************************************************************************************
  TaskBarItemRemove: Removes item from taskbar.
*************************************************************************************/
BOOL TaskBarItemRemove(PSTTASKBAR pTaskBar, int iItemId)
     {
     return (FALSE);
     }

/*************************************************************************************
  TaskBarItemRemoveAll: Removes all items from taskbar.
*************************************************************************************/
BOOL TaskBarItemRemoveAll(PSTTASKBAR pTaskBar)
     {
     int        iCounter;


     for (iCounter = 0; iCounter < pTaskBar->usItemCount; iCounter++)
         {
         WinDestroyWindow(pTaskBar->pTaskItems[iCounter].hwndButton);
         }

     free(pTaskBar->pTaskItems);

     pTaskBar->pTaskItems = NULL;
     pTaskBar->usItemCount = 0;
     pTaskBar->hwndBtnCurrent = NULLHANDLE;

     WinInvalidateRect(pTaskBar->hwndTaskBar, NULL, FALSE);

     return (TRUE);
     }


/*************************************************************************************
  TaskBarWndProc: Handle Task Paint/presses.
*************************************************************************************/
MRESULT EXPENTRY TaskBarWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
        {
        RECTL              rcl;
        PUSERBUTTON        ubInfo;
        HPS                hps;
        ULONG              y, ulFlag;
        int                iItemId, iPos;
        int                iCounter;
        POINTL             pp;
        PSTTASKBAR         pTaskBar;
        HBITMAP            hbmUse;
        SWP                swp;
        POINTL             ptl;
        ULONG              flOptions;
        HWND               hwndMenu;


        switch (msg)
               {
               case WM_PAINT:
                    hps = WinBeginPaint(hwnd, 0, 0);
                    WinQueryWindowRect(hwnd, &rcl);
                    WinFillRect(hps, &rcl, TB_COLOR_BACKGROUND);
                    WinEndPaint(hps);
                    break;

               case WM_CONTROL:
                    pTaskBar = (PSTTASKBAR) WinQueryWindowPtr(hwnd, 0);
                    switch (SHORT2FROMMP(mp1))
                           {
                           case BN_CLICKED:
                                iPos = TaskBarPosFromItem(pTaskBar, SHORT1FROMMP(mp1));
                                if (TaskBarIsMouseOnHwnd(pTaskBar->pTaskItems[iPos].hwndButton))
                                   {
                                   WinPostMsg(pTaskBar->hwndOwner, WM_TASKBARSELECT,
                                              (PVOID) SHORT1FROMMP(mp1), 
                                              (PVOID) pTaskBar->pTaskItems[iPos].hwndItem);
                                   }
                                break;

                           case BN_PAINT:
                                iPos = TaskBarPosFromItem(pTaskBar, SHORT1FROMMP(mp1));
                                y = LONGFROMMP(mp2);
                                ubInfo = (PUSERBUTTON) y;

                                TaskBarDrawSwitchIcon(&pTaskBar->pTaskItems[iPos], ubInfo->hps);
                                return ((MRESULT) TRUE);
                                break;
                           }

               case WM_TIMER:
                    pTaskBar = (PSTTASKBAR) WinQueryWindowPtr(hwnd, 0);

                    if (pTaskBar->hwndBtnCurrent != NULLHANDLE)
                       {
                       if (SHORT1FROMMP(mp1) == IDT_TBTIMER && TaskBarIsMouseOnHwnd(pTaskBar->hwndBtnCurrent) == FALSE)
                          {
                          WinInvalidateRect(pTaskBar->hwndBtnCurrent, NULL, FALSE);
                          pTaskBar->hwndBtnCurrent = NULLHANDLE;
                          }
                       }
                    break;

               default:
                    return (WinDefWindowProc(hwnd, msg, mp1, mp2));
               }
        return (FALSE);
        }


/*************************************************************************************
  TaskBarPosFromItem: Get Task bar pos (in array).
************************************************************************************/
int TaskBarPosFromItem(PSTTASKBAR pTaskBar, int iItemId)
      {
      int       iCounter;


      for (iCounter = 0; iCounter < pTaskBar->usItemCount; iCounter++)
          {
          if (pTaskBar->pTaskItems[iCounter].hswitch == iItemId)
             {
             return(iCounter);
             break;
             }
          }
      return(-1);
      }


/*************************************************************************************
  TaskBarIsMouseOnHwnd: Is mouse on top of window.
************************************************************************************/
BOOL TaskBarIsMouseOnHwnd(HWND hwndHit)
     {
     RECTL              rcl;
     int                iHit;
     POINTL             ptl;


     WinQueryPointerPos(HWND_DESKTOP, &ptl);
     WinMapWindowPoints(HWND_DESKTOP, hwndHit, &ptl, 1);
     WinQueryWindowRect(hwndHit, &rcl);
     if (WinPtInRect(WinQueryAnchorBlock(hwndHit), &rcl, &ptl))
        return (TRUE);
     else
        return(FALSE);
     }


/*************************************************************************************
  TaskBarDrawSwitchIcon: Draw icon from switch list.
************************************************************************************/
void TaskBarDrawSwitchIcon(PSTTASKBARITEM pBtnItem, HPS hps)
     {
     HPOINTER           hpointerApp;
     RECTL              rclClient, rcl;
     ULONG              iFontId;
     PSTTASKBAR         pTaskBar;
     ULONG              xMini, yMini, x, y, yPos;


     pTaskBar = (PSTTASKBAR) pBtnItem->pstOwner;

     WinQueryWindowRect(pBtnItem->hwndButton, &rclClient);

     // Draw background and 3D border
     if (pBtnItem->hwndButton == pTaskBar->hwndBtnCurrent && TaskBarIsMouseOnHwnd(pTaskBar->hwndBtnCurrent) == TRUE)
        TaskBar3D (hps, rclClient, 1, TRUE);
     else
        TaskBar3D (hps, rclClient, 0, TRUE);

     //Get size of mini icons
     IconSize (&xMini, &yMini);
     xMini = xMini / 2;
     yMini = yMini / 2;

     x = TB_BORDERSPACE * 2;

     yPos = ((pTaskBar->iHeight - yMini) / 2) - 1;

     hpointerApp = (HPOINTER)WinSendMsg(pBtnItem->hwndItem, WM_QUERYICON, NULL, NULL);
     if (hpointerApp != NULL)
        {
        WinDrawPointer(hps, x, yPos, hpointerApp, DP_MINI);
        }
     else
        {
        WinDrawPointer(hps, x, yPos, WinQuerySysPointer(HWND_DESKTOP, SPTR_APPICON, FALSE), DP_MINI);
        // hpointerApp = WinLoadFileIcon(ProcessPath(pBtnItem->pidItem), TRUE);
        // WinDrawPointer(hps, x, yPos, hpointerApp, DP_MINI);
        // WinFreeFileIcon(hpointerApp);
        }

     rcl.xLeft = xMini + (TB_BORDERSPACE * 4);
     rcl.xRight = rclClient.xRight - (TB_BORDERSPACE * 2);
     rcl.yTop = rclClient.yTop;
     rcl.yBottom = 0;

     //iFontId = SelectFont(TRUE, hps, "WarpSans Normal", 9);
     GpiSetColor(hps, CLR_BLACK);
     WinDrawText(hps, -1, pBtnItem->szSwitchTitle,
                 &rcl, 0, 0, DT_TEXTATTRS | DT_VCENTER | DT_LEFT | DT_WORDBREAK);

     //SelectFont(FALSE, hps, "", iFontId);
     }


/*-----------------------------------------------------------------------------
   TaskBarSubClassTaskWndProc: Subclassed Task WndProc.
-----------------------------------------------------------------------------*/
MRESULT EXPENTRY TaskBarSubClassTaskWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     PSTTASKBARITEM      pTaskBarItem;
     PSTTASKBAR          pTaskBar;
     char                szUseText[256];
     SWP                 swp;
     POINTL              ptl;
     ULONG               flOptions;
     HWND                hwndMenu;
     HWND                hwndNext;
     HENUM               henum;


     switch (msg)
            {
            case WM_CONTEXTMENU:
                 WinQueryPointerPos(HWND_DESKTOP, &ptl);
                 WinMapWindowPoints(HWND_DESKTOP, hwnd, &ptl, 1);
                 hwndMenu = WinLoadMenu(hwnd, NULLHANDLE, ID_MENUTASK);
                 flOptions = PU_KEYBOARD | PU_MOUSEBUTTON1 | PU_HCONSTRAIN | PU_VCONSTRAIN;
                 WinPopupMenu(hwnd, hwnd, hwndMenu, ptl.x, ptl.y, 0, (USHORT) flOptions);
                 break;

            case WM_COMMAND:
                 pTaskBar = (PSTTASKBAR) WinQueryWindowPtr(hwnd, 0);
                 pTaskBarItem = (PSTTASKBARITEM) TaskBarItemFromHwnd(pTaskBar, hwnd);

                 switch (SHORT1FROMMP(mp1))
                        {
                        case IDM_APP_RESTORE:
                             WinSetWindowPos(pTaskBarItem->hwndItem, (HWND) NULLHANDLE, NULL, NULL, NULL, NULL, SWP_RESTORE | SWP_ACTIVATE | SWP_SHOW);
                             break;

                        case IDM_APP_MAXIMIZE:
                             WinSetWindowPos(pTaskBarItem->hwndItem, (HWND) NULLHANDLE, NULL, NULL, NULL, NULL, SWP_MAXIMIZE | SWP_ACTIVATE | SWP_SHOW);
                             break;

                        case IDM_APP_MINIMIZE:
                             WinSetWindowPos(pTaskBarItem->hwndItem, (HWND) NULLHANDLE, NULL, NULL, NULL, NULL, SWP_MINIMIZE | SWP_DEACTIVATE);
                             break;

                        case IDM_APP_CLOSE:
                             WinPostMsg(pTaskBarItem->hwndItem, WM_QUIT, NULL, NULL);
                             // WinDestroyWindow(pTaskBarItem->hwndItem);
                             break;

                        case IDM_MINIMIZEALL:
                             henum = WinBeginEnumWindows(HWND_DESKTOP);
                             while ((hwndNext = WinGetNextWindow(henum)) != NULLHANDLE) 
                                   {
                                   memset(&swp, 0, sizeof(SWP));
                                   swp.fl = SWP_MINIMIZE;
                                   swp.hwnd = hwndNext;
                                   WinPostMsg(hwndNext, WM_MINMAXFRAME, MPFROMP(&swp), NULL);
                                   }
                             WinEndEnumWindows(henum);
                             break;

                        case IDM_CLOSE:
                             WinSendMsg(app.hwndClient, WM_CLOSE, NULL, NULL);
                             break;

                        case IDM_ABOUT:
                             WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP) AboutDlgProc, NULL, DLG_ABOUT, 0);
                             break;

                        default:
                             return WinDefWindowProc(hwnd, msg, mp1, mp2);
                        }
                 break;


            case WM_MOUSEMOVE:
                 pTaskBar = (PSTTASKBAR) WinQueryWindowPtr(hwnd, 0);
                 pTaskBarItem = (PSTTASKBARITEM) TaskBarItemFromHwnd(pTaskBar, hwnd);

                 if (pTaskBarItem->hwndButton != pTaskBar->hwndBtnCurrent)
                    {
                    WinInvalidateRect(pTaskBar->hwndBtnCurrent, NULL, FALSE);
                    pTaskBar->hwndBtnCurrent = pTaskBarItem->hwndButton;
                    WinInvalidateRect(pTaskBarItem->hwndButton, NULL, FALSE);
                    }

                 strcpy(szUseText, pTaskBarItem->szSwitchTitle);

                 if (strlen(szUseText) > 0)
                    {
                    SetHoverBoxText(&pTaskBar->hb, szUseText);
                    ShowHoverBox(&pTaskBar->hb, hwnd, pTaskBarItem->hswitch, TRUE);
                    }
                 return DefaultTaskProc (hwnd, msg, mp1, mp2);

            default:
                 return ((MRESULT) DefaultTaskProc(hwnd, msg, mp1, mp2));
            }
     return (FALSE);
     }


/*************************************************************************************
  TaskBarItemFromHwnd: Finds item with taskbar and hwnd.
************************************************************************************/
PSTTASKBARITEM TaskBarItemFromHwnd(PSTTASKBAR pTaskBar, HWND hwndItem)
      {
      int       iCounter;


      for (iCounter = 0; iCounter < pTaskBar->usItemCount; iCounter++)
          {
          if (pTaskBar->pTaskItems[iCounter].hwndButton == hwndItem)
             {
             return((PSTTASKBARITEM) &pTaskBar->pTaskItems[iCounter]);
             break;
             }
          }
      return((PSTTASKBARITEM) NULL);
      }


/*************************************************************************************
  TaskBarRedraw: Redraws taskbar and buttons.
************************************************************************************/
ULONG TaskBarRedraw(PSTTASKBAR pTaskBar, int xStart, int xStop)
      {
      RECTL     rclOwner, rcl;
      int       xpos, xsize, ypos, ysize;
      int       iWinWidth, iMaxBtn, iPos;
      int       iCounter;
      ULONG     xIcon, xBtnSize;


      if (pTaskBar->hwndTaskBar == NULLHANDLE)
         return (0);

      if (pTaskBar->bShow == FALSE)
         return (0);

      if (xStop == 0 || xStop < xStart)
         return (0);

      WinQueryWindowRect(pTaskBar->hwndOwner, &rclOwner);
      ypos = 0;
      ysize = pTaskBar->iHeight;

      xpos = xStart;
      xsize = xStop - xStart;

      WinSetWindowPos(pTaskBar->hwndTaskBar, HWND_TOP, xpos, ypos, xsize, ysize,
                      SWP_SHOW | SWP_SIZE | SWP_MOVE | SWP_ZORDER);

      WinQueryWindowRect(pTaskBar->hwndTaskBar, &rcl);

      IconSize (&xIcon, NULL);
      iWinWidth = rcl.xRight - rcl.xLeft;
      iMaxBtn = xIcon * 3;
      iPos = TB_BORDERSPACE * 2;

      if ( ((pTaskBar->usItemCount * iMaxBtn) + iPos) > iWinWidth)
         xBtnSize = (iWinWidth - iPos - (pTaskBar->usItemCount * (TB_BORDERSPACE * 2))) / pTaskBar->usItemCount;
      else
         xBtnSize = iMaxBtn;

      for (iCounter = 0; iCounter < pTaskBar->usItemCount; iCounter++)
          {
          WinSetWindowPos(pTaskBar->pTaskItems[iCounter].hwndButton, HWND_TOP,
                         iPos, TB_BORDERSPACE, xBtnSize, pTaskBar->iHeight - (TB_BORDERSPACE * 2),
                         SWP_SHOW | SWP_SIZE | SWP_MOVE | SWP_ZORDER);
          iPos += (xBtnSize + (TB_BORDERSPACE * 2));

          }

      return (ysize);
      }


/*************************************************************************************
  TaskBar3D: Draws 3D look in specified RECTL.
*************************************************************************************/
void TaskBar3D (HPS hps, RECTL rcl, int iType, BOOL bFill)
     {
     POINTL             pp;


     /* All around */
     MyDrawBox(hps, rcl.xLeft, rcl.yBottom, rcl.xRight, rcl.yTop, CLR_PALEGRAY);

     if (iType == 1) // highlight
        {
        MyDrawBox(hps, rcl.xLeft, rcl.yTop, rcl.xRight, rcl.yTop, CLR_BLACK);
        MyDrawBox(hps, rcl.xLeft, rcl.yTop, rcl.xLeft, rcl.yBottom, CLR_BLACK);

        MyDrawBox(hps, rcl.xLeft + 1, rcl.yTop - 1, rcl.xRight - 1, rcl.yTop - 1, CLR_DARKGRAY);
        MyDrawBox(hps, rcl.xLeft + 1, rcl.yTop - 1, rcl.xLeft + 1, rcl.yBottom + 1, CLR_DARKGRAY);

        MyDrawBox(hps, rcl.xLeft, rcl.yBottom, rcl.xRight, rcl.yBottom, CLR_WHITE);
        MyDrawBox(hps, rcl.xRight, rcl.yBottom, rcl.xRight, rcl.yTop - 1, CLR_WHITE);
        }
     else // normal
        {
        MyDrawBox(hps, rcl.xLeft, rcl.yBottom, rcl.xRight, rcl.yBottom, CLR_BLACK);
        MyDrawBox(hps, rcl.xRight, rcl.yBottom, rcl.xRight, rcl.yTop, CLR_BLACK);

        MyDrawBox(hps, rcl.xLeft + 1, rcl.yBottom + 1, rcl.xRight - 1, rcl.yBottom + 1, CLR_DARKGRAY);
        MyDrawBox(hps, rcl.xRight - 1, rcl.yBottom + 1, rcl.xRight - 1, rcl.yTop - 1, CLR_DARKGRAY);

        MyDrawBox(hps, rcl.xLeft, rcl.yTop, rcl.xRight - 1, rcl.yTop, CLR_WHITE);
        MyDrawBox(hps, rcl.xLeft, rcl.yBottom + 1, rcl.xLeft, rcl.yTop, CLR_WHITE);
        }
     }


/*************************************************************************************
  MyDrawBox: Draws box.
*************************************************************************************/
void MyDrawBox(HPS hps, int xLeft, int yBottom, int xRight, int yTop, int iColor)
     {
     POINTL             pp;


     GpiSetColor(hps, iColor);
     pp.x = xLeft;
     pp.y = yBottom;
     GpiMove(hps, &pp);
     pp.x = xRight;
     pp.y = yTop;
     GpiBox(hps, DRO_OUTLINEFILL, &pp, 0, 0);
     }



/*-----------------------------------------------------------------------------
    DebugLog: Skickar information till debuglog-filen.
-----------------------------------------------------------------------------*/
void DebugLog(char *szData)
     {
     FILE               *hLogFile;


     hLogFile = fopen(".\\debug.log", "a");
     fprintf(hLogFile, "%s\n", szData);
     fclose(hLogFile);
     }
