/****************************************************************************
 * Copyright Notice:														*
 *  (c) Copyright 1996 by Stardock Systems.  ALL RIGHTS RESERVED.           *
 *      This work protected by US Copyright Law.                            *
 *	You may not create derived works from this material.					*
 ****************************************************************************
 * Name:            REMOVINS.CMD                                            *
 *																			*
 * Description:     REXX script to remove Object Desktop installation       *
 *                  entries from the \OS2\SYSTEM\EPFIS.INI file             *
 *                  (created/maintained by IBM Software Installer)          *
 ****************************************************************************/

/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Get boot drive. */
szSystemDrive = FileSpec( 'Drive', Value( 'SYSTEM_INI',,'OS2ENVIRONMENT' ) )

/* Create spec for EPFIS.INI. */
szIniFile = szSystemDrive'\OS2\SYSTEM\EPFIS.INI'

/* Do copyright banner. */
Say
Say 'REMOVINS'
Say
Say 'Stardock Systems Object Desktop Installation Utility'
Say '(c) 1996 Stardock Systems Incorporated'
Say
Say 'This utility is used to remove installation data from the system'
Say 'application registry maintained by the IBM Software Installer product.'
Say 'You may use this utility to aid removal of Object Desktop and '
Say 'Object Desktop Professional files for a manual un-install.'
Say

/* Get ini application keys. */
rc = SysIni( szIniFile, 'ALL:', 'Applications' )
if rc <> 'ERROR:' Then Do

    /* Display keys that will be removed. */
    fHeader = 0
    fOneFound = 0
    iApp = 1
    Do i = 1 To Applications.0
        If Pos( 'Object Desktop', Applications.i ) <> 0 Then Do

            /* Say header. */
            If \fHeader Then Do
                Say 'The installation registry INI file 'szIniFile' contains '
                Say 'Object Desktop or Object Desktop Professional specific data.'
                Say
                Say 'The following INI keys will be removed by this utility:'
                fHeader = 1
            End

            /* Show the application name. */
            Display = Applications.i
            If Pos( ',', Display ) <> 0 Then Do
                Parse Value Applications.i With Part1','Part2
                Display = Part1 || '0A0D'x || '     ' || Part2
            End
            Say
            Say '   'iApp'. 'Display
            Say
            iApp = iApp + 1
            fOneFound = 1
        End
    End

    /* One found? */
    If fOneFound Then Do
        Call CharOut, '   Type "Y" to remove the listed keys. or any other key to quit.'
        AKey = SysGetKey( 'NOECHO' )
        Say
        If AKey <> 'y' & AKey <> 'Y' Then
            Exit
    End
    Else Do
        Say 'No Object Desktop or Object Desktop Professional keys found.'
        Say
        Exit
    End

    /* Remove the keys. */
    Say
    Do i = 1 To Applications.0
        If Pos( 'Object Desktop', Applications.i ) <> 0 Then Do
            Call CharOUt, 'Removing 'Applications.i'....'
            rc = SysIni( szIniFile, Applications.i, 'DELETE:' )
            If rc <> 'ERROR:' Then Say 'OK.'
            Else Say 'Failure, was not removed.'
        End
    End
End

