//-----------------------------------------
//Matrix ScreenSaver for PDE, stVova 2003
//Special thanks for Alex Vaneev, 1:5003/15.1
//This is free software distributed "as is"
//You can change it as you wish.
//-----------------------------------------
PROGRAM Matrix;

{&Use32+}

Uses OS2BASE;

{$PMTYPE NOVIO}

CONST
 FlakeCount = 1024; {nunver of symbols on the screen}
 VioMode: VioModeInfo =
   ( cb:     SizeOf(VioModeInfo);
     fbType: vgmt_Other + vgmt_Graphics;
     Color:  colors_256;
     Col:    40;
     Row:    25;
     HRes:   320;
     VRes:   200
   );
 VioBuf: VioPhysBuf =
   ( pBuf: Ptr($A0000);
     cb:   64*1024
   );

TYPE
        TFlake = RECORD
                x,y: INTEGER;
                Depth: BYTE;
                Falling: BOOLEAN;
                InAir: BOOLEAN;
                ch: Byte; {char to represent: 0, 1 ...}
        END;

  Ptr16Rec = record
    Ofs,Sel: SmallWord;
  end;

VAR
        //Screen: ARRAY[0..63999] OF BYTE ABSOLUTE $A0000;
        Flake: ARRAY[1..FlakeCount] OF TFlake;
        VIO: LongInt;
        sp: array[0..40] of Byte;
        About: String;

function KeyPressed: Boolean;
var
  Key: KbdKeyInfo;
begin
  KbdCharIn(Key, io_NoWait, 0);
  KeyPressed := (Key.fbStatus and kbdtrf_Final_Char_In) <> 0;
end;

{PROCEDURE VideoModeSet(Mode: BYTE);
ASSEMBLER;
ASM
        XOR AH,AH
        MOV AL,[Mode]
        INT 10H
END;}

PROCEDURE PaletteSet(VAR PaletteBuffer; StartColour, EndColour: BYTE);
Begin

{ASSEMBLER;
ASM
        PUSH DS

        LDS SI,[PaletteBuffer]
        XOR CX,CX
        MOV CL,[EndColour]
        MOV AH,[StartColour]
        MOV BH,AH

        CLD

        MOV BL,1

        CMP CL,AH
        JA @@Incrementing

        STD
        NEG BL
        XCHG CL,AH

@@Incrementing:
        SUB CL,AH
        INC CX

        CLI

@@FillLoop:
        MOV DX,3C8H
        MOV AL,BH
        OUT DX,AL

        MOV DX,3C9H
        LODSB
        OUT DX,AL
        LODSB
        OUT DX,AL
        LODSB
        OUT DX,AL

        ADD BH,BL
        LOOP @@FillLoop

        STI

@@Done:
        POP DS}
END;

PROCEDURE PixelPut(x,y: INTEGER; c: BYTE; ch: Byte);
var
  c2: Byte;
BEGIN
        if c<>0 then c:=48;
        c2 := 0;
        if c<>0 then c2 := 255;
        {IF (x>-1) AND (x<320) AND (y>-1) AND (y<200) THEN
                Screen[y*320+x]:=c;
        }
        IF (x>-1) AND (x<316) AND (y>-1) AND (y<200) THEN
           Begin
                if (ch>=0) and (ch<=3) then Begin {draw 1}
                  Mem[VIO+y*320+x+3]:=c; Mem[VIO+(y+1)*320+x+2]:=c;
                  Mem[VIO+(y+1)*320+x+3]:=c; Mem[VIO+(y+2)*320+x+3]:=c;
                  Mem[VIO+(y+3)*320+x+3]:=c; Mem[VIO+(y+4)*320+x+3]:=c;
                  Mem[VIO+(y+5)*320+x+3]:=c;
                  Mem[VIO+(y+5)*320+x+2]:=c; Mem[VIO+(y+5)*320+x+4]:=c;
                  End
                else if (ch=4) then Begin {draw}
                  Mem[VIO+(y+3)*320+x]:=c; Mem[VIO+(y+3)*320+x+1]:=c;
                  Mem[VIO+(y+3)*320+x+2]:=c; Mem[VIO+(y+3)*320+x+3]:=c;
                  Mem[VIO+(y+3)*320+x+4]:=c; Mem[VIO+(y+2)*320+x+1]:=c;
                  End
                else if (ch=5) then Begin {draw}
                  Mem[VIO+(y+1)*320+x+1]:=c; Mem[VIO+y*320+x+3]:=c;
                  Mem[VIO+(y+1)*320+x]:=c; Mem[VIO+(y+1)*320+x+2]:=c;
                  Mem[VIO+(y+2)*320+x]:=c; Mem[VIO+(y+1)*320+x+3]:=c;
                  Mem[VIO+(y+3)*320+x]:=c; Mem[VIO+(y+1)*320+x+4]:=c;
                  Mem[VIO+(y+4)*320+x]:=c; Mem[VIO+(y+2)*320+x+3]:=c;
                  Mem[VIO+(y+5)*320+x+4]:=c; Mem[VIO+(y+3)*320+x+3]:=c;
                  Mem[VIO+(y+5)*320+x+1]:=c; Mem[VIO+(y+4)*320+x+3]:=c;
                  End
                else if (ch=6) then Begin {draw H}
                  Mem[VIO+y*320+x]:=c; Mem[VIO+y*320+x+4]:=c;
                  Mem[VIO+(y+1)*320+x]:=c; Mem[VIO+(y+1)*320+x+4]:=c;
                  Mem[VIO+(y+2)*320+x]:=c; Mem[VIO+(y+2)*320+x+4]:=c;
                  Mem[VIO+(y+3)*320+x]:=c; Mem[VIO+(y+3)*320+x+4]:=c;
                  Mem[VIO+(y+4)*320+x]:=c; Mem[VIO+(y+4)*320+x+4]:=c;
                  Mem[VIO+(y+5)*320+x]:=c; Mem[VIO+(y+5)*320+x+4]:=c;
                  Mem[VIO+(y+2)*320+x+1]:=c; Mem[VIO+(y+2)*320+x+2]:=c;
                  Mem[VIO+(y+2)*320+x+3]:=c;
                  End
                else if (ch=7) then Begin {draw E}
                  Mem[VIO+y*320+x]:=c; Mem[VIO+(y+1)*320+x]:=c;
                  Mem[VIO+(y+2)*320+x]:=c; Mem[VIO+(y+3)*320+x]:=c;
                  Mem[VIO+(y+4)*320+x]:=c; Mem[VIO+(y+5)*320+x]:=c;
                  Mem[VIO+y*320+x+1]:=c; Mem[VIO+y*320+x+2]:=c;
                  Mem[VIO+y*320+x+3]:=c; Mem[VIO+(y+2)*320+x+1]:=c;
                  Mem[VIO+(y+2)*320+x+2]:=c; Mem[VIO+(y+5)*320+x+1]:=c;
                  Mem[VIO+(y+5)*320+x+2]:=c; Mem[VIO+(y+5)*320+x+3]:=c;
                  //Mem[VIO+(y+1)*320+x+2]:=c; Mem[VIO+(y+1)*320+x+1]:=c;
                  End
                else if (ch=8) then Begin {draw}
                  Mem[VIO+(y+1)*320+x+1]:=c;
                  Mem[VIO+(y+2)*320+x+2]:=c; Mem[VIO+(y+3)*320+x+3]:=c;
                  Mem[VIO+(y+4)*320+x+2]:=c; Mem[VIO+(y+5)*320+x+1]:=c;
                  End
                else if (ch=9) then Begin {draw M}
                  Mem[VIO+y*320+x]:=c; {Mem[VIO+y*320+x+1]:=c;
                  Mem[VIO+y*320+x+4]:=c;} Mem[VIO+y*320+x+4]:=c;
                  Mem[VIO+(y+1)*320+x]:=c; Mem[VIO+(y+1)*320+x+4]:=c;
                  Mem[VIO+(y+2)*320+x]:=c; Mem[VIO+(y+2)*320+x+4]:=c;
                  Mem[VIO+(y+3)*320+x]:=c; Mem[VIO+(y+3)*320+x+4]:=c;
                  Mem[VIO+(y+4)*320+x]:=c; Mem[VIO+(y+4)*320+x+4]:=c;
                  Mem[VIO+(y+5)*320+x]:=c; Mem[VIO+(y+5)*320+x+4]:=c;
                  Mem[VIO+(y+1)*320+x+1]:=c; Mem[VIO+(y+2)*320+x+2]:=c;
                  Mem[VIO+(y+1)*320+x+3]:=c;
                  End
                else if (ch=10) then Begin {draw A}
                  Mem[VIO+(y+1)*320+x+1]:=c; Mem[VIO+(y+1)*320+x+3]:=c;
                  Mem[VIO+(y+2)*320+x]:=c; Mem[VIO+(y+3)*320+x]:=c;
                  Mem[VIO+(y+4)*320+x]:=c; Mem[VIO+(y+5)*320+x]:=c;
                  Mem[VIO+(y+2)*320+x+4]:=c; Mem[VIO+(y+3)*320+x+4]:=c;
                  Mem[VIO+(y+4)*320+x+4]:=c; Mem[VIO+(y+5)*320+x+4]:=c;

                  Mem[VIO+y*320+x+2]:=c; Mem[VIO+(y+3)*320+x+2]:=c;
                  Mem[VIO+(y+3)*320+x+1]:=c; Mem[VIO+(y+3)*320+x+3]:=c;
                  End
                else if (ch=11) then Begin {draw T}
                  Mem[VIO+y*320+x]:=c; Mem[VIO+y*320+x+1]:=c;
                  Mem[VIO+y*320+x+2]:=c; Mem[VIO+y*320+x+3]:=c;
                  Mem[VIO+y*320+x+4]:=c;
                  Mem[VIO+(y+1)*320+x]:=c; Mem[VIO+(y+1)*320+x+4]:=c;
                  Mem[VIO+(y+1)*320+x+2]:=c;
                  Mem[VIO+(y+2)*320+x+2]:=c; Mem[VIO+(y+3)*320+x+2]:=c;
                  Mem[VIO+(y+4)*320+x+2]:=c; Mem[VIO+(y+5)*320+x+2]:=c;
                  Mem[VIO+(y+5)*320+x+1]:=c; Mem[VIO+(y+5)*320+x+3]:=c;
                  End
                else if (ch=12) then Begin {draw R}
                  Mem[VIO+y*320+x]:=c; Mem[VIO+(y+1)*320+x]:=c;
                  Mem[VIO+(y+2)*320+x]:=c; Mem[VIO+(y+3)*320+x]:=c;
                  Mem[VIO+(y+4)*320+x]:=c; Mem[VIO+(y+5)*320+x]:=c;
                  Mem[VIO+y*320+x+1]:=c; Mem[VIO+y*320+x+2]:=c;
                  Mem[VIO+(y+1)*320+x+3]:=c; Mem[VIO+(y+2)*320+x+3]:=c;
                  Mem[VIO+(y+3)*320+x+2]:=c; Mem[VIO+(y+4)*320+x+3]:=c;
                  Mem[VIO+(y+5)*320+x+3]:=c;
                  End
                else if (ch=13) then Begin {draw I}
                  Mem[VIO+y*320+x+2]:=c; Mem[VIO+y*320+x+1]:=c;
                  Mem[VIO+(y+1)*320+x+2]:=c; Mem[VIO+(y+2)*320+x+2]:=c;
                  Mem[VIO+(y+3)*320+x+2]:=c; Mem[VIO+(y+4)*320+x+2]:=c;
                  Mem[VIO+(y+5)*320+x+2]:=c; Mem[VIO+y*320+x+3]:=c;
                  Mem[VIO+(y+5)*320+x+1]:=c; Mem[VIO+(y+5)*320+x+3]:=c;
                  End
                else if (ch=14) then Begin {draw X}
                  Mem[VIO+y*320+x]:=c; Mem[VIO+y*320+x+4]:=c;
                  Mem[VIO+(y+1)*320+x+1]:=c; Mem[VIO+(y+1)*320+x+3]:=c;
                  Mem[VIO+(y+2)*320+x+2]:=c; Mem[VIO+(y+3)*320+x+2]:=c;
                  Mem[VIO+(y+4)*320+x+1]:=c; Mem[VIO+(y+4)*320+x+3]:=c;
                  Mem[VIO+(y+5)*320+x]:=c; Mem[VIO+(y+5)*320+x+4]:=c;
                  End
                else if (ch=15) then Begin {draw}
                  Mem[VIO+y*320+x]:=c; Mem[VIO+y*320+x+1]:=c;
                  Mem[VIO+y*320+x+2]:=c; Mem[VIO+y*320+x+3]:=c; Mem[VIO+y*320+x+4]:=c;
                  Mem[VIO+y*320+x+5]:=c; Mem[VIO+(y+1)*320+x]:=c;
                  Mem[VIO+(y+2)*320+x]:=c; Mem[VIO+(y+3)*320+x+1]:=c;
                  Mem[VIO+(y+4)*320+x+1]:=c; Mem[VIO+(y+5)*320+x+2]:=c;
                  Mem[VIO+(y+5)*320+x+3]:=c; Mem[VIO+(y+4)*320+x+4]:=c;
                  End
                else if (ch=16) then Begin {draw}
                  Mem[VIO+y*320+x+5]:=c; Mem[VIO+(y+1)*320+x+5]:=c;
                  Mem[VIO+(y+2)*320+x+5]:=c; Mem[VIO+(y+3)*320+x+5]:=c;
                  Mem[VIO+(y+4)*320+x+5]:=c; Mem[VIO+(y+5)*320+x+4]:=c;
                  Mem[VIO+(y+5)*320+x+3]:=c; Mem[VIO+(y+5)*320+x+2]:=c;
                  Mem[VIO+(y+5)*320+x+1]:=c; Mem[VIO+(y+5)*320+x+2]:=c;
                  Mem[VIO+(y+5)*320+x+3]:=c; Mem[VIO+(y+4)*320+x+4]:=c;
                  Mem[VIO+(y+1)*320+x+4]:=c; Mem[VIO+(y+1)*320+x+3]:=c;
                  Mem[VIO+(y+1)*320+x+2]:=c; Mem[VIO+(y+1)*320+x+1]:=c;
                  End
                else if (ch=17) then Begin {draw}
                  Mem[VIO+y*320+x+2]:=c; Mem[VIO+y*320+x+4]:=c;
                  Mem[VIO+(y+1)*320+x+2]:=c; Mem[VIO+(y+1)*320+x+4]:=c;
                  Mem[VIO+(y+2)*320+x+2]:=c; Mem[VIO+(y+2)*320+x+4]:=c;
                  End
                else if (ch=18) then Begin {draw}
                  Mem[VIO+(y+1)*320+x+3]:=c; Mem[VIO+(y+4)*320+x+3]:=c;
                  End
                else if (ch=19) then Begin {draw}
                  Mem[VIO+(y+2)*320+x]:=c; Mem[VIO+(y+2)*320+x+1]:=c;
                  Mem[VIO+(y+2)*320+x+2]:=c; Mem[VIO+(y+2)*320+x+3]:=c;
                  Mem[VIO+(y+3)*320+x+2]:=c; Mem[VIO+(y+1)*320+x+2]:=c;
                  End
                else if (ch=20) then Begin {draw}
                  Mem[VIO+(y+1)*320+x+4]:=c; Mem[VIO+(y+2)*320+x+4]:=c;
                  Mem[VIO+(y+3)*320+x+4]:=c; Mem[VIO+(y+4)*320+x+3]:=c;
                  Mem[VIO+(y+1)*320+x+3]:=c; Mem[VIO+(y+1)*320+x+2]:=c;
                  Mem[VIO+(y+1)*320+x+1]:=c; Mem[VIO+(y+2)*320+x+1]:=c;
                  End
                else Begin {draw 0}
                  Mem[VIO+y*320+x+1]:=c; Mem[VIO+y*320+x+2]:=c;

                  Mem[VIO+(y+1)*320+x]:=c; Mem[VIO+(y+2)*320+x]:=c;
                  Mem[VIO+(y+3)*320+x]:=c; Mem[VIO+(y+4)*320+x]:=c;
                  Mem[VIO+(y+5)*320+x]:=c;
                  Mem[VIO+(y+1)*320+x+3]:=c; Mem[VIO+(y+2)*320+x+3]:=c;
                  Mem[VIO+(y+3)*320+x+3]:=c; Mem[VIO+(y+4)*320+x+3]:=c;
                  Mem[VIO+(y+5)*320+x+3]:=c;

                  Mem[VIO+(6+y)*320+x+1]:=c; Mem[VIO+(6+y)*320+x+2]:=c;
                  End;
           End;
END;

PROCEDURE GeneratePalette;
TYPE
        TComponent = RECORD
                r,g,b: BYTE;
        END;

VAR
        NewPalette: ARRAY[0..255] OF TComponent;
        i: INTEGER;
BEGIN
        FOR i:=0 TO 255 DO
                BEGIN
                        {NewPalette[i].r:=i DIV 4;
                        NewPalette[i].g:=i DIV 4;
                        NewPalette[i].b:=i DIV 4;}
                        NewPalette[i].r:=0;
                        NewPalette[i].g:=i;
                        NewPalette[i].b:=0;
                END;

        PaletteSet(NewPalette,1,255);
END;

PROCEDURE InitializeSnow;
VAR
        i: INTEGER;
BEGIN

  for i := 0 to 40 do sp[i] := 2 + Random(4);

        FOR i:=1 TO FlakeCount DO
                BEGIN
                        Flake[i].Falling:=FALSE;
                        Flake[i].InAir:=FALSE;

                END;
END;

PROCEDURE ShowSnow;
VAR
        i: INTEGER;
BEGIN
        FOR i:=1 TO FlakeCount DO
                IF Flake[i].InAir THEN
                        PixelPut(Flake[i].x,Flake[i].y,Flake[i].Depth*8, Flake[i].ch);
END;

PROCEDURE MoveSnow;
VAR
        i: INTEGER;
        NewSnow: BYTE;
        Spd,Loc: INTEGER;
        yy: Integer;
        t: Integer;
BEGIN
        NewSnow:=RANDOM(255);
        yy := 0;
//        for i := 0 to 40 do sp[i] := 0;

        FOR i:=1 TO FlakeCount DO
                BEGIN
                if yy > 30 then
                  yy := 0;
                        IF (NOT Flake[i].Falling) AND (NewSnow>0) THEN
                                BEGIN
                                        Flake[i].y := yy;//RANDOM(60)-70;
                                        yy := yy + 5;
                                        t := RANDOM(40);
                                        Flake[i].x := 8*t;//5*RANDOM(64);//RANDOM(320);
                                        //if sp[t] = 0 then
                                        //  sp[t] := 2 + Random(5);
                                        Flake[i].Depth:= sp[t];
                                        Flake[i].Falling:=TRUE;
                                        Flake[i].InAir:=TRUE;
                                        //Flake[i].Depth:=3*(RANDOM(10));
                                          if Flake[i].Depth=12 then Flake[i].Depth:=18;
                                          if Flake[i].Depth=9 then Flake[i].Depth:=18;
                                        Flake[i].ch:=Random(24);
                                END
                        ELSE
                                BEGIN
                                        Spd:=Flake[i].Depth;// DIV 12+1;//+RANDOM(2);
                                        Flake[i].y:=Flake[i].y+Spd;
                                        {Flake[i].x:=Flake[i].x-2+RANDOM(5);}
                                        Flake[i].x:=Flake[i].x;{-1+RANDOM(3);}

                                        IF Flake[i].y>199 THEN
                                                BEGIN
                                                        Flake[i].InAir:=FALSE;
                                                        Flake[i].Falling:=FALSE;
                                                END;
                                END;

                        IF NewSnow>0 THEN
                                NewSnow:=NewSnow-1;
                END;
END;

PROCEDURE KillSnow;
VAR
        i: INTEGER;
BEGIN
        FOR i:=1 TO FlakeCount DO
                IF (Flake[i].Falling) AND (Flake[i].InAir) THEN
                        PixelPut(Flake[i].x,Flake[i].y,0, Flake[i].ch);
END;

BEGIN
  About := 'About: Matrix ScreenSaver for PDE Desktop, stVova 2003. Special thanks for Alex Vaneev, 1:5003/15.1';
        {VideoModeSet($13);} { set 320x200x256 videomode }
        {VioMode.cb:=SizeOf(VioMode);
        VioMode.fbType:=
        VioMode.Color:=8;}
        VioSetMode(VioMode, 0); {set 320x200x256}

        VioGetPhysBuf(VioBuf, 0);
        Ptr16Rec(Vio).Ofs := 0;
        Ptr16Rec(Vio).Sel := VioBuf.Sel;
        SelToFlat(Pointer(Vio));
        FillChar(Pointer(Vio)^,64*1024,0);

        InitializeSnow; { initialize letters }
        GeneratePalette; { set suitable palette }

        REPEAT
                MoveSnow; { change positions of letters }
                ShowSnow; { show letters }
                DosSleep(50); { pause }
                {TimerWait;}
                KillSnow; { remove letters }
        UNTIL Keypressed; { repeat, until the key was pressed }

        {Readkey;} { flush keyboard buffer }
        {VideoModeSet($3);} { set 80x25 textmode }
END.

