(*////////////////////////////////////////////////////
//    PDE -  graphical user shell for OS/2 Warp
//    Copyleft stVova, [PDE-Team], 2003
//    http://os2progg.by.ru/pde
//    "New Link Dialog" module
/////////////////////////////////////////////////////*)

unit pdeNewLink;

interface

Uses
  Classes, Forms, Buttons, ExtCtrls, StdCtrls, SysUtils
  , pdeDlgs, pdeNLS;

Type
  TLinkForm = Class (TForm)
    lnkImage: TShape;
    Bevel1: TBevel;
    edName: TEdit;
    edPath: TEdit;
    edParam: TEdit;
    lnkBtnOk: TButton;
    lnkBtnCancel: TButton;
    lnkLabel1: TLabel;
    lnkLabel2: TLabel;
    lnkLabel3: TLabel;
    lnkLabel4: TLabel;
    lnkLabel5: TLabel;
    lnkLabel6: TLabel;
    bPath: TButton;
    Bevel2: TBevel;
    Bevel3: TBevel;

   Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    Constructor Create(AOwner:TComponent); Override;
    Destructor Destroy; Override;
    procedure lnkPathClick(Sender: TObject);
  End;

function CalcNewLinkType(src: String): String;
function NewLink(src: String): Integer;

implementation

//----TLinkForm class---------------------
Constructor TLinkForm.Create(AOwner:TComponent);
Begin
Inherited Create(AOwner);
BorderStyle := bsStealthDlg;
ClientWidth := 330;
ClientHeight := 295;
Position := poScreenCenter; BorderIcons :=[biSystemMenu];
Font.Name := 'WarpSans Bold:9';
Caption := pdeLoadNLS('dlgCreateShortcut', ' 몠');

lnkImage:=TShape.Create(self);
lnkImage.Width := 50;
lnkImage.Brush.Color := clWhite;
lnkImage.Pen.Style := psClear;
lnkImage.Align := alLeft;
lnkImage.Parent:=self;

Bevel1 := InsertBevel(Self, 50, 249, 280, 1, bsTopLine, bsLowered);
lnkLabel1 := InsertLabel(Self, 60, 255, 200, 20, '');
lnkLabel1.AutoSize := True;
lnkLabel2 := InsertLabel(Self, 60, 195, 260, 45, '');
lnkLabel2.WordWrap := True;

Bevel2 := InsertBevel(Self, 50, 190, 280, 1, bsTopLine, bsLowered);

lnkLabel3 := InsertLabel(Self, 60, 170, 200, 20, pdeLoadNLS('dlgShortcutData', ' 몠'));
lnkLabel3.AutoSize := True;

lnkLabel4 := InsertLabel(Self, 60, 140, 40, 20, pdeLoadNLS('dlgShortcutName', ''));
lnkLabel4.AutoSize := True;
edName := InsertEdit(Self, 120, 140, 190, 20, '', '');

lnkLabel5 := InsertLabel(Self, 60, 110, 40, 20, pdeLoadNLS('dlgShortcutPath', '饭'));
lnkLabel5.AutoSize := True;
edPath := InsertEdit(Self, 120, 110, 160, 20, '', '');
bPath := InsertButton(Self, 285, 109, 25, 22, '...', '');
bPath.OnClick := lnkPathClick;

lnkLabel6 := InsertLabel(Self, 60, 80, 40, 20, pdeLoadNLS('dlgShortcutParams', 'ࠬ'));
lnkLabel6.AutoSize := True;
edParam := InsertEdit(Self, 120, 80, 190, 20, '', '');

Bevel3 := InsertBevel(Self, 50, 60, 280, 1, bsTopLine, bsLowered);

lnkBtnOk:=TButton.Create(Self); lnkBtnOk.Parent:=Self;
lnkBtnOk.Caption:=pdeLoadNLS('dlgCreateButton', 'C');
lnkBtnOk.Default:=True;
lnkBtnOk.Height := 26;
lnkBtnOk.Width := 90;
lnkBtnOk.Left:=129; lnkBtnOk.Bottom:=12;
lnkBtnOk.Align := alFixedRightBottom;
lnkBtnOk.Command := cmOK;
lnkBtnOk.ModalResult := cmOK;

lnkBtnCancel:=TButton.Create(Self); lnkBtnCancel.Parent:=Self;
lnkBtnCancel.Caption:=pdeLoadNLS('dlgCancelButton', 'O⬥');
lnkBtnCancel.Height := 26;
lnkBtnCancel.Width := 90;
lnkBtnCancel.Left:=224; lnkBtnCancel.Bottom:=12;
lnkBtnCancel.Align := alFixedRightBottom;
lnkBtnCancel.Command := cmCancel;
lnkBtnCancel.ModalResult := cmCancel;
lnkBtnCancel.Cancel := True;

End;

Destructor TLinkForm.Destroy;
Begin
//

Inherited Destroy;
End;

procedure TLinkForm.lnkPathClick(Sender: TObject);
var
  fname: String;
Begin

  //path for place new link
  fname := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩')
    , edPath.Text, pdeLoadNLS('eD2Str35','All files')+' (*.*)|');
  if fname <> '' then
    edPath.Text := fname;

End;
//----end TLinkForm class------------------

//-----------------------------------------
function CalcNewLinkType(src: String): String;
var
  ext: String;
begin

  ext := UpperCase(ExtractFileExt(src));
  if (ext = '.EXE') or (ext = '.COM') or (ext = '.CMD')
    or (ext = '.BAT') then
    Result := 'APP'
  else
    Result := 'FOLDER';

end;

//-----------------------------------------

function NewLink(src: String): Integer;
var
  lnkForm: TLinkForm;
  tmp: String;
  lfile: TextFile;
begin

  {dialog, asking new PDE [SHORTCUT] info}
  tmp := src;
  lnkForm := TLinkForm.Create(Application.MainForm);
  lnkForm.lnkLabel1.Caption := ExtractFileName(tmp);
  lnkForm.lnkLabel2.Caption := ExtractFilePath(tmp);

  lnkForm.edName.Text := ' '+' '+lnkForm.lnkLabel1.Caption;
  lnkForm.edPath.Text := lnkForm.lnkLabel2.Caption;

  if lnkForm.ShowModal = cmOK then
    begin
    if (lnkForm.edName.Text<>'') and (lnkForm.edPath.Text<>'') then
      begin
        try
        assignfile(lfile, lnkForm.edPath.Text+lnkForm.edName.Text);
        rewrite(lfile);
        writeln(lfile, '[SHORTCUT]');
        writeln(lfile, '//link: type, object-name, path, parameters');
        writeln(lfile, CalcNewLinkType(tmp));
        if (CalcNewLinkType(tmp)='FOLDER') then
          writeln(lfile, tmp+'\')
          else
          writeln(lfile, tmp);
        writeln(lfile, lnkForm.lnkLabel2.Caption);
        writeln(lfile, lnkForm.edParam.Text);
        closefile(lfile);
        except
        closefile(lfile);
        end;
      end;
    end;

  if lnkForm<>nil then
    lnkForm.Free;

end;
//-----------------------------------------

end.