Unit TypesHelperUnit;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, Buttons, ExtCtrls
  , SysUtils, os2def, pmwin
  , pdeNLS, pdeDlgs, BmpList;

Type
  TTypesForm = Class (TForm)
    Label1: TLabel;
    bOther: TButton;
    bOK: TButton;
    bCancel: TButton;
    Bevel1: TBevel;
    Panel1: TPanel;
    Bevel2: TBevel;
    AppsBox: TBitmapListBox;
    Image1: TImage;
    pBox: TPaintBox;
    Procedure pBoxOnPaint (Sender: TObject; Const rec: TRect);
    Procedure AppsBoxOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure bOtherOnClick (Sender: TObject);
    Procedure TypesFormOnShow (Sender: TObject);
    Procedure TypesFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  TypesForm: TTypesForm;
  ChoosedType: String;
  ChoosedApp: String;
  bmp: LongWord;

Implementation

Uses Unit1;

Procedure TTypesForm.pBoxOnPaint (Sender: TObject; Const rec: TRect);
var
  ps: hPS;
Begin
  {render image in "bmp" pointer}
  pBox.canvas.fillrect(pBox.Canvas.ClipRect, Panel1.Color);
  ps := WinGetPS(pBox.Handle);
  WinDrawPointer( ps, 0, 0, bmp, 0);
  WinReleasePS(ps);
End;

Procedure TTypesForm.AppsBoxOnItemFocus (Sender: TObject; Index: LongInt);
Begin
  ChoosedApp := AppsBox.Items[Index];
End;

Procedure TTypesForm.bOtherOnClick (Sender: TObject);
var
  fname: String;
Begin

  {other program selection}
  fname := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩'),
    path, pdeLoadNLS('ppPrograms', 'ணࠬ')+' (*.exe;*.com;*.cmd;*.bat)|');
  if fname <> '' then
    begin
    ChoosedApp := fname;
    //AppsBox.Items.Add(fname);
    AppsBox.AddBitmap(fname, Image1.Bitmap);
    end;

End;

Procedure TTypesForm.TypesFormOnShow (Sender: TObject);
var
  afile: TextFile;
  i: Integer;
  t: String;
Begin

  Caption := MainForm.mEditAssoc.Caption+' "'+ChoosedType+'"';
  Color := MainForm.Color;
  Label1.Caption := pdeLoadNLS('dlgEditAssoc1', 'Choose program to open selected data file from the list below');
  bOther.Caption := pdeLoadNLS('dlgEditAssoc2', 'Other program...');
  bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
  //Img.Icon := TIcon(MainForm.vFiles.Items[MainForm.vFiles.ItemIndex].Icon.Copy);
  bmp := MainForm.vFiles.Items[MainForm.vFiles.ItemIndex].Icon;

  AppsBox.Clear;
  if assocCount>0 then
    for i:=1 to assocCount do
      if (assoc[i].pgm <> 'TYPE') then
        //AppsBox.Items.Add(assoc[i].pgm); {old TListBox}
          AppsBox.AddBitmap(assoc[i].pgm, Image1.Bitmap); {new TBitmapListBox}

  if FileExists(extractfilepath(application.exename)+'\PDEConf\openwith.cfg') then
  begin
  assignfile(afile, extractfilepath(application.exename)+'\PDEConf\openwith.cfg');
  reset(afile);
  while not(eof(afile)) do
    begin
    readln(afile);
    readln(afile, t);
    //AppsBox.Items.Add(t);
    AppsBox.AddBitmap(t, Image1.Bitmap);
    end;
  closefile(afile);
  end;

End;

Procedure TTypesForm.TypesFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsStealthDlg;

End;

Initialization
  RegisterClasses ([TTypesForm, TLabel, TButton, TBevel
   , TPanel, TImage, TBitmapListBox, TPaintBox]);
End.
