Unit fhUnit3;

Interface

Uses
  Classes, Forms, Graphics, ExtCtrls, StdCtrls, Buttons
  , SysUtils, BSEDos
  , pdeNLS, pdeDlgs;

Type
  TThemeForm = Class (TForm)
    Shape1: TShape;
    Label1: TLabel;
    Bevel1: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    BoxTheme: TListBox;
    BoxITheme: TListBox;
    pTheme: TPanel;
    pITheme: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    edEditor: TEdit;
    bEditor: TButton;
    edFinder: TEdit;
    bFinder: TButton;
    Bevel2: TBevel;
    bOK: TButton;
    bCancel: TButton;
    imgTheme: TImage;
    imgITheme: TImage;
    Image1: TImage;
    Procedure bOKOnClick (Sender: TObject);
    Procedure BoxIThemeOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure BoxThemeOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure BoxIThemeOnItemSelect (Sender: TObject; Index: LongInt);
    Procedure BoxThemeOnItemSelect (Sender: TObject; Index: LongInt);
    Procedure bFinderOnClick (Sender: TObject);
    Procedure bEditorOnClick (Sender: TObject);
    Procedure ThemeFormOnShow (Sender: TObject);
    Procedure ThemeFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  ThemeForm: TThemeForm;

Implementation

Uses Unit1;

Procedure TThemeForm.bOKOnClick (Sender: TObject);
var
  cfgData: TStringList;
  tmpstr: String;
Begin

//--button "OK", we must save changed setting--
findutil := edFinder.Text;
txtutil := edEditor.Text;
cfgData:= TStringList.Create;
cfgData.Add('//Configuration file of FileHalf (PDE desktop, 2003-2004)');
cfgData.Add('//Directory (Folder) description file');
cfgData.Add('id_diz='+ pdeLoadCfgStr('filehalf.cfg', 'id_diz'));
cfgData.Add('//Show InfoPanel 1/0');
tmpstr := '0';
if MainForm.mInfopanel.Checked then tmpstr := '1';
cfgData.Add('ShowInfoPanel='+ tmpstr);
cfgData.Add('//Show Status 1/0');
tmpstr := '0';
if MainForm.mStatus.Checked then tmpstr := '1';
cfgData.Add('ShowStatus='+ tmpstr);
cfgData.Add('//Show Buttons 1/0');
tmpstr := '0';
if MainForm.mButtons.Checked then tmpstr := '1';
cfgData.Add('ShowButtons='+ tmpstr);
cfgData.Add('ShowButtonsText='+pdeLoadCfgStrD('filehalf.cfg', 'ShowButtonsText', '0'));
cfgData.Add('//preview wait time');
cfgData.Add('WaitForPreview='
  + pdeLoadCfgStrD('filehalf.cfg', 'WaitForPreview', '1000'));
cfgData.Add('//Type of View 0-pictograms, 1-tiles, 2-small icons, 3-columns, 4-text');
tmpstr := '0';
if MainForm.mTile.Checked then tmpstr := '1'
else if MainForm.mSmallIcons.Checked then tmpstr := '2'
else if MainForm.mFlow.Checked then tmpstr := '3'
else if MainForm.mAsText .Checked then tmpstr := '4';
cfgData.Add('ViewType='+ tmpstr);
cfgData.Add('//theme (pictures on tool-buttons, logo, colors)');
cfgData.Add('Theme='+Theme);
cfgData.Add('//pictograms for filetypes theme');
cfgData.Add('ITheme='+ITheme);
cfgData.Add('//additional utilities');
cfgData.Add('//Search');
cfgData.Add('FindUtil='+ edFinder.Text);
cfgData.Add('//text editor');
cfgData.Add('TextUtil='+ edEditor.Text);
cfgData.Add('//archiver');
cfgData.Add('Archiver='+ pdeLoadCfgStr('filehalf.cfg', 'Archiver'));

pdeSaveCfgFile('filehalf.cfg', cfgData);
cfgData.Free;

End;

Procedure TThemeForm.BoxIThemeOnItemFocus (Sender: TObject; Index: LongInt);
Begin

  //--we need to show preview--
  ITheme := BoxITheme.Items[BoxITheme.ItemIndex];
  if FileExists(ExtractFilePath(Application.ExeName)+'Bitmaps\'
    +BoxITheme.Items[BoxITheme.ItemIndex]+'\preview.bmp') then
  imgITheme.Bitmap.LoadFromFile(ExtractFilePath(Application.ExeName)+'Bitmaps\'
    +BoxITheme.Items[BoxITheme.ItemIndex]+'\preview.bmp');

End;

Procedure TThemeForm.BoxThemeOnItemFocus (Sender: TObject; Index: LongInt);
Begin

  //--we need to show preview--
  Theme := BoxTheme.Items[BoxTheme.ItemIndex];
  if FileExists(ExtractFilePath(Application.ExeName)+'Bitmaps\'
    +BoxTheme.Items[BoxTheme.ItemIndex]+'\preview.bmp') then
  imgTheme.Bitmap.LoadFromFile(ExtractFilePath(Application.ExeName)+'Bitmaps\'
    +BoxTheme.Items[BoxTheme.ItemIndex]+'\preview.bmp');


End;

Procedure TThemeForm.BoxIThemeOnItemSelect (Sender: TObject; Index: LongInt);
Begin

End;

Procedure TThemeForm.BoxThemeOnItemSelect (Sender: TObject; Index: LongInt);
Begin

End;

Procedure TThemeForm.bFinderOnClick (Sender: TObject);
Begin

  //--choose finder--
  edFinder.Text:=pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩'),
   path, pdeLoadNLS('ppPrograms', 'ணࠬ')+' (*.exe;*.com;*.cmd;*.bat)|');

End;

Procedure TThemeForm.bEditorOnClick (Sender: TObject);
Begin

  //--choose editor--
  edEditor.Text:=pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩'),
   path, pdeLoadNLS('ppPrograms', 'ணࠬ')+' (*.exe;*.com;*.cmd;*.bat)|');

End;

Procedure TThemeForm.ThemeFormOnShow (Sender: TObject);
var
  sr: TSearchRec;
  rez: Integer;
Begin
  //--load NLS strings--
  Caption := pdeLoadNLS('menuConfigPDE', 'ன');
  Color := MainForm.Color;
  Label1.Caption := pdeLoadNLS('pdeFileHalf', '㔠');
  Label2.Caption := pdeLoadNLS('fhChooseTheme', '롥p ⥬ p');
  Label3.Caption := pdeLoadNLS('fhChooseITheme', '롥p ⥬ ⮣p');
  Label4.Caption := pdeLoadNLS('fhTextEditor', '⮢ pp');
  Label5.Caption := pdeLoadNLS('pFinderInfo2', '⨫  ᪠ 䠩  ');
  bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');

  //--load config data--
  edEditor.Text := pdeLoadCfgStr('filehalf.cfg', 'TextUtil');
  edFinder.Text := pdeLoadCfgStr('filehalf.cfg', 'FindUtil');

  //imgTheme.Bitmap.Clear;
  //imgITheme.Clear;
  BoxTheme.Clear;
  BoxITheme.Clear;
  rez:=FindFirst(ExtractFilePath(Application.ExeName)+'Bitmaps\*_theme', faAnyFile, sr);
  if (sr.attr and faDirectory)<>0 then //folder
      if (sr.name <> '.') and (sr.name <> '..') then
      begin
        BoxTheme.Items.Add(sr.name);
        BoxITheme.Items.Add(sr.name);
      end;
  while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)<>0 then //folder
      if (sr.name <> '.') and (sr.name <> '..') then
      begin
        BoxTheme.Items.Add(sr.name);
        BoxITheme.Items.Add(sr.name);
      end;
    end;
  FindClose(sr);

End;

Procedure TThemeForm.ThemeFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsDialog;

End;

Initialization
  RegisterClasses ([TThemeForm, TShape, TLabel, TBevel, TListBox, TPanel, TEdit,
    TButton, TImage]);
End.
