//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit10;

Interface

Uses
  Classes, Forms, Graphics, Dialogs, CustomFileControls, FileCtrl, Buttons,
  StdCtrls, pdeNLS, Unit1, Unit2, BSEDos, SysUtils;

Type
  TDirDialog = Class (TForm)
    dirs: TCustomDirectoryListBox;
    bOK: TButton;
    bCancel: TButton;
    Label1: TLabel;
    Drives: TCustomDriveComboBox;
    bNew: TButton;
    Label2: TLabel;
    Procedure bCancelOnClick (Sender: TObject);
    Procedure bOKOnClick (Sender: TObject);
    Procedure bNewOnClick (Sender: TObject);
    Procedure DirDialogOnResize (Sender: TObject);
    Procedure DirDialogOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  DirDialog: TDirDialog;

function pdeChooseDirDialog(cptn, text: String): String;

Implementation

function pdeChooseDirDialog(cptn, text: String): String;
begin

  {cool choose directory dialog}
  //Application.Create;
  DirDialog := TDirDialog.Create(nil);

  DirDialog.Caption := cptn;
  DirDialog.Label2.Caption := text;
  Result := '';

  if DirDialog.Showmodal = cmOK then
    Result := DirDialog.Label1.Caption;

  DirDialog.Free;
  //Application.Destroy;

end;

Procedure TDirDialog.bCancelOnClick (Sender: TObject);
Begin

End;

Procedure TDirDialog.bOKOnClick (Sender: TObject);
Begin

End;

Procedure TDirDialog.bNewOnClick (Sender: TObject);
var
  path, newname: String;
Begin

  path := label1.Caption;
  newname := pdePromptDialog(pdeLoadNLS('pdeDlgCreateFolder', '   ')
    , pdeLoadNLS('pdeDlgHint5', ' '), '');

  if newname <> '' then
    begin
    path := ConcatFileName(path, newname);
    if DosCreateDir(path, nil) <> 0 then
      pdeMessageBoxOK(pdeLoadNLS('dlgErrorOnFolderCreate', 'H 㤠 ᮧ .')
        , pdeLoadNLS('dlgError', '訡'), Icon.Handle)
    else
      Dirs.Directory := path;
    end;

End;

Procedure TDirDialog.DirDialogOnResize (Sender: TObject);
Begin
  Drives.Width := ClientWidth - 20;
End;

Procedure TDirDialog.DirDialogOnCreate (Sender: TObject);
Begin

  bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
  bNew.Caption := pdeLoadNLS('pdeDlgHint5', ' ');

End;

Initialization
  RegisterClasses ([TDirDialog, TCustomDirectoryListBox, TButton,
    TLabel, TCustomDriveComboBox]);
End.
