//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit11;

Interface

Uses
  Classes, Forms, Graphics, pdeNLS, Buttons, StdCtrls, ExtCtrls
  , Dos, SysUtils;

Type
  TPassChange = Class (TForm)
    bOK: TButton;
    bCancel: TButton;
    chPass: TCheckBox;
    Bevel1: TBevel;
    newname: TLabel;
    newpass: TLabel;
    edName: TEdit;
    edPass: TEdit;
    edPass2: TEdit;
    Label1: TLabel;
    Procedure bCancelOnClick (Sender: TObject);
    Procedure bOKOnClick (Sender: TObject);
    Procedure PassChangeOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  PassChange: TPassChange;

function pdeAuthorizationManager: Integer;

Implementation

function pdeAuthorizationManager: Integer;
begin

  {allow user to set up login and password, and on/off login dialog}
  //Application.Create;
  PassChange := TPassChange.Create(nil);
  PassChange.ActiveControl := PassChange.edName;
  PassChange.ShowModal;

  PassChange.Free;
  //Application.Destroy;

end;

Procedure TPassChange.bCancelOnClick (Sender: TObject);
Begin

End;

Procedure TPassChange.bOKOnClick (Sender: TObject);
var
  afile: TextFile;
  pdepath: String;
Begin

  if (edPass.Text <> edPass2.Text) then
    begin
    edPass.Text := '';
    edPass2.Text := '';
    ActiveControl := edPass;
    exit;
    end;

  //PDE home directory from config.sys
  pdepath := getenv('PDE_HOME');
  if pdepath = '' then
    pdepath := 'c:\pde';

  if chPass.Checked then
    begin
    AssignFile(afile, pdepath+'\PDEConf\pswd.cfg');
    Rewrite(afile);
    Writeln(afile, edName.Text);
    Writeln(afile, edPass.Text);
    CloseFile(afile);
    end
  else
    begin
    DeleteFile(pdepath+'\PDEConf\pswd.cfg');
    end;

  Close;

End;

Procedure TPassChange.PassChangeOnCreate (Sender: TObject);
Begin

  BorderStyle := bsDialog;
  Caption := pdeLoadNLS('Authorization1', 'pp p p樥 ');
  chPass.Caption := pdeLoadNLS('Authorization3', 'ᯮ짮 p (p)');
  Label1.Caption := pdeLoadNLS('Authorization2', '    p');
  newname.caption := pdeLoadNLS('pdmLogonName', '');
  newpass.caption := pdeLoadNLS('pdmLogonPass', '஫');
  bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');

End;

Initialization
  RegisterClasses ([TPassChange, TButton, TLabel, TCheckBox, TBevel, TEdit]);
End.
