//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit3;

Interface

Uses
  Classes, Forms, Graphics, pdeNLS, ColorWheel, ExtCtrls
  , StdCtrls, Buttons, SysUtils;

Type
  TColorForm = Class (TForm)
    ColorWheel: TColorWheel;
    ValueBar: TValueBar;
    Shape: TShape;
    lRed: TLabel;
    lGreen: TLabel;
    lBlue: TLabel;
    edRed: TEdit;
    edGreen: TEdit;
    edBlue: TEdit;
    Bevel: TBevel;
    bOK: TButton;
    bCancel: TButton;
    Procedure ColorFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    procedure ColorChange(Sender: TObject);
    procedure EditChange (Sender: TObject);
  End;

Var
  ColorForm: TColorForm;

function pdeColorDialog(var Color: TColor): Boolean;

Implementation

function pdeColorDialog(var Color: TColor): Boolean;
begin

  {color choose dialog}
  //Application.Create;
  ColorForm := TColorForm.Create(nil);
  ColorForm.Caption := pdeLoadNLS('dlgChooseColor', '롥 梥:');

  Result := False;

  if ColorForm.ShowModal = cmOK then
    begin
    Color := ColorForm.ValueBar.SelectedColor;
    Result := True;
    end;

  ColorForm.Free;
  //Application.Destroy;

end;

Procedure TColorForm.ColorFormOnCreate (Sender: TObject);
Begin

BorderStyle := bsDialog;

ColorWheel:= TColorWheel.Create(Self);
ColorWheel.Parent := Self;
ColorWheel.Width := 160;
ColorWheel.Height := 160;
ColorWheel.Left := 16;
ColorWheel.Top := 16;

ValueBar:= TValueBar.Create(Self);
ValueBar.Parent := Self;
ValueBar.Width := 50;
ValueBar.Height := 160;
ValueBar.Left := 180;
ValueBar.Top := 16;
ColorWheel.ValueBar := ValueBar;
ValueBar.OnChange := ColorChange;

Shape:= TShape.Create(Self);
Shape.Parent := Self;
Shape.Width := 90;
Shape.Height := 60;
Shape.Left := 250;
Shape.Top := 16;

lRed:= TLabel.Create(Self);
lRed.Parent := Self;
lRed.Caption := 'R:';
lRed.Width := 30;
lRed.Left := 250;
lRed.Top := 95;

lGreen:= TLabel.Create(Self);
lGreen.Parent := Self;
lGreen.Caption := 'G:';
lGreen.Width := 30;
lGreen.Left := 250;
lGreen.Top := 125;

lBlue:= TLabel.Create(Self);
lBlue.Parent := Self;
lBlue.Caption := 'B:';
lBlue.Width := 30;
lBlue.Left := 250;
lBlue.Top := 155;

edRed:= TEdit.Create(Self);
edRed.Parent := Self;
edRed.NumbersOnly := True;
edRed.Width := 60;
edRed.Left := 280;
edRed.Top := 90;
edRed.OnChange := EditChange;

edGreen:= TEdit.Create(Self);
edGreen.Parent := Self;
edGreen.NumbersOnly := True;
edGreen.Width := 60;
edGreen.Left := 280;
edGreen.Top := 120;
edGreen.OnChange := EditChange;

edBlue:= TEdit.Create(Self);
edBlue.Parent := Self;
edBlue.NumbersOnly := True;
edBlue.Width := 60;
edBlue.Left := 280;
edBlue.Top := 150;
edBlue.OnChange := EditChange;

Bevel:= TBevel.Create(Self);
Bevel.Parent := Self;
Bevel.Shape := bsTopLine;
Bevel.Width := 325;
Bevel.Height := 8;
Bevel.Left := 16;
Bevel.Top := 190;

bOK:= TButton.Create(Self); bOK.Parent := Self;
bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
bOK.Height := 28; bOK.Left := 170;
bOK.Top := 205;
bOK.Default := True;
bOK.Align := alFixedLeftTop;
bOK.Command := cmOK; bOK.ModalResult := cmOK;

bCancel:= TButton.Create(Self); bCancel.Parent := Self;
bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
bCancel.Height := 28; bCancel.Left := 260;
bCancel.Top := 205;
bCancel.Align := alFixedLeftTop;
bCancel.Command := cmCancel; bCancel.ModalResult := cmCancel;

End;

Procedure TColorForm.ColorChange (Sender: TObject);
Var
  Red,Green,Blue: Byte;
Begin
  Shape.Brush.Color := ValueBar.SelectedColor;
  Shape.Invalidate;
  RGBToValues(ValueBar.SelectedColor, Red,Green,Blue);
  edRed.Text := IntToStr(Red);
  edGreen.Text := IntToStr(Green);
  edBlue.Text := IntToStr(Blue);
End;

//-----------------------------------------

Procedure TColorForm.EditChange (Sender: TObject);
Var
  Red,Green,Blue: Byte;
Begin
  {Red := StrToInt(edRed.Text);
  Green := StrToInt(edGreen.Text);
  Blue := StrToInt(edBlue.Text);
  ColorWheel.SetSelectedColor(ValuesToRGB(Red,Green,Blue));
  Shape.Brush.Color := ValueBar.SelectedColor;
  Shape.Invalidate;}
End;

Initialization
  RegisterClasses ([TColorForm, TShape, TLabel, TButton]);
End.
