//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit9;

Interface

Uses
  Classes, Forms, Graphics, ExtCtrls, StdCtrls, coolbar2, XplorBtn
  , pdeNLS, PMWin, os2def, BSEDOS, SysUtils, Dos, Buttons;

Type
  TLoginForm = Class (TForm)
    Bevel1: TBevel;
    Bevel2: TBevel;
    edName: TEdit;
    edPass: TEdit;
    name: TLabel;
    password: TLabel;
    bReboot: TExplorerButton;
    bShutdown: TExplorerButton;
    bLogin: TExplorerButton;
    restart: TLabel;
    shutdown: TLabel;
    login: TLabel;
    pde: TLabel;
    version: TLabel;
    Image1: TImage;
    wellcome: TLabel;
    bGo: TButton;
    Procedure edPassOnEnter (Sender: TObject);
    Procedure bRebootOnClick (Sender: TObject);
    Procedure bShutdownOnClick (Sender: TObject);
    Procedure bLoginOnClick (Sender: TObject);
    Procedure LoginFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

  TProgressForm = class(TForm)
    text1: TLabel;
  Public
    {Insert public declarations here}
    Constructor Create(AOwner:TComponent); Override;
  End;

Var
  LoginForm: TLoginForm;
  UserName, PassName: String;

procedure ShowProgressS(text: String; interval: Integer);

//return PDE_HOME variable from "CONFIG.SYS" or "c:\pde"
function PDEFolder: String;

{interface to the APM/2 program by Roman Stangl}
{req = suspend/standby/any_to_turn_off}
procedure APMShutdown(req: String);

{simple function to start another program}
function ShellExecuteS(fname, fdir, fparam: string): LongInt;

{if "shortcut" parameter "true", then "fparam" will not be in ""}
function ShellExecute(fname, fdir, fparam: string; shortcut: boolean): LongInt;

{more complex one:
"fg" = ssf_Fgbg_Fore/ssf_Fgbg_Back
, "pgmCntr" = ssf_Control_Visible/SSF_CONTROL_INVISIBLE etc
, "rel" = ssf_Related_Independent/SSF_RELATED_CHILD}
function _ShellExecute(fname, fdir, fparam: string; shortcut: boolean; fg, pgmCntr, rel: ULong): LongInt;

function LoginDlg(user, pass: String; reboot, shutdown: Boolean): Integer;

Implementation

function PDEFolder: String;
begin

  Result := getenv('PDE_HOME');
  if Result = '' then
    Result := 'c:\pde';

end;

procedure ShowProgressS(text: String; interval: Integer);
var
  pr: TProgressForm;
begin

  //Application.Create;
  pr := TProgressForm.Create(nil);

  pr.Show;
  pr.text1.caption := text;
  pr.BringToFront;
  pr.Update;

  DosSleep(interval*1000);

  pr.Destroy;

  //Application.Destroy;

end;

//------------------------------------------

function LoginDlg(user, pass: String; reboot, shutdown: Boolean): Integer;
begin

  //Application.Create;
  LoginForm := TLoginForm.Create(Application.MainForm);
  LoginForm.ClientWidth := 330;
  LoginForm.ClientHeight := 210;

  Result := 0;

  UserName := user;
  PassName := pass;
  if not reboot then
    begin
    LoginForm.bReboot.Visible := False;
    LoginForm.restart.Visible := False;
    end;
  if not shutdown then
    begin
    LoginForm.bShutdown.Visible := False;
    LoginForm.shutdown.Visible := False;
    end;

  LoginForm.ShowModal;

  if LoginForm<>nil then
    LoginForm.Free;

  //Application.Destroy;

end;

Procedure TLoginForm.edPassOnEnter (Sender: TObject);
Begin

  bGo.Default := True;

End;

Procedure TLoginForm.bRebootOnClick (Sender: TObject);
Begin

  _ShellExecute('setboot.exe', '', '/B', True, ssf_Fgbg_Back
    , SSF_CONTROL_INVISIBLE, ssf_Related_Independent);

End;

Procedure TLoginForm.bShutdownOnClick (Sender: TObject);
Begin

  APMShutdown('turnoff');

End;

Procedure TLoginForm.bLoginOnClick (Sender: TObject);
Begin

  if ((edName.Text = UserName) and (edPass.Text = PassName)) then
    Close
  else
    begin
    edPass.Text := '';
    ActiveControl := edPass;
    end;

End;

Procedure TLoginForm.LoginFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsStealth;
  //WinSetWindowULong(Frame.Handle, QWL_STYLE
  //  , WinQueryWindowULong(Frame.Handle, QWL_STYLE) or WS_TOPMOST);
  ActiveControl := edName;
  pde.caption := pdeLoadNLS('pdeShortName', '  ');
  version.caption := pdeLoadNLS('pdeVersion', ' x.xx');
  wellcome.caption := pdeLoadNLS('pdmLogonWellcome', ' !');
  name.caption := pdeLoadNLS('pdmLogonName', '');
  password.caption := pdeLoadNLS('pdmLogonPass', '஫');
  restart.caption := pdeLoadNLS('pdmLogonRestart', '१㧪');
  shutdown.caption := pdeLoadNLS('pdmLogonTurnoff', '몫');
  login.caption := pdeLoadNLS('pdmLogonLogin', '');

End;

//------------------------------------------

function _ShellExecute(fname, fdir, fparam: string; shortcut: boolean; fg, pgmCntr, rel: ULong): LongInt;
var
  sd: StartData;
  idSession: ULong;
  apid: PID;
  fname2, fparam2: pchar;
  rc, rc2: APIRET;
begin

if not(shortcut) and (fparam <> '') then
  fparam:='"'+fparam+'"';  //<-  ஡    䠩

new(fname2);
new(fparam2);
fname2 := StrPCopy(fname2, fname);
fparam2 := StrPCopy(fparam2, fparam);

with sd do
  begin
      Length   := sizeof(StartData);
      Related  := rel;//ssf_Related_Independent; // start an independent session
      FgBg     := fg;//ssf_Fgbg_Fore;           // start session in foreground
      TraceOpt := ssf_TraceOpt_None;       // No trace
      PgmTitle := fname2;
      PgmName := fname2;
      PgmInputs :=fparam2;
      TermQ := nil;                        // No termination queue
      Environment := nil;                  // No environment string
      InheritOpt := 0; //ssf_InhertOpt_Parent;
      SessionType := 0;//ssf_Type_Default;
      IconFile := nil;                     // No icon association
      PgmHandle := 0;
      PgmControl := pgmCntr;//ssf_Control_Visible;
      InitXPos  := 0;     // Initial window coordinates
      InitYPos  := 0;
      InitXSize := 200;    // Initial window size
      InitYSize := 140;
      Reserved := 0;
      ObjectBuffer  := nil;
      ObjectBuffLen := 0;
  end;

if length(fdir)>3 then
  Delete(fdir, length(fdir), 1); //delete "\"

DosSetDefaultDisk(ord(LowerCase(fdir)[1])-96);
DosSetCurrentDir(fdir);

rc2:=DosStartSession(sd, idSession, apid);

freemem(fname2, sizeof(fname2));
freemem(fparam2, sizeof(fparam2));

Result := rc2;

end;

function ShellExecute(fname, fdir, fparam: string; shortcut: boolean): LongInt;
begin
  Result := _ShellExecute(fname, fdir, fparam, shortcut, ssf_Fgbg_Fore
    , ssf_Control_Visible, ssf_Related_Independent);
end;

function ShellExecuteS(fname, fdir, fparam: string): LongInt;
begin
  Result := _ShellExecute(fname, fdir, fparam, false, ssf_Fgbg_Fore
    , ssf_Control_Visible, ssf_Related_Independent);
end;

//------------------------------------------

procedure APMShutdown(req: String);
var
  homepath: String;
Begin

//PDE home directory from config.sys
  homepath := getenv('PDE_HOME');
  if homepath = '' then
    homepath := 'c:\pde';

if FileExists(homepath+'\Utils\APM\apm.exe') then
  begin
  if req = 'suspend' then
    begin
    _ShellExecute(homepath+'\Utils\APM\apm.exe', '', '/Suspend', True
      , ssf_Fgbg_Back, SSF_CONTROL_INVISIBLE, ssf_Related_Independent);
    end
  else if req = 'standby' then
    begin
    _ShellExecute(homepath+'\Utils\APM\apm.exe', '', '/Standby', True
      , ssf_Fgbg_Back, SSF_CONTROL_INVISIBLE, ssf_Related_Independent);
    end
  else //turnoff
    begin
    _ShellExecute(homepath+'\Utils\APM\apm.exe', '', '/Poweroff-', True
      , ssf_Fgbg_Back, SSF_CONTROL_INVISIBLE, ssf_Related_Independent);
    end;
  end
  else
  begin
    _ShellExecute('shutdown.exe', '', '', True
      , ssf_Fgbg_Back, SSF_CONTROL_INVISIBLE, ssf_Related_Independent);
  end;

  ShowProgressS(pdeLoadNLS('dlgPerforming', 'Performing...'), 20);

End;

//------------------------------------------

Constructor TProgressForm.Create(AOwner:TComponent);
Begin

  inherited Create(AOwner);
  Position := poScreenCenter;
  BorderIcons :=[];
  BorderStyle := bsStealthSize;
  Font.Name := 'WarpSans:9';
  ClientWidth := 250;
  ClientHeight := 50;
  Caption := '';

  text1 := InsertLabel(self, 8, 8, 234, 20, '');
  text1.Align := alFrame;
  text1.Alignment := taCenter;
  text1.Visible := true;

End;

Initialization
  RegisterClasses ([TLoginForm, TBevel, TEdit, TLabel, TExplorerButton, TImage,
    TButton]);
End.
